/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.renderer;

import java.awt.Color;
import java.awt.Container;
import java.io.Serializable;
import javax.swing.JComponent;
import org.jdesktop.swingx.renderer.CellContext;
import org.jdesktop.swingx.renderer.PainterAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultVisuals<T extends JComponent>
implements Serializable {
    private Color unselectedForeground;
    private Color unselectedBackground;

    public void setForeground(Color color) {
        this.unselectedForeground = color;
    }

    public void setBackground(Color color) {
        this.unselectedBackground = color;
    }

    public void configureVisuals(T t, CellContext cellContext) {
        this.configureState(t, cellContext);
        this.configureColors(t, cellContext);
        this.configureBorder(t, cellContext);
        this.configurePainter(t, cellContext);
    }

    protected void configurePainter(T t, CellContext cellContext) {
        if (t instanceof PainterAware) {
            ((PainterAware)t).setPainter(null);
        }
    }

    protected void configureState(T t, CellContext cellContext) {
        ((JComponent)t).setToolTipText(null);
        this.configureSizes(t, cellContext);
        if (cellContext.getComponent() != null) {
            ((JComponent)t).setFont(cellContext.getComponent().getFont());
            ((JComponent)t).setEnabled(cellContext.getComponent().isEnabled());
            ((Container)t).applyComponentOrientation(cellContext.getComponent().getComponentOrientation());
        }
    }

    protected void configureSizes(T t, CellContext cellContext) {
        ((JComponent)t).setPreferredSize(null);
        ((JComponent)t).setMinimumSize(null);
        ((JComponent)t).setMaximumSize(null);
    }

    protected void configureColors(T t, CellContext cellContext) {
        if (cellContext.isSelected()) {
            ((JComponent)t).setForeground(cellContext.getSelectionForeground());
            ((JComponent)t).setBackground(cellContext.getSelectionBackground());
        } else {
            ((JComponent)t).setForeground(this.getForeground(cellContext));
            ((JComponent)t).setBackground(this.getBackground(cellContext));
        }
        if (cellContext.isFocused()) {
            this.configureFocusColors(t, cellContext);
        }
    }

    protected void configureFocusColors(T t, CellContext cellContext) {
        if (!cellContext.isSelected() && cellContext.isEditable()) {
            Color color = cellContext.getFocusForeground();
            if (color != null) {
                ((JComponent)t).setForeground(color);
            }
            if ((color = cellContext.getFocusBackground()) != null) {
                ((JComponent)t).setBackground(color);
            }
        }
    }

    protected void configureBorder(T t, CellContext cellContext) {
        ((JComponent)t).setBorder(cellContext.getBorder());
    }

    protected Color getForeground(CellContext cellContext) {
        if (this.unselectedForeground != null) {
            return this.unselectedForeground;
        }
        return cellContext.getForeground();
    }

    protected Color getBackground(CellContext cellContext) {
        if (this.unselectedBackground != null) {
            return this.unselectedBackground;
        }
        return cellContext.getBackground();
    }
}

