/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.basic;

import java.awt.Color;
import java.util.Calendar;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.jdesktop.swingx.JXMonthView;
import org.jdesktop.swingx.border.IconBorder;
import org.jdesktop.swingx.plaf.UIManagerExt;
import org.jdesktop.swingx.plaf.basic.CalendarState;
import org.jdesktop.swingx.renderer.CellContext;

class CalendarCellContext
extends CellContext {
    private int arrowPaddingX = 3;
    private int arrowPaddingY = 3;
    private CalendarState dayState;

    CalendarCellContext() {
    }

    public void installContext(JXMonthView jXMonthView, Calendar calendar, boolean bl, boolean bl2, CalendarState calendarState) {
        this.component = jXMonthView;
        this.dayState = calendarState;
        this.installState(calendar, -1, -1, bl, bl2, true, true);
    }

    public JXMonthView getComponent() {
        return (JXMonthView)super.getComponent();
    }

    public CalendarState getCalendarState() {
        return this.dayState;
    }

    public Calendar getCalendar() {
        return this.getValue() instanceof Calendar ? (Calendar)this.getValue() : null;
    }

    protected Color getForeground() {
        Color color;
        if (CalendarState.LEADING == this.dayState) {
            return this.getUIColor("leadingDayForeground");
        }
        if (CalendarState.TRAILING == this.dayState) {
            return this.getUIColor("trailingDayForeground");
        }
        if (CalendarState.TITLE == this.dayState && this.getComponent() != null) {
            return this.getComponent().getMonthStringForeground();
        }
        if (CalendarState.WEEK_OF_YEAR == this.dayState && (color = this.getUIColor("weekOfTheYearForeground")) != null) {
            return color;
        }
        if (CalendarState.DAY_OF_WEEK == this.dayState) {
            Color color2 = color = this.getComponent() != null ? this.getComponent().getDaysOfTheWeekForeground() : null;
            if (color != null) {
                return color;
            }
        }
        return (color = this.getFlaggedOrPerDayForeground()) != null ? color : super.getForeground();
    }

    private Color getUIColor(String string) {
        return UIManagerExt.getColor(this.getUIPrefix() + string);
    }

    protected Color getFlaggedOrPerDayForeground() {
        if (this.getComponent() != null && this.getCalendar() != null) {
            if (this.getComponent().isFlaggedDate(this.getCalendar().getTime())) {
                return this.getComponent().getFlaggedDayForeground();
            }
            Color color = this.getComponent().getPerDayOfWeekForeground(this.getCalendar().get(7));
            if (color != null) {
                return color;
            }
        }
        return null;
    }

    protected Color getBackground() {
        if (CalendarState.TITLE == this.dayState && this.getComponent() != null) {
            return this.getComponent().getMonthStringBackground();
        }
        return super.getBackground();
    }

    protected Color getSelectionBackground() {
        if (CalendarState.LEADING == this.dayState || CalendarState.TRAILING == this.dayState) {
            return this.getBackground();
        }
        return this.getComponent() != null ? this.getComponent().getSelectionBackground() : null;
    }

    protected Color getSelectionForeground() {
        if (CalendarState.LEADING == this.dayState || CalendarState.TRAILING == this.dayState) {
            return this.getForeground();
        }
        Color color = this.getFlaggedOrPerDayForeground();
        if (color != null) {
            return color;
        }
        return this.getComponent() != null ? this.getComponent().getSelectionForeground() : null;
    }

    protected Border getBorder() {
        if (this.getComponent() == null) {
            return super.getBorder();
        }
        if (CalendarState.TITLE == this.dayState) {
            return this.getTitleBorder();
        }
        if (this.isToday()) {
            int n = this.getComponent().getBoxPaddingX();
            int n2 = this.getComponent().getBoxPaddingY();
            Border border = BorderFactory.createLineBorder(this.getComponent().getTodayBackground());
            Border border2 = BorderFactory.createEmptyBorder(n2 - 1, n - 1, n2 - 1, n - 1);
            return BorderFactory.createCompoundBorder(border, border2);
        }
        return BorderFactory.createEmptyBorder(this.getComponent().getBoxPaddingY(), this.getComponent().getBoxPaddingX(), this.getComponent().getBoxPaddingY(), this.getComponent().getBoxPaddingX());
    }

    private Border getTitleBorder() {
        if (this.getComponent().isTraversable()) {
            Icon icon = UIManager.getIcon("JXMonthView.monthDownFileName");
            Icon icon2 = UIManager.getIcon("JXMonthView.monthUpFileName");
            IconBorder iconBorder = new IconBorder(icon2, 3, this.arrowPaddingX);
            IconBorder iconBorder2 = new IconBorder(icon, 7, this.arrowPaddingX);
            CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(iconBorder, iconBorder2);
            Border border = BorderFactory.createEmptyBorder(2 * this.arrowPaddingY, 0, 2 * this.arrowPaddingY, 0);
            return BorderFactory.createCompoundBorder(compoundBorder, border);
        }
        return BorderFactory.createEmptyBorder(this.getComponent().getBoxPaddingY(), this.getComponent().getBoxPaddingX(), this.getComponent().getBoxPaddingY(), this.getComponent().getBoxPaddingX());
    }

    protected boolean isToday() {
        return CalendarState.TODAY == this.dayState;
    }

    protected String getUIPrefix() {
        return "JXMonthView.";
    }
}

