/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.painter;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import javax.swing.JComponent;
import org.jdesktop.swingx.painter.AbstractAreaPainter;
import org.jdesktop.swingx.painter.effects.AreaEffect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShapePainter
extends AbstractAreaPainter<Object> {
    private Shape shape;

    public ShapePainter() {
        this.shape = new Ellipse2D.Double(0.0, 0.0, 100.0, 100.0);
        this.setBorderWidth(3.0f);
        this.setFillPaint(Color.RED);
        this.setBorderPaint(Color.BLACK);
    }

    public ShapePainter(Shape shape) {
        this.shape = shape;
    }

    public ShapePainter(Shape shape, Paint paint) {
        this.shape = shape;
        this.setFillPaint(paint);
    }

    public ShapePainter(Shape shape, Paint paint, AbstractAreaPainter.Style style) {
        this.shape = shape;
        this.setFillPaint(paint);
        this.setStyle(style == null ? AbstractAreaPainter.Style.BOTH : style);
    }

    public void setShape(Shape shape) {
        Shape shape2 = this.getShape();
        this.shape = shape;
        this.setDirty(true);
        this.firePropertyChange("shape", shape2, this.getShape());
    }

    public Shape getShape() {
        return this.shape;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void doPaint(Graphics2D graphics2D, Object object, int n, int n2) {
        BasicStroke basicStroke = new BasicStroke(this.getBorderWidth());
        graphics2D.setStroke(basicStroke);
        if (this.getShape() == null) return;
        Shape shape = this.provideShape(graphics2D, object, n, n2);
        Rectangle rectangle = shape.getBounds();
        Rectangle rectangle2 = this.calculateLayout(rectangle.width, rectangle.height, n, n2);
        graphics2D = (Graphics2D)graphics2D.create();
        try {
            graphics2D.translate(rectangle2.x, rectangle2.y);
            this.drawPathEffects(graphics2D, shape, rectangle2.width, rectangle2.height);
            switch (this.getStyle()) {
                case BOTH: {
                    this.drawShape(graphics2D, shape, object, rectangle2.width, rectangle2.height);
                    this.fillShape(graphics2D, shape, object, rectangle2.width, rectangle2.height);
                    return;
                }
                case FILLED: {
                    this.fillShape(graphics2D, shape, object, rectangle2.width, rectangle2.height);
                    return;
                }
                case OUTLINE: {
                    this.drawShape(graphics2D, shape, object, rectangle2.width, rectangle2.height);
                    return;
                }
            }
            return;
        }
        finally {
            graphics2D.dispose();
        }
    }

    private void drawShape(Graphics2D graphics2D, Shape shape, Object object, int n, int n2) {
        graphics2D.setPaint(this.calculateStrokePaint(object, n, n2));
        graphics2D.draw(shape);
    }

    private void fillShape(Graphics2D graphics2D, Shape shape, Object object, int n, int n2) {
        graphics2D.setPaint(this.calculateFillPaint(object, n, n2));
        graphics2D.fill(shape);
    }

    @Override
    protected Shape provideShape(Graphics2D graphics2D, Object object, int n, int n2) {
        return this.getShape();
    }

    private Paint calculateStrokePaint(Object object, int n, int n2) {
        Paint paint = this.getBorderPaint();
        if (paint == null && object instanceof JComponent) {
            paint = ((JComponent)object).getForeground();
        }
        if (this.isPaintStretched()) {
            paint = this.calculateSnappedPaint(paint, n, n2);
        }
        return paint;
    }

    private Paint calculateFillPaint(Object object, int n, int n2) {
        Paint paint = this.getFillPaint();
        if (this.isPaintStretched()) {
            paint = this.calculateSnappedPaint(paint, n, n2);
        }
        if (paint == null && object instanceof JComponent) {
            paint = ((JComponent)object).getBackground();
        }
        return paint;
    }

    private void drawPathEffects(Graphics2D graphics2D, Shape shape, int n, int n2) {
        if (this.getAreaEffects() != null) {
            for (AreaEffect areaEffect : this.getAreaEffects()) {
                areaEffect.apply(graphics2D, shape, n, n2);
            }
        }
    }
}

