/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.painter;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.RoundRectangle2D;
import org.jdesktop.swingx.painter.AbstractAreaPainter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CapsulePainter
extends AbstractAreaPainter<Object> {
    private Portion portion;

    public CapsulePainter() {
        this.setPortion(Portion.Full);
    }

    public CapsulePainter(Portion portion) {
        this.setPortion(portion);
    }

    public Portion getPortion() {
        return this.portion;
    }

    public void setPortion(Portion portion) {
        Portion portion2 = this.portion;
        this.portion = portion;
        this.setDirty(true);
        this.firePropertyChange("portion", (Object)portion2, (Object)this.getPortion());
    }

    @Override
    protected void doPaint(Graphics2D graphics2D, Object object, int n, int n2) {
        Shape shape = this.provideShape(graphics2D, object, n, n2);
        if (this.getStyle() == AbstractAreaPainter.Style.BOTH || this.getStyle() == AbstractAreaPainter.Style.FILLED) {
            graphics2D.setPaint(this.getFillPaint());
            graphics2D.fill(shape);
        }
        if (this.getStyle() == AbstractAreaPainter.Style.BOTH || this.getStyle() == AbstractAreaPainter.Style.OUTLINE) {
            graphics2D.setPaint(this.getBorderPaint());
            graphics2D.draw(shape);
        }
    }

    @Override
    protected Shape provideShape(Graphics2D graphics2D, Object object, int n, int n2) {
        int n3 = 10;
        int n4 = n2;
        int n5 = 0;
        if (this.getPortion() == Portion.Top) {
            n3 = n2 * 2;
            n4 = n2 * 2;
        }
        if (this.getPortion() == Portion.Bottom) {
            n3 = n2 * 2;
            n4 = n2 * 2;
            n5 = -n2;
        }
        return new RoundRectangle2D.Double(0.0, n5, n, n4, n3, n3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Portion {
        Top,
        Full,
        Bottom,
        Left,
        Right;

    }
}

