/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.painter;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import org.jdesktop.swingx.painter.AbstractLayoutPainter;
import org.jdesktop.swingx.painter.effects.AreaEffect;
import org.jdesktop.swingx.util.PaintUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAreaPainter<T>
extends AbstractLayoutPainter<T> {
    private boolean stretchPaint;
    private AreaEffect[] areaEffects = new AreaEffect[0];
    private Style style = Style.BOTH;
    private float borderWidth;
    private Paint fillPaint;
    private Paint borderPaint;

    public AbstractAreaPainter() {
        this.fillPaint = Color.RED;
    }

    public AbstractAreaPainter(Paint paint) {
        this.fillPaint = paint;
    }

    public Paint getFillPaint() {
        return this.fillPaint;
    }

    public void setFillPaint(Paint paint) {
        Paint paint2 = this.getFillPaint();
        this.fillPaint = paint;
        this.setDirty(true);
        this.firePropertyChange("paint", paint2, this.getFillPaint());
    }

    public boolean isPaintStretched() {
        return this.stretchPaint;
    }

    public void setPaintStretched(boolean bl) {
        boolean bl2 = this.isPaintStretched();
        this.stretchPaint = bl;
        this.setDirty(true);
        this.firePropertyChange("snapPaint", bl2, this.stretchPaint);
    }

    public void setBorderPaint(Paint paint) {
        Paint paint2 = this.getBorderPaint();
        this.borderPaint = paint;
        this.setDirty(true);
        this.firePropertyChange("borderPaint", paint2, this.getBorderPaint());
    }

    public Paint getBorderPaint() {
        return this.borderPaint;
    }

    public void setStyle(Style style) {
        Style style2 = this.getStyle();
        this.style = style == null ? Style.BOTH : style;
        this.setDirty(true);
        this.firePropertyChange("style", (Object)style2, (Object)this.getStyle());
    }

    public Style getStyle() {
        return this.style;
    }

    public void setBorderWidth(float f) {
        float f2 = this.getBorderWidth();
        this.borderWidth = f;
        this.setDirty(true);
        this.firePropertyChange("strokeWidth", Float.valueOf(f2), Float.valueOf(this.getBorderWidth()));
    }

    public float getBorderWidth() {
        return this.borderWidth;
    }

    Paint calculateSnappedPaint(Paint paint, int n, int n2) {
        return PaintUtils.resizeGradient(paint, n, n2);
    }

    protected abstract Shape provideShape(Graphics2D var1, T var2, int var3, int var4);

    public void setAreaEffects(AreaEffect ... areaEffectArray) {
        AreaEffect[] areaEffectArray2 = this.getAreaEffects();
        this.areaEffects = new AreaEffect[areaEffectArray == null ? 0 : areaEffectArray.length];
        if (areaEffectArray != null) {
            System.arraycopy(areaEffectArray, 0, this.areaEffects, 0, this.areaEffects.length);
        }
        this.setDirty(true);
        this.firePropertyChange("areaEffects", areaEffectArray2, this.getAreaEffects());
    }

    public AreaEffect[] getAreaEffects() {
        AreaEffect[] areaEffectArray = new AreaEffect[this.areaEffects.length];
        System.arraycopy(this.areaEffects, 0, areaEffectArray, 0, areaEffectArray.length);
        return areaEffectArray;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Style {
        BOTH,
        FILLED,
        OUTLINE,
        NONE;

    }
}

