/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.hyperlink;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.jdesktop.swingx.hyperlink.AbstractHyperlinkAction;
import org.jdesktop.swingx.hyperlink.LinkModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkModelAction<T extends LinkModel>
extends AbstractHyperlinkAction<T> {
    private ActionListener delegate;
    public static final String VISIT_ACTION = "visit";
    private PropertyChangeListener linkListener;

    public LinkModelAction() {
        this((LinkModel)null);
    }

    public LinkModelAction(ActionListener actionListener) {
        this(null, actionListener);
    }

    public LinkModelAction(T t) {
        this(t, null);
    }

    public LinkModelAction(T t, ActionListener actionListener) {
        super(t);
        this.setVisitingDelegate(actionListener);
    }

    public void setVisitingDelegate(ActionListener actionListener) {
        this.delegate = actionListener;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.delegate != null && this.getTarget() != null) {
            this.delegate.actionPerformed(new ActionEvent(this.getTarget(), 1001, VISIT_ACTION));
        }
    }

    @Override
    protected void installTarget() {
        if (this.getTarget() != null) {
            ((LinkModel)this.getTarget()).addPropertyChangeListener(this.getTargetListener());
        }
        this.updateFromTarget();
    }

    @Override
    protected void uninstallTarget() {
        if (this.getTarget() == null) {
            return;
        }
        ((LinkModel)this.getTarget()).removePropertyChangeListener(this.getTargetListener());
    }

    protected void updateFromTarget() {
        if (this.getTarget() != null) {
            this.putValue("Name", ((LinkModel)this.getTarget()).getText());
            this.putValue("ShortDescription", ((LinkModel)this.getTarget()).getURL().toString());
            this.putValue("visited", new Boolean(((LinkModel)this.getTarget()).getVisited()));
        } else {
            Object[] objectArray = this.getKeys();
            if (objectArray == null) {
                return;
            }
            for (int i = 0; i < objectArray.length; ++i) {
                this.putValue(objectArray[i].toString(), null);
            }
        }
    }

    private PropertyChangeListener getTargetListener() {
        if (this.linkListener == null) {
            this.linkListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    LinkModelAction.this.updateFromTarget();
                }
            };
        }
        return this.linkListener;
    }
}

