/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.graphics;

import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.WritableRaster;
import org.jdesktop.swingx.graphics.ColorUtilities;

public final class BlendComposite
implements Composite {
    public static final BlendComposite Average = new BlendComposite(BlendingMode.AVERAGE);
    public static final BlendComposite Multiply = new BlendComposite(BlendingMode.MULTIPLY);
    public static final BlendComposite Screen = new BlendComposite(BlendingMode.SCREEN);
    public static final BlendComposite Darken = new BlendComposite(BlendingMode.DARKEN);
    public static final BlendComposite Lighten = new BlendComposite(BlendingMode.LIGHTEN);
    public static final BlendComposite Overlay = new BlendComposite(BlendingMode.OVERLAY);
    public static final BlendComposite HardLight = new BlendComposite(BlendingMode.HARD_LIGHT);
    public static final BlendComposite SoftLight = new BlendComposite(BlendingMode.SOFT_LIGHT);
    public static final BlendComposite Difference = new BlendComposite(BlendingMode.DIFFERENCE);
    public static final BlendComposite Negation = new BlendComposite(BlendingMode.NEGATION);
    public static final BlendComposite Exclusion = new BlendComposite(BlendingMode.EXCLUSION);
    public static final BlendComposite ColorDodge = new BlendComposite(BlendingMode.COLOR_DODGE);
    public static final BlendComposite InverseColorDodge = new BlendComposite(BlendingMode.INVERSE_COLOR_DODGE);
    public static final BlendComposite SoftDodge = new BlendComposite(BlendingMode.SOFT_DODGE);
    public static final BlendComposite ColorBurn = new BlendComposite(BlendingMode.COLOR_BURN);
    public static final BlendComposite InverseColorBurn = new BlendComposite(BlendingMode.INVERSE_COLOR_BURN);
    public static final BlendComposite SoftBurn = new BlendComposite(BlendingMode.SOFT_BURN);
    public static final BlendComposite Reflect = new BlendComposite(BlendingMode.REFLECT);
    public static final BlendComposite Glow = new BlendComposite(BlendingMode.GLOW);
    public static final BlendComposite Freeze = new BlendComposite(BlendingMode.FREEZE);
    public static final BlendComposite Heat = new BlendComposite(BlendingMode.HEAT);
    public static final BlendComposite Add = new BlendComposite(BlendingMode.ADD);
    public static final BlendComposite Subtract = new BlendComposite(BlendingMode.SUBTRACT);
    public static final BlendComposite Stamp = new BlendComposite(BlendingMode.STAMP);
    public static final BlendComposite Red = new BlendComposite(BlendingMode.RED);
    public static final BlendComposite Green = new BlendComposite(BlendingMode.GREEN);
    public static final BlendComposite Blue = new BlendComposite(BlendingMode.BLUE);
    public static final BlendComposite Hue = new BlendComposite(BlendingMode.HUE);
    public static final BlendComposite Saturation = new BlendComposite(BlendingMode.SATURATION);
    public static final BlendComposite Color = new BlendComposite(BlendingMode.COLOR);
    public static final BlendComposite Luminosity = new BlendComposite(BlendingMode.LUMINOSITY);
    private final float alpha;
    private final BlendingMode mode;

    private BlendComposite(BlendingMode blendingMode) {
        this(blendingMode, 1.0f);
    }

    private BlendComposite(BlendingMode blendingMode, float f) {
        this.mode = blendingMode;
        if (f < 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("alpha must be comprised between 0.0f and 1.0f");
        }
        this.alpha = f;
    }

    public static BlendComposite getInstance(BlendingMode blendingMode) {
        return new BlendComposite(blendingMode);
    }

    public static BlendComposite getInstance(BlendingMode blendingMode, float f) {
        return new BlendComposite(blendingMode, f);
    }

    public BlendComposite derive(BlendingMode blendingMode) {
        return this.mode == blendingMode ? this : new BlendComposite(blendingMode, this.getAlpha());
    }

    public BlendComposite derive(float f) {
        return this.alpha == f ? this : new BlendComposite(this.getMode(), f);
    }

    public float getAlpha() {
        return this.alpha;
    }

    public BlendingMode getMode() {
        return this.mode;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.alpha) * 31 + this.mode.ordinal();
    }

    public boolean equals(Object object) {
        if (!(object instanceof BlendComposite)) {
            return false;
        }
        BlendComposite blendComposite = (BlendComposite)object;
        return this.mode == blendComposite.mode && this.alpha == blendComposite.alpha;
    }

    private static boolean isRgbColorModel(ColorModel colorModel) {
        if (colorModel instanceof DirectColorModel && colorModel.getTransferType() == 3) {
            DirectColorModel directColorModel = (DirectColorModel)colorModel;
            return directColorModel.getRedMask() == 0xFF0000 && directColorModel.getGreenMask() == 65280 && directColorModel.getBlueMask() == 255 && (directColorModel.getNumComponents() == 3 || directColorModel.getAlphaMask() == -16777216);
        }
        return false;
    }

    private static boolean isBgrColorModel(ColorModel colorModel) {
        if (colorModel instanceof DirectColorModel && colorModel.getTransferType() == 3) {
            DirectColorModel directColorModel = (DirectColorModel)colorModel;
            return directColorModel.getRedMask() == 255 && directColorModel.getGreenMask() == 65280 && directColorModel.getBlueMask() == 0xFF0000 && (directColorModel.getNumComponents() == 3 || directColorModel.getAlphaMask() == -16777216);
        }
        return false;
    }

    public CompositeContext createContext(ColorModel colorModel, ColorModel colorModel2, RenderingHints renderingHints) {
        if (BlendComposite.isRgbColorModel(colorModel) && BlendComposite.isRgbColorModel(colorModel2)) {
            return new BlendingRgbContext(this);
        }
        if (BlendComposite.isBgrColorModel(colorModel) && BlendComposite.isBgrColorModel(colorModel2)) {
            return new BlendingBgrContext(this);
        }
        throw new RasterFormatException("Incompatible color models");
    }

    private static abstract class Blender {
        private Blender() {
        }

        public abstract void blend(int[] var1, int[] var2, int[] var3);

        public static Blender getBlenderFor(BlendComposite blendComposite) {
            switch (blendComposite.getMode()) {
                case ADD: {
                    return new Blender(){

                        public void blend(int[] nArray, int[] nArray2, int[] nArray3) {
                            nArray3[0] = Math.min(255, nArray[0] + nArray2[0]);
                            nArray3[1] = Math.min(255, nArray[1] + nArray2[1]);
                            nArray3[2] = Math.min(255, nArray[2] + nArray2[2]);
                            nArray3[3] = Math.min(255, nArray[3] + nArray2[3]);
                        }
                    };
                }
                case AVERAGE: {
                    return new Blender(){

                        public void blend(int[] nArray, int[] nArray2, int[] nArray3) {
                            nArray3[0] = nArray[0] + nArray2[0] >> 1;
                            nArray3[1] = nArray[1] + nArray2[1] >> 1;
                            nArray3[2] = nArray[2] + nArray2[2] >> 1;
                            nArray3[3] = Math.min(255, nArray[3] + nArray2[3] - nArray[3] * nArray2[3] / 255);
                        }
                    };
                }
                case BLUE: {
                    return new Blender(){

                        public void blend(int[] nArray, int[] nArray2, int[] nArray3) {
                            nArray3[0] = nArray2[0];
                            nArray3[1] = nArray[1];
                            nArray3[2] = nArray2[2];
                            nArray3[3] = Math.min(255, nArray[3] + nArray2[3] - nArray[3] * nArray2[3] / 255);
                        }
                    };
                }
                case COLOR: {
                    return new Blender(){

                        public void blend(int[] nArray, int[] nArray2, int[] nArray3) {
                            float[] fArray = new float[3];
                            ColorUtilities.RGBtoHSL(nArray[0], nArray[1], nArray[2], fArray);
                            float[] fArray2 = new float[3];
                            ColorUtilities.RGBtoHSL(nArray2[0], nArray2[1], nArray2[2], fArray2);
                            ColorUtilities.HSLtoRGB(fArray[0], fArray[1], fArray2[2], nArray3);
                            nArray3[3] = Math.min(255, nArray[3] + nArray2[3] - nArray[3] * nArray2[3] / 255);
                        }
                    };
                }
                case COLOR_BURN: {
                    return new Blender(){

                        public void blend(int[] nArray, int[] nArray2, int[] nArray3) {
                            nArray3[0] = nArray[0] == 0 ? 0 : Math.max(0, 255 - (255 - nArray2[0] << 8) / nArray[0]);
                            nArray3[1] = nArray[1] == 0 ? 0 : Math.max(0, 255 - (255 - nArray2[1] << 8) / nArray[1]);
                            nArray3[2] = nArray[2] == 0 ? 0 : Math.max(0, 255 - (255 - nArray2[2] << 8) / nArray[2]);
                            nArray3[3] = Math.min(255, nArray[3] + nArray2[3] - nArray[3] * nArray2[3] / 255);
                        }
                    };
                }
                case COLOR_DODGE: {
                    return new Blender(){

                        public void blend(int[] nArray, int[] nArray2, int[] nArray3) {
                            nArray3[0] = nArray[0] == 255 ? 255 : Math.min((nArray2[0] << 8) / (255 - nArray[0]), 255);
                            nArray3[1] = nArray[1] == 255 ? 255 : Math.min((nArray2[1] << 8) / (255 - nArray[1]), 255);
                            nArray3[2] = nArray[2] == 255 ? 255 : Math.min((nArray2[2] << 8) / (255 - nArray[2]), 255);
                            nArray3[3] = Math.min(255, nArray[3] + nArray2[3] - nArray[3] * nArray2[3] / 255);
                        }
                    };
                }
                case DARKEN: {
                    return new Blender(){

                        public void blend(int[] nArray, int[] nArray2, int[] nArray3) {
                            nArray3[0] = Math.min(nArray[0], nArray2[0]);
                            nArray3[1] = Math.min(nArray[1], nArray2[1]);
                            nArray3[2] = Math.min(nArray[2], nArray2[2]);
                            nArray3[3] = Math.min(255, nArray[3] + nArray2[3] - nArray[3] * nArray2[3] / 255);
                        }
                    };
                }
                case DIFFERENCE: {
                    return new Blender(){

                        public void blend(int[] nArray, int[] nArray2, int[] nArray3) {
                            nArray3[0] = Math.abs(nArray2[0] - nArray[0]);
                            nArray3[1] = Math.abs(nArray2[1] - nArray[1]);
                            nArray3[2] = Math.abs(nArray2[2] - nArray[2]);
                            nArray3[3] = Math.min(255, nArray[3] + nArray2[3] - nArray[3] * nArray2[3] / 255);
                        }
                    };
                }
                case EXCLUSION: {
                    return new Blender(){

                        public void blend(int[] nArray, int[] nArray2, int[] nArray3) {
                            nArray3[0] = nArray2[0] + nArray[0] - (nArray2[0] * nArray[0] >> 7);
                            nArray3[1] = nArray2[1] + nArray[1] - (nArray2[1] * nArray[1] >> 7);
                            nArray3[2] = nArray2[2] + nArray[2] - (nArray2[2] * nArray[2] >> 7);
                            nArray3[3] = Math.min(255, nArray[3] + nArray2[3] - nArray[3] * nArray2[3] / 255);
                        }
                    };
                }
                case FREEZE: {
                    return new Blender(){

                        public void blend(int[] nArray, int[] nArray2, int[] nArray3) {
                            nArray3[0] = nArray[0] == 0 ? 0 : Math.max(0, 255 - (255 - nArray2[0]) * (255 - nArray2[0]) / nArray[0]);
                            nArray3[1] = nArray[1] == 0 ? 0 : Math.max(0, 255 - (255 - nArray2[1]) * (255 - nArray2[1]) / nArray[1]);
                            nArray3[2] = nArray[2] == 0 ? 0 : Math.max(0, 255 - (255 - nArray2[2]) * (255 - nArray2[2]) / nArray[2]);
                            nArray3[3] = Math.min(255, nArray[3] + nArray2[3] - nArray[3] * nArray2[3] / 255);
                        }
                    };
                }
                case GLOW: {
                    return new Blender(){

                        public void blend(int[] nArray, int[] nArray2, int[] nArray3) {
                            nArray3[0] = nArray2[0] == 255 ? 255 : Math.min(255, nArray[0] * nArray[0] / (255 - nArray2[0]));
                            nArray3[1] = nArray2[1] == 255 ? 255 : Math.min(255, nArray[1] * nArray[1] / (255 - nArray2[1]));
                            nArray3[2] = nArray2[2] == 255 ? 255 : Math.min(255, nArray[2] * nArray[2] / (255 - nArray2[2]));
                            nArray3[3] = Math.min(255, nArray[3] + nArray2[3] - nArray[3] * nArray2[3] / 255);
                        }
                    };
                }
                case GREEN: {
                    return new Blender(){

                        public void blend(int[] nArray, int[] nArray2, int[] nArray3) {
                            nArray3[0] = nArray2[0];
                            nArray3[1] = nArray2[1];
                            nArray3[2] = nArray[2];
                            nArray3[3] = Math.min(255, nArray[3] + nArray2[3] - nArray[3] * nArray2[3] / 255);
                        }
                    };
                }
                case HARD_LIGHT: {
                    return new Blender(){

                        public void blend(int[] nArray, int[] nArray2, int[] nArray3) {
                            nArray3[0] = nArray[0] < 128 ? nArray2[0] * nArray[0] >> 7 : 255 - ((255 - nArray[0]) * (255 - nArray2[0]) >> 7);
                            nArray3[1] = nArray[1] < 128 ? nArray2[1] * nArray[1] >> 7 : 255 - ((255 - nArray[1]) * (255 - nArray2[1]) >> 7);
                            nArray3[2] = nArray[2] < 128 ? nArray2[2] * nArray[2] >> 7 : 255 - ((255 - nArray[2]) * (255 - nArray2[2]) >> 7);
                            nArray3[3] = Math.min(255, nArray[3] + nArray2[3] - nArray[3] * nArray2[3] / 255);
                        }
                    };
                }
                case HEAT: {
                    return new Blender(){

                        public void blend(int[] nArray, int[] nArray2, int[] nArray3) {
                            nArray3[0] = nArray2[0] == 0 ? 0 : Math.max(0, 255 - (255 - nArray[0]) * (255 - nArray[0]) / nArray2[0]);
                            nArray3[1] = nArray2[1] == 0 ? 0 : Math.max(0, 255 - (255 - nArray[1]) * (255 - nArray[1]) / nArray2[1]);
                            nArray3[2] = nArray2[2] == 0 ? 0 : Math.max(0, 255 - (255 - nArray[2]) * (255 - nArray[2]) / nArray2[2]);
                            nArray3[3] = Math.min(255, nArray[3] + nArray2[3] - nArray[3] * nArray2[3] / 255);
                        }
                    };
                }
                case HUE: {
                    return new Blender(){

                        public void blend(int[] nArray, int[] nArray2, int[] nArray3) {
                            float[] fArray = new float[3];
                            ColorUtilities.RGBtoHSL(nArray[0], nArray[1], nArray[2], fArray);
                            float[] fArray2 = new float[3];
                            ColorUtilities.RGBtoHSL(nArray2[0], nArray2[1], nArray2[2], fArray2);
                            ColorUtilities.HSLtoRGB(fArray[0], fArray2[1], fArray2[2], nArray3);
                            nArray3[3] = Math.min(255, nArray[3] + nArray2[3] - nArray[3] * nArray2[3] / 255);
                        }
                    };
                }
                case INVERSE_COLOR_BURN: {
                    return new Blender(){

                        public void blend(int[] nArray, int[] nArray2, int[] nArray3) {
                            nArray3[0] = nArray2[0] == 0 ? 0 : Math.max(0, 255 - (255 - nArray[0] << 8) / nArray2[0]);
                            nArray3[1] = nArray2[1] == 0 ? 0 : Math.max(0, 255 - (255 - nArray[1] << 8) / nArray2[1]);
                            nArray3[2] = nArray2[2] == 0 ? 0 : Math.max(0, 255 - (255 - nArray[2] << 8) / nArray2[2]);
                            nArray3[3] = Math.min(255, nArray[3] + nArray2[3] - nArray[3] * nArray2[3] / 255);
                        }
                    };
                }
                case INVERSE_COLOR_DODGE: {
                    return new Blender(){

                        public void blend(int[] nArray, int[] nArray2, int[] nArray3) {
                            nArray3[0] = nArray2[0] == 255 ? 255 : Math.min((nArray[0] << 8) / (255 - nArray2[0]), 255);
                            nArray3[1] = nArray2[1] == 255 ? 255 : Math.min((nArray[1] << 8) / (255 - nArray2[1]), 255);
                            nArray3[2] = nArray2[2] == 255 ? 255 : Math.min((nArray[2] << 8) / (255 - nArray2[2]), 255);
                            nArray3[3] = Math.min(255, nArray[3] + nArray2[3] - nArray[3] * nArray2[3] / 255);
                        }
                    };
                }
                case LIGHTEN: {
                    return new Blender(){

                        public void blend(int[] nArray, int[] nArray2, int[] nArray3) {
                            nArray3[0] = Math.max(nArray[0], nArray2[0]);
                            nArray3[1] = Math.max(nArray[1], nArray2[1]);
                            nArray3[2] = Math.max(nArray[2], nArray2[2]);
                            nArray3[3] = Math.min(255, nArray[3] + nArray2[3] - nArray[3] * nArray2[3] / 255);
                        }
                    };
                }
                case LUMINOSITY: {
                    return new Blender(){

                        public void blend(int[] nArray, int[] nArray2, int[] nArray3) {
                            float[] fArray = new float[3];
                            ColorUtilities.RGBtoHSL(nArray[0], nArray[1], nArray[2], fArray);
                            float[] fArray2 = new float[3];
                            ColorUtilities.RGBtoHSL(nArray2[0], nArray2[1], nArray2[2], fArray2);
                            ColorUtilities.HSLtoRGB(fArray2[0], fArray2[1], fArray[2], nArray3);
                            nArray3[3] = Math.min(255, nArray[3] + nArray2[3] - nArray[3] * nArray2[3] / 255);
                        }
                    };
                }
                case MULTIPLY: {
                    return new Blender(){

                        public void blend(int[] nArray, int[] nArray2, int[] nArray3) {
                            nArray3[0] = nArray[0] * nArray2[0] >> 8;
                            nArray3[1] = nArray[1] * nArray2[1] >> 8;
                            nArray3[2] = nArray[2] * nArray2[2] >> 8;
                            nArray3[3] = Math.min(255, nArray[3] + nArray2[3] - nArray[3] * nArray2[3] / 255);
                        }
                    };
                }
                case NEGATION: {
                    return new Blender(){

                        public void blend(int[] nArray, int[] nArray2, int[] nArray3) {
                            nArray3[0] = 255 - Math.abs(255 - nArray2[0] - nArray[0]);
                            nArray3[1] = 255 - Math.abs(255 - nArray2[1] - nArray[1]);
                            nArray3[2] = 255 - Math.abs(255 - nArray2[2] - nArray[2]);
                            nArray3[3] = Math.min(255, nArray[3] + nArray2[3] - nArray[3] * nArray2[3] / 255);
                        }
                    };
                }
                case OVERLAY: {
                    return new Blender(){

                        public void blend(int[] nArray, int[] nArray2, int[] nArray3) {
                            nArray3[0] = nArray2[0] < 128 ? nArray2[0] * nArray[0] >> 7 : 255 - ((255 - nArray2[0]) * (255 - nArray[0]) >> 7);
                            nArray3[1] = nArray2[1] < 128 ? nArray2[1] * nArray[1] >> 7 : 255 - ((255 - nArray2[1]) * (255 - nArray[1]) >> 7);
                            nArray3[2] = nArray2[2] < 128 ? nArray2[2] * nArray[2] >> 7 : 255 - ((255 - nArray2[2]) * (255 - nArray[2]) >> 7);
                            nArray3[3] = Math.min(255, nArray[3] + nArray2[3] - nArray[3] * nArray2[3] / 255);
                        }
                    };
                }
                case RED: {
                    return new Blender(){

                        public void blend(int[] nArray, int[] nArray2, int[] nArray3) {
                            nArray3[0] = nArray[0];
                            nArray3[1] = nArray2[1];
                            nArray3[2] = nArray2[2];
                            nArray3[3] = Math.min(255, nArray[3] + nArray2[3] - nArray[3] * nArray2[3] / 255);
                        }
                    };
                }
                case REFLECT: {
                    return new Blender(){

                        public void blend(int[] nArray, int[] nArray2, int[] nArray3) {
                            nArray3[0] = nArray[0] == 255 ? 255 : Math.min(255, nArray2[0] * nArray2[0] / (255 - nArray[0]));
                            nArray3[1] = nArray[1] == 255 ? 255 : Math.min(255, nArray2[1] * nArray2[1] / (255 - nArray[1]));
                            nArray3[2] = nArray[2] == 255 ? 255 : Math.min(255, nArray2[2] * nArray2[2] / (255 - nArray[2]));
                            nArray3[3] = Math.min(255, nArray[3] + nArray2[3] - nArray[3] * nArray2[3] / 255);
                        }
                    };
                }
                case SATURATION: {
                    return new Blender(){

                        public void blend(int[] nArray, int[] nArray2, int[] nArray3) {
                            float[] fArray = new float[3];
                            ColorUtilities.RGBtoHSL(nArray[0], nArray[1], nArray[2], fArray);
                            float[] fArray2 = new float[3];
                            ColorUtilities.RGBtoHSL(nArray2[0], nArray2[1], nArray2[2], fArray2);
                            ColorUtilities.HSLtoRGB(fArray2[0], fArray[1], fArray2[2], nArray3);
                            nArray3[3] = Math.min(255, nArray[3] + nArray2[3] - nArray[3] * nArray2[3] / 255);
                        }
                    };
                }
                case SCREEN: {
                    return new Blender(){

                        public void blend(int[] nArray, int[] nArray2, int[] nArray3) {
                            nArray3[0] = 255 - ((255 - nArray[0]) * (255 - nArray2[0]) >> 8);
                            nArray3[1] = 255 - ((255 - nArray[1]) * (255 - nArray2[1]) >> 8);
                            nArray3[2] = 255 - ((255 - nArray[2]) * (255 - nArray2[2]) >> 8);
                            nArray3[3] = Math.min(255, nArray[3] + nArray2[3] - nArray[3] * nArray2[3] / 255);
                        }
                    };
                }
                case SOFT_BURN: {
                    return new Blender(){

                        public void blend(int[] nArray, int[] nArray2, int[] nArray3) {
                            int n = nArray2[0] + nArray[0] < 256 ? (nArray2[0] == 255 ? 255 : Math.min(255, (nArray[0] << 7) / (255 - nArray2[0]))) : (nArray3[0] = Math.max(0, 255 - (255 - nArray2[0] << 7) / nArray[0]));
                            int n2 = nArray2[1] + nArray[1] < 256 ? (nArray2[1] == 255 ? 255 : Math.min(255, (nArray[1] << 7) / (255 - nArray2[1]))) : (nArray3[1] = Math.max(0, 255 - (255 - nArray2[1] << 7) / nArray[1]));
                            nArray3[2] = nArray2[2] + nArray[2] < 256 ? (nArray2[2] == 255 ? 255 : Math.min(255, (nArray[2] << 7) / (255 - nArray2[2]))) : Math.max(0, 255 - (255 - nArray2[2] << 7) / nArray[2]);
                            nArray3[3] = Math.min(255, nArray[3] + nArray2[3] - nArray[3] * nArray2[3] / 255);
                        }
                    };
                }
                case SOFT_DODGE: {
                    return new Blender(){

                        public void blend(int[] nArray, int[] nArray2, int[] nArray3) {
                            int n = nArray2[0] + nArray[0] < 256 ? (nArray[0] == 255 ? 255 : Math.min(255, (nArray2[0] << 7) / (255 - nArray[0]))) : (nArray3[0] = Math.max(0, 255 - (255 - nArray[0] << 7) / nArray2[0]));
                            int n2 = nArray2[1] + nArray[1] < 256 ? (nArray[1] == 255 ? 255 : Math.min(255, (nArray2[1] << 7) / (255 - nArray[1]))) : (nArray3[1] = Math.max(0, 255 - (255 - nArray[1] << 7) / nArray2[1]));
                            nArray3[2] = nArray2[2] + nArray[2] < 256 ? (nArray[2] == 255 ? 255 : Math.min(255, (nArray2[2] << 7) / (255 - nArray[2]))) : Math.max(0, 255 - (255 - nArray[2] << 7) / nArray2[2]);
                            nArray3[3] = Math.min(255, nArray[3] + nArray2[3] - nArray[3] * nArray2[3] / 255);
                        }
                    };
                }
                case SOFT_LIGHT: {
                    return new Blender(){

                        public void blend(int[] nArray, int[] nArray2, int[] nArray3) {
                            int n = nArray[0] * nArray2[0] / 255;
                            int n2 = nArray[1] * nArray2[1] / 255;
                            int n3 = nArray[2] * nArray2[2] / 255;
                            nArray3[0] = n + nArray[0] * (255 - (255 - nArray[0]) * (255 - nArray2[0]) / 255 - n) / 255;
                            nArray3[1] = n2 + nArray[1] * (255 - (255 - nArray[1]) * (255 - nArray2[1]) / 255 - n2) / 255;
                            nArray3[2] = n3 + nArray[2] * (255 - (255 - nArray[2]) * (255 - nArray2[2]) / 255 - n3) / 255;
                            nArray3[3] = Math.min(255, nArray[3] + nArray2[3] - nArray[3] * nArray2[3] / 255);
                        }
                    };
                }
                case STAMP: {
                    return new Blender(){

                        public void blend(int[] nArray, int[] nArray2, int[] nArray3) {
                            nArray3[0] = Math.max(0, Math.min(255, nArray2[0] + 2 * nArray[0] - 256));
                            nArray3[1] = Math.max(0, Math.min(255, nArray2[1] + 2 * nArray[1] - 256));
                            nArray3[2] = Math.max(0, Math.min(255, nArray2[2] + 2 * nArray[2] - 256));
                            nArray3[3] = Math.min(255, nArray[3] + nArray2[3] - nArray[3] * nArray2[3] / 255);
                        }
                    };
                }
                case SUBTRACT: {
                    return new Blender(){

                        public void blend(int[] nArray, int[] nArray2, int[] nArray3) {
                            nArray3[0] = Math.max(0, nArray[0] + nArray2[0] - 256);
                            nArray3[1] = Math.max(0, nArray[1] + nArray2[1] - 256);
                            nArray3[2] = Math.max(0, nArray[2] + nArray2[2] - 256);
                            nArray3[3] = Math.min(255, nArray[3] + nArray2[3] - nArray[3] * nArray2[3] / 255);
                        }
                    };
                }
            }
            throw new IllegalArgumentException("Blender not implemented for " + blendComposite.getMode().name());
        }
    }

    private static class BlendingBgrContext
    extends BlendingContext {
        private BlendingBgrContext(BlendComposite blendComposite) {
            super(blendComposite);
        }

        public void compose(Raster raster, Raster raster2, WritableRaster writableRaster) {
            int n = Math.min(raster.getWidth(), raster2.getWidth());
            int n2 = Math.min(raster.getHeight(), raster2.getHeight());
            float f = this.composite.getAlpha();
            int[] nArray = new int[4];
            int[] nArray2 = new int[4];
            int[] nArray3 = new int[4];
            int[] nArray4 = new int[n];
            int[] nArray5 = new int[n];
            for (int i = 0; i < n2; ++i) {
                raster.getDataElements(0, i, n, 1, nArray4);
                raster2.getDataElements(0, i, n, 1, nArray5);
                for (int j = 0; j < n; ++j) {
                    int n3 = nArray4[j];
                    nArray2[0] = n3 & 0xFF;
                    nArray2[1] = n3 >> 8 & 0xFF;
                    nArray2[2] = n3 >> 16 & 0xFF;
                    nArray2[3] = n3 >> 24 & 0xFF;
                    n3 = nArray5[j];
                    nArray3[0] = n3 & 0xFF;
                    nArray3[1] = n3 >> 8 & 0xFF;
                    nArray3[2] = n3 >> 16 & 0xFF;
                    nArray3[3] = n3 >> 24 & 0xFF;
                    this.blender.blend(nArray2, nArray3, nArray);
                    nArray5[j] = ((int)((float)nArray3[3] + (float)(nArray[3] - nArray3[3]) * f) & 0xFF) << 24 | (int)((float)nArray3[0] + (float)(nArray[0] - nArray3[0]) * f) & 0xFF | ((int)((float)nArray3[1] + (float)(nArray[1] - nArray3[1]) * f) & 0xFF) << 8 | ((int)((float)nArray3[2] + (float)(nArray[2] - nArray3[2]) * f) & 0xFF) << 16;
                }
                writableRaster.setDataElements(0, i, n, 1, nArray5);
            }
        }
    }

    private static class BlendingRgbContext
    extends BlendingContext {
        private BlendingRgbContext(BlendComposite blendComposite) {
            super(blendComposite);
        }

        public void compose(Raster raster, Raster raster2, WritableRaster writableRaster) {
            int n = Math.min(raster.getWidth(), raster2.getWidth());
            int n2 = Math.min(raster.getHeight(), raster2.getHeight());
            float f = this.composite.getAlpha();
            int[] nArray = new int[4];
            int[] nArray2 = new int[4];
            int[] nArray3 = new int[4];
            int[] nArray4 = new int[n];
            int[] nArray5 = new int[n];
            for (int i = 0; i < n2; ++i) {
                raster.getDataElements(0, i, n, 1, nArray4);
                raster2.getDataElements(0, i, n, 1, nArray5);
                for (int j = 0; j < n; ++j) {
                    int n3 = nArray4[j];
                    nArray2[0] = n3 >> 16 & 0xFF;
                    nArray2[1] = n3 >> 8 & 0xFF;
                    nArray2[2] = n3 & 0xFF;
                    nArray2[3] = n3 >> 24 & 0xFF;
                    n3 = nArray5[j];
                    nArray3[0] = n3 >> 16 & 0xFF;
                    nArray3[1] = n3 >> 8 & 0xFF;
                    nArray3[2] = n3 & 0xFF;
                    nArray3[3] = n3 >> 24 & 0xFF;
                    this.blender.blend(nArray2, nArray3, nArray);
                    nArray5[j] = ((int)((float)nArray3[3] + (float)(nArray[3] - nArray3[3]) * f) & 0xFF) << 24 | ((int)((float)nArray3[0] + (float)(nArray[0] - nArray3[0]) * f) & 0xFF) << 16 | ((int)((float)nArray3[1] + (float)(nArray[1] - nArray3[1]) * f) & 0xFF) << 8 | (int)((float)nArray3[2] + (float)(nArray[2] - nArray3[2]) * f) & 0xFF;
                }
                writableRaster.setDataElements(0, i, n, 1, nArray5);
            }
        }
    }

    private static abstract class BlendingContext
    implements CompositeContext {
        protected final Blender blender;
        protected final BlendComposite composite;

        private BlendingContext(BlendComposite blendComposite) {
            this.composite = blendComposite;
            this.blender = Blender.getBlenderFor(blendComposite);
        }

        public void dispose() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BlendingMode {
        AVERAGE,
        MULTIPLY,
        SCREEN,
        DARKEN,
        LIGHTEN,
        OVERLAY,
        HARD_LIGHT,
        SOFT_LIGHT,
        DIFFERENCE,
        NEGATION,
        EXCLUSION,
        COLOR_DODGE,
        INVERSE_COLOR_DODGE,
        SOFT_DODGE,
        COLOR_BURN,
        INVERSE_COLOR_BURN,
        SOFT_BURN,
        REFLECT,
        GLOW,
        FREEZE,
        HEAT,
        ADD,
        SUBTRACT,
        STAMP,
        RED,
        GREEN,
        BLUE,
        HUE,
        SATURATION,
        COLOR,
        LUMINOSITY;

    }
}

