/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.event;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventListenerMap {
    private final Map<Class<? extends EventListener>, List<? extends EventListener>> listenerList = new HashMap<Class<? extends EventListener>, List<? extends EventListener>>();

    public List<EventListener> getListeners() {
        ArrayList<EventListener> arrayList = new ArrayList<EventListener>();
        for (List<? extends EventListener> list : this.listenerList.values()) {
            arrayList.addAll(list);
        }
        return arrayList;
    }

    public <T extends EventListener> List<T> getListeners(Class<T> clazz) {
        List<? extends EventListener> list = this.listenerList.get(clazz);
        if (list == null) {
            list = new ArrayList<EventListener>();
        }
        return list;
    }

    public int getListenerCount() {
        int n = 0;
        for (List<? extends EventListener> list : this.listenerList.values()) {
            n += list.size();
        }
        return n;
    }

    public <T extends EventListener> int getListenerCount(Class<T> clazz) {
        List<? extends EventListener> list = this.listenerList.get(clazz);
        if (list != null) {
            return list.size();
        }
        return 0;
    }

    public synchronized <T extends EventListener> void add(Class<T> clazz, T t) {
        if (t == null) {
            return;
        }
        List<? extends EventListener> list = this.listenerList.get(clazz);
        if (list == null) {
            list = new ArrayList<EventListener>();
            this.listenerList.put(clazz, list);
        }
        list.add(t);
    }

    public synchronized <T extends EventListener> void remove(Class<T> clazz, T t) {
        if (t == null) {
            return;
        }
        List<? extends EventListener> list = this.listenerList.get(clazz);
        if (list != null) {
            list.remove(t);
        }
    }
}

