/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.decorator;

import java.awt.Component;
import java.util.regex.Pattern;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;

public class SearchPredicate
implements HighlightPredicate {
    public static final int ALL = -1;
    public static final String MATCH_ALL = ".*";
    private int highlightColumn;
    private int highlightRow;
    private Pattern pattern;

    public SearchPredicate(Pattern pattern) {
        this(pattern, -1, -1);
    }

    public SearchPredicate(Pattern pattern, int n) {
        this(pattern, -1, n);
    }

    public SearchPredicate(Pattern pattern, int n, int n2) {
        this.pattern = pattern;
        this.highlightColumn = n2;
        this.highlightRow = n;
    }

    public SearchPredicate(String string) {
        this(string, -1, -1);
    }

    public SearchPredicate(String string, int n) {
        this(string, -1, n);
    }

    public SearchPredicate(String string, int n, int n2) {
        this(string != null && string.length() > 0 ? Pattern.compile(string) : null, n, n2);
    }

    public int getHighlightColumn() {
        return this.highlightColumn;
    }

    public int getHighlightRow() {
        return this.highlightRow;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public boolean isHighlighted(Component component, ComponentAdapter componentAdapter) {
        if (this.isHighlightCandidate(component, componentAdapter)) {
            return this.test(component, componentAdapter);
        }
        return false;
    }

    private boolean test(Component component, ComponentAdapter componentAdapter) {
        int n = componentAdapter.viewToModel(componentAdapter.column);
        String string = componentAdapter.getString(n);
        if (string == null || string.length() == 0) {
            return false;
        }
        return this.pattern.matcher(string).find();
    }

    private boolean isHighlightCandidate(Component component, ComponentAdapter componentAdapter) {
        if (!this.isEnabled()) {
            return false;
        }
        if (this.highlightRow >= 0 && componentAdapter.row != this.highlightRow) {
            return false;
        }
        return this.highlightColumn < 0 || this.highlightColumn == componentAdapter.viewToModel(componentAdapter.column);
    }

    private boolean isEnabled() {
        Pattern pattern = this.getPattern();
        return pattern != null && !MATCH_ALL.equals(pattern.pattern());
    }
}

