/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.decorator;

import java.awt.Component;
import java.util.regex.Pattern;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;

public class PatternPredicate
implements HighlightPredicate {
    public static final int ALL = -1;
    private int highlightColumn;
    private int testColumn;
    private Pattern pattern;

    public PatternPredicate(Pattern pattern, int n) {
        this(pattern, n, -1);
    }

    public PatternPredicate(Pattern pattern, int n, int n2) {
        this.pattern = pattern;
        this.testColumn = n;
        this.highlightColumn = n2;
    }

    public PatternPredicate(String string, int n, int n2) {
        this(Pattern.compile(string), n, n2);
    }

    public PatternPredicate(String string, int n) {
        this(Pattern.compile(string), n);
    }

    public boolean isHighlighted(Component component, ComponentAdapter componentAdapter) {
        if (this.isHighlightCandidate(component, componentAdapter)) {
            return this.test(component, componentAdapter);
        }
        return false;
    }

    private boolean test(Component component, ComponentAdapter componentAdapter) {
        if (!componentAdapter.isTestable(this.testColumn)) {
            return false;
        }
        String string = componentAdapter.getString(this.testColumn);
        if (string == null || string.length() == 0) {
            return false;
        }
        return this.pattern.matcher(string).find();
    }

    private boolean isHighlightCandidate(Component component, ComponentAdapter componentAdapter) {
        return this.pattern != null && (this.highlightColumn < 0 || this.highlightColumn == componentAdapter.viewToModel(componentAdapter.column));
    }

    public int getHighlightColumn() {
        return this.highlightColumn;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public int getTestColumn() {
        return this.testColumn;
    }
}

