/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.decorator;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.jdesktop.swingx.decorator.AbstractHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.painter.AbstractPainter;
import org.jdesktop.swingx.painter.Painter;
import org.jdesktop.swingx.renderer.PainterAware;

public class PainterHighlighter
extends AbstractHighlighter {
    private Painter painter;
    private PropertyChangeListener painterListener;
    private boolean isAdjusting;

    public PainterHighlighter() {
        this(null, null);
    }

    public PainterHighlighter(HighlightPredicate highlightPredicate) {
        this(highlightPredicate, null);
    }

    public PainterHighlighter(Painter painter) {
        this(null, painter);
    }

    public PainterHighlighter(HighlightPredicate highlightPredicate, Painter painter) {
        super(highlightPredicate);
        this.setPainter(painter);
    }

    public Painter getPainter() {
        return this.painter;
    }

    public void setPainter(Painter painter) {
        if (this.areEqual(painter, this.getPainter())) {
            return;
        }
        this.uninstallPainterListener();
        this.painter = painter;
        this.installPainterListener();
        this.fireStateChanged();
    }

    protected void installPainterListener() {
        if (this.getPainter() instanceof AbstractPainter) {
            ((AbstractPainter)this.getPainter()).addPropertyChangeListener(this.getPainterListener());
        }
    }

    protected void uninstallPainterListener() {
        if (this.getPainter() instanceof AbstractPainter) {
            ((AbstractPainter)this.getPainter()).removePropertyChangeListener(this.painterListener);
        }
    }

    protected final PropertyChangeListener getPainterListener() {
        if (this.painterListener == null) {
            this.painterListener = this.createPainterListener();
        }
        return this.painterListener;
    }

    protected PropertyChangeListener createPainterListener() {
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (PainterHighlighter.this.isAdjusting) {
                    return;
                }
                PainterHighlighter.this.fireStateChanged();
            }
        };
        return propertyChangeListener;
    }

    public Component highlight(Component component, ComponentAdapter componentAdapter) {
        this.isAdjusting = true;
        Component component2 = super.highlight(component, componentAdapter);
        this.isAdjusting = false;
        return component2;
    }

    protected Component doHighlight(Component component, ComponentAdapter componentAdapter) {
        ((PainterAware)((Object)component)).setPainter(this.painter);
        return component;
    }

    protected boolean canHighlight(Component component, ComponentAdapter componentAdapter) {
        return this.getPainter() != null && component instanceof PainterAware;
    }
}

