/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.decorator;

import java.awt.Color;
import javax.swing.UIManager;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.CompoundHighlighter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.UIDependent;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;
import org.jdesktop.swingx.plaf.UIColorHighlighterAddon;

public final class HighlighterFactory {
    public static final Color BEIGE = new Color(245, 245, 220);
    public static final Color LINE_PRINTER = new Color(204, 204, 255);
    public static final Color CLASSIC_LINE_PRINTER = new Color(204, 255, 204);
    public static final Color FLORAL_WHITE = new Color(255, 250, 240);
    public static final Color QUICKSILVER = new Color(240, 240, 224);
    public static final Color GENERIC_GRAY = new Color(229, 229, 229);
    public static final Color LEDGER = new Color(245, 255, 245);
    public static final Color NOTEPAD = new Color(255, 255, 204);

    public static Highlighter createSimpleStriping() {
        UIColorHighlighter uIColorHighlighter = new UIColorHighlighter(HighlightPredicate.ODD);
        return uIColorHighlighter;
    }

    public static Highlighter createSimpleStriping(int n) {
        return new UIColorHighlighter(new HighlightPredicate.RowGroupHighlightPredicate(n));
    }

    public static Highlighter createSimpleStriping(Color color) {
        ColorHighlighter colorHighlighter = new ColorHighlighter(HighlightPredicate.ODD, color, null);
        return colorHighlighter;
    }

    public static Highlighter createSimpleStriping(Color color, int n) {
        HighlightPredicate.RowGroupHighlightPredicate rowGroupHighlightPredicate = new HighlightPredicate.RowGroupHighlightPredicate(n);
        ColorHighlighter colorHighlighter = new ColorHighlighter(rowGroupHighlightPredicate, color, null);
        return colorHighlighter;
    }

    public static Highlighter createAlternateStriping() {
        ColorHighlighter colorHighlighter = new ColorHighlighter(HighlightPredicate.EVEN, Color.WHITE, null);
        UIColorHighlighter uIColorHighlighter = new UIColorHighlighter(HighlightPredicate.ODD);
        return new CompoundHighlighter(colorHighlighter, uIColorHighlighter);
    }

    public static Highlighter createAlternateStriping(int n) {
        HighlightPredicate.RowGroupHighlightPredicate rowGroupHighlightPredicate = new HighlightPredicate.RowGroupHighlightPredicate(n);
        ColorHighlighter colorHighlighter = new ColorHighlighter(new HighlightPredicate.NotHighlightPredicate(rowGroupHighlightPredicate), Color.WHITE, null);
        UIColorHighlighter uIColorHighlighter = new UIColorHighlighter(rowGroupHighlightPredicate);
        return new CompoundHighlighter(colorHighlighter, uIColorHighlighter);
    }

    public static Highlighter createAlternateStriping(Color color, Color color2) {
        ColorHighlighter colorHighlighter = new ColorHighlighter(HighlightPredicate.EVEN, color, null);
        ColorHighlighter colorHighlighter2 = new ColorHighlighter(HighlightPredicate.ODD, color2, null);
        return new CompoundHighlighter(colorHighlighter, colorHighlighter2);
    }

    public static Highlighter createAlternateStriping(Color color, Color color2, int n) {
        HighlightPredicate.RowGroupHighlightPredicate rowGroupHighlightPredicate = new HighlightPredicate.RowGroupHighlightPredicate(n);
        ColorHighlighter colorHighlighter = new ColorHighlighter(new HighlightPredicate.NotHighlightPredicate(rowGroupHighlightPredicate), color, null);
        ColorHighlighter colorHighlighter2 = new ColorHighlighter(rowGroupHighlightPredicate, color2, null);
        return new CompoundHighlighter(colorHighlighter, colorHighlighter2);
    }

    public static class UIColorHighlighter
    extends ColorHighlighter
    implements UIDependent {
        public UIColorHighlighter() {
            this(null);
        }

        public UIColorHighlighter(HighlightPredicate highlightPredicate) {
            super(highlightPredicate, null, null);
            this.updateUI();
        }

        public void updateUI() {
            this.setBackground(this.getUIColor());
        }

        private Color getUIColor() {
            Color color = null;
            if (color == null) {
                color = UIManager.getColor("UIColorHighlighter.stripingBackground");
            }
            if (color == null) {
                color = GENERIC_GRAY;
            }
            return color;
        }

        static {
            LookAndFeelAddons.contribute(new UIColorHighlighterAddon());
        }
    }
}

