/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.decorator;

import javax.swing.JComponent;
import org.jdesktop.swingx.renderer.StringValues;

public abstract class ComponentAdapter {
    public static final Object DEFAULT_COLUMN_IDENTIFIER = "Column0";
    public int row = 0;
    public int column = 0;
    protected final JComponent target;

    public ComponentAdapter(JComponent jComponent) {
        this.target = jComponent;
    }

    public JComponent getComponent() {
        return this.target;
    }

    public String getColumnName(int n) {
        Object object = this.getColumnIdentifierAt(n);
        return object != null ? object.toString() : null;
    }

    public Object getColumnIdentifierAt(int n) {
        if (n < 0 || n >= this.getColumnCount()) {
            throw new ArrayIndexOutOfBoundsException("invalid column index: " + n);
        }
        return DEFAULT_COLUMN_IDENTIFIER;
    }

    public int getColumnIndex(Object object) {
        if (object.equals(this.getColumnIdentifierAt(0))) {
            return 0;
        }
        return -1;
    }

    public int getColumnCount() {
        return 1;
    }

    public int getRowCount() {
        return 0;
    }

    public abstract Object getValueAt(int var1, int var2);

    public abstract boolean isCellEditable(int var1, int var2);

    public boolean isTestable(int n) {
        return this.modelToView(n) >= 0;
    }

    public String getString() {
        return StringValues.TO_STRING.getString(this.getValue());
    }

    public String getString(int n) {
        return this.getFilteredStringAt(this.row, n);
    }

    public String getFilteredStringAt(int n, int n2) {
        return StringValues.TO_STRING.getString(this.getFilteredValueAt(n, n2));
    }

    public String getStringAt(int n, int n2) {
        return StringValues.TO_STRING.getString(this.getValueAt(n, n2));
    }

    public Object getValue() {
        return this.getValueAt(this.row, this.column);
    }

    public Object getValue(int n) {
        return this.getFilteredValueAt(this.row, n);
    }

    public abstract Object getFilteredValueAt(int var1, int var2);

    public abstract boolean hasFocus();

    public abstract boolean isSelected();

    public abstract boolean isEditable();

    public boolean isExpanded() {
        return true;
    }

    public boolean isLeaf() {
        return true;
    }

    public boolean isHierarchical() {
        return false;
    }

    public int getDepth() {
        return 1;
    }

    public int modelToView(int n) {
        return n;
    }

    public int viewToModel(int n) {
        return n;
    }

    public void refresh() {
        this.target.revalidate();
        this.target.repaint();
    }
}

