/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.decorator;

import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jdesktop.swingx.decorator.AbstractHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;

public class BorderHighlighter
extends AbstractHighlighter {
    private Border paddingBorder;
    private boolean inner;
    private boolean compound;

    public BorderHighlighter() {
        this(null, null);
    }

    public BorderHighlighter(HighlightPredicate highlightPredicate) {
        this(highlightPredicate, null);
    }

    public BorderHighlighter(Border border) {
        this(null, border);
    }

    public BorderHighlighter(HighlightPredicate highlightPredicate, Border border) {
        this(highlightPredicate, border, true);
    }

    public BorderHighlighter(HighlightPredicate highlightPredicate, Border border, boolean bl) {
        this(highlightPredicate, border, bl, false);
    }

    public BorderHighlighter(HighlightPredicate highlightPredicate, Border border, boolean bl, boolean bl2) {
        super(highlightPredicate);
        this.paddingBorder = border;
        this.compound = bl;
        this.inner = bl2;
    }

    protected Component doHighlight(Component component, ComponentAdapter componentAdapter) {
        ((JComponent)component).setBorder(this.compoundBorder(((JComponent)component).getBorder()));
        return component;
    }

    protected boolean canHighlight(Component component, ComponentAdapter componentAdapter) {
        return this.getBorder() != null && component instanceof JComponent;
    }

    public void setCompound(boolean bl) {
        if (this.isCompound() == bl) {
            return;
        }
        this.compound = bl;
        this.fireStateChanged();
    }

    public boolean isCompound() {
        return this.compound;
    }

    public void setInner(boolean bl) {
        if (this.isInner() == bl) {
            return;
        }
        this.inner = bl;
        this.fireStateChanged();
    }

    public boolean isInner() {
        return this.inner;
    }

    public void setBorder(Border border) {
        if (this.areEqual(border, this.getBorder())) {
            return;
        }
        this.paddingBorder = border;
        this.fireStateChanged();
    }

    public Border getBorder() {
        return this.paddingBorder;
    }

    private Border compoundBorder(Border border) {
        if (this.compound && border != null) {
            if (this.inner) {
                return BorderFactory.createCompoundBorder(border, this.paddingBorder);
            }
            return BorderFactory.createCompoundBorder(this.paddingBorder, border);
        }
        return this.paddingBorder;
    }
}

