/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.color;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import org.jdesktop.swingx.JXMultiThumbSlider;
import org.jdesktop.swingx.color.ColorUtil;
import org.jdesktop.swingx.multislider.ThumbRenderer;

public class GradientThumbRenderer
extends JComponent
implements ThumbRenderer {
    private Image thumb_black;
    private Image thumb_gray;
    private boolean selected;

    public GradientThumbRenderer() {
        try {
            this.thumb_black = ImageIO.read(this.getClass().getResourceAsStream("/icons/thumb_black.png"));
            this.thumb_gray = ImageIO.read(this.getClass().getResourceAsStream("/icons/thumb_gray.png"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void paintComponent(Graphics graphics) {
        GradientThumbRenderer gradientThumbRenderer = this;
        int n = gradientThumbRenderer.getWidth();
        graphics.setColor(this.getForeground());
        graphics.fillRect(0, 0, n - 1, n - 1);
        if (this.selected) {
            graphics.drawImage(this.thumb_black, 0, 0, null);
        } else {
            graphics.drawImage(this.thumb_gray, 0, 0, null);
        }
    }

    public JComponent getThumbRendererComponent(JXMultiThumbSlider jXMultiThumbSlider, int n, boolean bl) {
        Color color = (Color)jXMultiThumbSlider.getModel().getThumbAt(n).getObject();
        color = ColorUtil.removeAlpha(color);
        this.setForeground(color);
        this.selected = bl;
        return this;
    }
}

