/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.calendar;

import java.util.Date;
import java.util.Locale;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jdesktop.swingx.calendar.AbstractDateSelectionModel;
import org.jdesktop.swingx.calendar.DateSelectionModel;
import org.jdesktop.swingx.event.DateSelectionEvent;
import org.jdesktop.swingx.util.Contract;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleDaySelectionModel
extends AbstractDateSelectionModel {
    private SortedSet<Date> selectedDates = new TreeSet<Date>();
    private SortedSet<Date> unselectableDates = new TreeSet<Date>();

    public SingleDaySelectionModel() {
        this(null);
    }

    public SingleDaySelectionModel(Locale locale) {
        super(locale);
    }

    @Override
    public DateSelectionModel.SelectionMode getSelectionMode() {
        return DateSelectionModel.SelectionMode.SINGLE_SELECTION;
    }

    @Override
    public void setSelectionMode(DateSelectionModel.SelectionMode selectionMode) {
    }

    @Override
    public void addSelectionInterval(Date date, Date date2) {
        this.setSelection(date);
    }

    @Override
    public void setSelectionInterval(Date date, Date date2) {
        this.setSelection(date);
    }

    @Override
    public void removeSelectionInterval(Date date, Date date2) {
        Contract.asNotNull(date, "date must not be null");
        if (this.isSelectionEmpty()) {
            return;
        }
        if (this.isSelectionInInterval(date, date2)) {
            this.selectedDates.clear();
            this.fireValueChanged(DateSelectionEvent.EventType.DATES_REMOVED);
        }
    }

    protected boolean isSelectionInInterval(Date date, Date date2) {
        return !this.selectedDates.first().before(this.startOfDay(date)) && !this.selectedDates.first().after(this.endOfDay(date2));
    }

    protected void setSelection(Date date) {
        Contract.asNotNull(date, "date must not be null");
        if (this.isSelectedStrict(date)) {
            return;
        }
        if (this.isSelectable(date)) {
            this.selectedDates.clear();
            this.selectedDates.add(date);
            this.fireValueChanged(DateSelectionEvent.EventType.DATES_SET);
        }
    }

    private boolean isSelectedStrict(Date date) {
        if (!this.isSelectionEmpty()) {
            return this.selectedDates.first().equals(date);
        }
        return false;
    }

    @Override
    public Date getFirstSelectionDate() {
        return this.isSelectionEmpty() ? null : this.selectedDates.first();
    }

    @Override
    public Date getLastSelectionDate() {
        return this.isSelectionEmpty() ? null : this.selectedDates.last();
    }

    public boolean isSelectable(Date date) {
        if (this.outOfBounds(date)) {
            return false;
        }
        return !this.inUnselectables(date);
    }

    private boolean inUnselectables(Date date) {
        for (Date date2 : this.unselectableDates) {
            if (!this.isSameDay(date2, date)) continue;
            return true;
        }
        return false;
    }

    private boolean outOfBounds(Date date) {
        if (this.belowLowerBound(date)) {
            return true;
        }
        return this.aboveUpperBound(date);
    }

    private boolean aboveUpperBound(Date date) {
        if (this.upperBound != null) {
            return this.endOfDay(this.upperBound).before(date);
        }
        return false;
    }

    private boolean belowLowerBound(Date date) {
        if (this.lowerBound != null) {
            return this.startOfDay(this.lowerBound).after(date);
        }
        return false;
    }

    @Override
    public void clearSelection() {
        if (this.isSelectionEmpty()) {
            return;
        }
        this.selectedDates.clear();
        this.fireValueChanged(DateSelectionEvent.EventType.SELECTION_CLEARED);
    }

    @Override
    public SortedSet<Date> getSelection() {
        return new TreeSet<Date>(this.selectedDates);
    }

    @Override
    public boolean isSelected(Date date) {
        Contract.asNotNull(date, "date must not be null");
        if (this.isSelectionEmpty()) {
            return false;
        }
        return this.isSameDay(this.selectedDates.first(), date);
    }

    @Override
    public Date getNormalizedDate(Date date) {
        return new Date(date.getTime());
    }

    @Override
    public boolean isSelectionEmpty() {
        return this.selectedDates.isEmpty();
    }

    @Override
    public SortedSet<Date> getUnselectableDates() {
        return new TreeSet<Date>(this.unselectableDates);
    }

    @Override
    public void setUnselectableDates(SortedSet<Date> sortedSet) {
        Contract.asNotNull(sortedSet, "unselectable dates must not be null");
        this.unselectableDates.clear();
        for (Date date : sortedSet) {
            this.removeSelectionInterval(date, date);
            this.unselectableDates.add(date);
        }
        this.fireValueChanged(DateSelectionEvent.EventType.UNSELECTED_DATES_CHANGED);
    }

    @Override
    public boolean isUnselectableDate(Date date) {
        return !this.isSelectable(date);
    }
}

