/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.calendar;

import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jdesktop.swingx.calendar.AbstractDateSelectionModel;
import org.jdesktop.swingx.calendar.DateSelectionModel;
import org.jdesktop.swingx.event.DateSelectionEvent;
import org.jdesktop.swingx.util.Contract;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDateSelectionModel
extends AbstractDateSelectionModel {
    private DateSelectionModel.SelectionMode selectionMode = DateSelectionModel.SelectionMode.SINGLE_SELECTION;
    private SortedSet<Date> selectedDates = new TreeSet<Date>();
    private SortedSet<Date> unselectableDates = new TreeSet<Date>();

    public DefaultDateSelectionModel() {
        this(null);
    }

    public DefaultDateSelectionModel(Locale locale) {
        super(locale);
    }

    @Override
    public DateSelectionModel.SelectionMode getSelectionMode() {
        return this.selectionMode;
    }

    @Override
    public void setSelectionMode(DateSelectionModel.SelectionMode selectionMode) {
        this.selectionMode = selectionMode;
        this.clearSelection();
    }

    @Override
    public void addSelectionInterval(Date date, Date date2) {
        if (date.after(date2)) {
            return;
        }
        boolean bl = false;
        switch (this.selectionMode) {
            case SINGLE_SELECTION: {
                if (this.isSelected(date)) {
                    return;
                }
                this.clearSelectionImpl();
                bl = this.addSelectionImpl(date, date);
                break;
            }
            case SINGLE_INTERVAL_SELECTION: {
                if (this.isIntervalSelected(date, date2)) {
                    return;
                }
                this.clearSelectionImpl();
                bl = this.addSelectionImpl(date, date2);
                break;
            }
            case MULTIPLE_INTERVAL_SELECTION: {
                if (this.isIntervalSelected(date, date2)) {
                    return;
                }
                bl = this.addSelectionImpl(date, date2);
                break;
            }
        }
        if (bl) {
            this.fireValueChanged(DateSelectionEvent.EventType.DATES_ADDED);
        }
    }

    @Override
    public void setSelectionInterval(Date date, Date date2) {
        if (DateSelectionModel.SelectionMode.SINGLE_SELECTION.equals((Object)this.selectionMode)) {
            if (this.isSelected(date)) {
                return;
            }
            date2 = date;
        } else if (this.isIntervalSelected(date, date2)) {
            return;
        }
        this.clearSelectionImpl();
        if (this.addSelectionImpl(date, date2)) {
            this.fireValueChanged(DateSelectionEvent.EventType.DATES_SET);
        }
    }

    private boolean isIntervalSelected(Date date, Date date2) {
        if (this.isSelectionEmpty()) {
            return false;
        }
        return this.selectedDates.first().equals(date) && this.selectedDates.last().equals(date2);
    }

    @Override
    public void removeSelectionInterval(Date date, Date date2) {
        if (date.after(date2)) {
            return;
        }
        long l = date.getTime();
        long l2 = date2.getTime();
        ArrayList<Date> arrayList = new ArrayList<Date>();
        for (Date date3 : this.selectedDates) {
            long l3 = date3.getTime();
            if (l3 < l || l3 > l2) continue;
            arrayList.add(date3);
        }
        if (!arrayList.isEmpty()) {
            this.selectedDates.removeAll(arrayList);
            this.fireValueChanged(DateSelectionEvent.EventType.DATES_REMOVED);
        }
    }

    @Override
    public void clearSelection() {
        if (this.isSelectionEmpty()) {
            return;
        }
        this.clearSelectionImpl();
        this.fireValueChanged(DateSelectionEvent.EventType.SELECTION_CLEARED);
    }

    private void clearSelectionImpl() {
        this.selectedDates.clear();
    }

    @Override
    public SortedSet<Date> getSelection() {
        return new TreeSet<Date>(this.selectedDates);
    }

    @Override
    public Date getFirstSelectionDate() {
        return this.isSelectionEmpty() ? null : this.selectedDates.first();
    }

    @Override
    public Date getLastSelectionDate() {
        return this.isSelectionEmpty() ? null : this.selectedDates.last();
    }

    @Override
    public boolean isSelected(Date date) {
        Contract.asNotNull(date, "date must not be null");
        return this.selectedDates.contains(date);
    }

    @Override
    public Date getNormalizedDate(Date date) {
        return new Date(date.getTime());
    }

    @Override
    public boolean isSelectionEmpty() {
        return this.selectedDates.isEmpty();
    }

    @Override
    public SortedSet<Date> getUnselectableDates() {
        return new TreeSet<Date>(this.unselectableDates);
    }

    @Override
    public void setUnselectableDates(SortedSet<Date> sortedSet) {
        this.unselectableDates = sortedSet;
        for (Date date : this.unselectableDates) {
            this.removeSelectionInterval(date, date);
        }
        this.fireValueChanged(DateSelectionEvent.EventType.UNSELECTED_DATES_CHANGED);
    }

    @Override
    public boolean isUnselectableDate(Date date) {
        return this.upperBound != null && this.upperBound.getTime() < date.getTime() || this.lowerBound != null && this.lowerBound.getTime() > date.getTime() || this.unselectableDates != null && this.unselectableDates.contains(date);
    }

    private boolean addSelectionImpl(Date date, Date date2) {
        boolean bl = false;
        this.calendar.setTime(date);
        Date date3 = this.calendar.getTime();
        while (date3.before(date2) || date3.equals(date2)) {
            if (!this.isUnselectableDate(date3)) {
                bl = true;
                this.selectedDates.add(date3);
            }
            this.calendar.add(5, 1);
            date3 = this.calendar.getTime();
        }
        return bl;
    }
}

