/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.autocomplete;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ComboBoxEditor;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import javax.swing.text.TextAction;
import org.jdesktop.swingx.autocomplete.AbstractAutoCompleteAdaptor;
import org.jdesktop.swingx.autocomplete.AutoCompleteComboBoxEditor;
import org.jdesktop.swingx.autocomplete.AutoCompleteDocument;
import org.jdesktop.swingx.autocomplete.AutoCompleteFocusAdapter;
import org.jdesktop.swingx.autocomplete.AutoCompleteKeyAdapter;
import org.jdesktop.swingx.autocomplete.AutoCompletePropertyChangeListener;
import org.jdesktop.swingx.autocomplete.AutoCompleteStyledDocument;
import org.jdesktop.swingx.autocomplete.ComboBoxAdaptor;
import org.jdesktop.swingx.autocomplete.ListAdaptor;
import org.jdesktop.swingx.autocomplete.ObjectToStringConverter;
import org.jdesktop.swingx.autocomplete.TextComponentAdaptor;
import org.jdesktop.swingx.autocomplete.workarounds.MacOSXPopupLocationFix;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoCompleteDecorator {
    static Object errorFeedbackAction = new TextAction("provide-error-feedback"){

        public void actionPerformed(ActionEvent actionEvent) {
            UIManager.getLookAndFeel().provideErrorFeedback(this.getTextComponent(actionEvent));
        }
    };

    private static void removeFocusListener(Component component) {
        FocusListener[] focusListenerArray;
        for (FocusListener focusListener : focusListenerArray = component.getFocusListeners()) {
            if (!(focusListener instanceof AutoCompleteFocusAdapter)) continue;
            component.removeFocusListener(focusListener);
        }
    }

    private static void removeKeyListener(Component component) {
        KeyListener[] keyListenerArray;
        for (KeyListener keyListener : keyListenerArray = component.getKeyListeners()) {
            if (!(keyListener instanceof AutoCompleteKeyAdapter)) continue;
            component.removeKeyListener(keyListener);
        }
    }

    private static void removePropertyChangeListener(Component component) {
        PropertyChangeListener[] propertyChangeListenerArray;
        for (PropertyChangeListener propertyChangeListener : propertyChangeListenerArray = component.getPropertyChangeListeners("editor")) {
            if (!(propertyChangeListener instanceof AutoCompletePropertyChangeListener)) continue;
            component.removePropertyChangeListener("editor", propertyChangeListener);
        }
    }

    private static AutoCompleteDocument createAutoCompleteDocument(AbstractAutoCompleteAdaptor abstractAutoCompleteAdaptor, boolean bl, ObjectToStringConverter objectToStringConverter, Document document) {
        if (document instanceof StyledDocument) {
            return new AutoCompleteStyledDocument(abstractAutoCompleteAdaptor, bl, objectToStringConverter, (StyledDocument)document);
        }
        return new AutoCompleteDocument(abstractAutoCompleteAdaptor, bl, objectToStringConverter, document);
    }

    public static void decorate(JTextComponent jTextComponent, List<?> list, boolean bl) {
        AutoCompleteDecorator.decorate(jTextComponent, list, bl, ObjectToStringConverter.DEFAULT_IMPLEMENTATION);
    }

    public static void decorate(JTextComponent jTextComponent, List<?> list, boolean bl, ObjectToStringConverter objectToStringConverter) {
        TextComponentAdaptor textComponentAdaptor = new TextComponentAdaptor(jTextComponent, list);
        AutoCompleteDocument autoCompleteDocument = AutoCompleteDecorator.createAutoCompleteDocument(textComponentAdaptor, bl, objectToStringConverter, jTextComponent.getDocument());
        AutoCompleteDecorator.decorate(jTextComponent, autoCompleteDocument, textComponentAdaptor);
    }

    public static void decorate(JList jList, JTextComponent jTextComponent) {
        AutoCompleteDecorator.decorate(jList, jTextComponent, ObjectToStringConverter.DEFAULT_IMPLEMENTATION);
    }

    public static void decorate(JList jList, JTextComponent jTextComponent, ObjectToStringConverter objectToStringConverter) {
        ListAdaptor listAdaptor = new ListAdaptor(jList, jTextComponent, objectToStringConverter);
        AutoCompleteDocument autoCompleteDocument = AutoCompleteDecorator.createAutoCompleteDocument(listAdaptor, true, objectToStringConverter, jTextComponent.getDocument());
        AutoCompleteDecorator.decorate(jTextComponent, autoCompleteDocument, listAdaptor);
    }

    public static void decorate(JComboBox jComboBox) {
        AutoCompleteDecorator.decorate(jComboBox, ObjectToStringConverter.DEFAULT_IMPLEMENTATION);
    }

    public static void decorate(final JComboBox jComboBox, final ObjectToStringConverter objectToStringConverter) {
        boolean bl = !jComboBox.isEditable();
        jComboBox.setEditable(true);
        MacOSXPopupLocationFix.install(jComboBox);
        JTextComponent jTextComponent = (JTextComponent)jComboBox.getEditor().getEditorComponent();
        final ComboBoxAdaptor comboBoxAdaptor = new ComboBoxAdaptor(jComboBox);
        final AutoCompleteDocument autoCompleteDocument = AutoCompleteDecorator.createAutoCompleteDocument(comboBoxAdaptor, bl, objectToStringConverter, jTextComponent.getDocument());
        AutoCompleteDecorator.decorate(jTextComponent, autoCompleteDocument, comboBoxAdaptor);
        AutoCompleteDecorator.removeKeyListener(jTextComponent);
        final AutoCompleteKeyAdapter autoCompleteKeyAdapter = new AutoCompleteKeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.isActionKey()) {
                    return;
                }
                if (jComboBox.isDisplayable() && !jComboBox.isPopupVisible()) {
                    int n = keyEvent.getKeyCode();
                    if (n == 16 || n == 17 || n == 18) {
                        return;
                    }
                    if (n == 10 || n == 27) {
                        return;
                    }
                    jComboBox.setPopupVisible(true);
                }
            }
        };
        jTextComponent.addKeyListener(autoCompleteKeyAdapter);
        if (objectToStringConverter != ObjectToStringConverter.DEFAULT_IMPLEMENTATION) {
            jComboBox.setEditor(new AutoCompleteComboBoxEditor(jComboBox.getEditor(), objectToStringConverter));
        }
        AutoCompleteDecorator.removePropertyChangeListener(jComboBox);
        jComboBox.addPropertyChangeListener("editor", new AutoCompletePropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ComboBoxEditor comboBoxEditor = (ComboBoxEditor)propertyChangeEvent.getOldValue();
                if (comboBoxEditor != null && comboBoxEditor.getEditorComponent() != null) {
                    AutoCompleteDecorator.removeKeyListener(comboBoxEditor.getEditorComponent());
                }
                if ((comboBoxEditor = (ComboBoxEditor)propertyChangeEvent.getNewValue()) != null && comboBoxEditor.getEditorComponent() != null) {
                    if (!(comboBoxEditor instanceof AutoCompleteComboBoxEditor) && objectToStringConverter != ObjectToStringConverter.DEFAULT_IMPLEMENTATION) {
                        jComboBox.setEditor(new AutoCompleteComboBoxEditor(comboBoxEditor, objectToStringConverter));
                    } else {
                        AutoCompleteDecorator.decorate((JTextComponent)comboBoxEditor.getEditorComponent(), autoCompleteDocument, comboBoxAdaptor);
                        comboBoxEditor.getEditorComponent().addKeyListener(autoCompleteKeyAdapter);
                    }
                }
            }
        });
    }

    public static void decorate(JTextComponent jTextComponent, AutoCompleteDocument autoCompleteDocument, final AbstractAutoCompleteAdaptor abstractAutoCompleteAdaptor) {
        jTextComponent.setDocument(autoCompleteDocument);
        AutoCompleteDecorator.removeFocusListener(jTextComponent);
        jTextComponent.addFocusListener(new AutoCompleteFocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                abstractAutoCompleteAdaptor.markEntireText();
            }
        });
        InputMap inputMap = jTextComponent.getInputMap();
        if (autoCompleteDocument.isStrictMatching()) {
            inputMap.put(KeyStroke.getKeyStroke(8, 0), "selection-backward");
            inputMap.put(KeyStroke.getKeyStroke(127, 0), errorFeedbackAction);
            inputMap.put(KeyStroke.getKeyStroke(88, 128), errorFeedbackAction);
        } else {
            ActionMap actionMap = jTextComponent.getActionMap();
            inputMap.put(KeyStroke.getKeyStroke(8, 0), "nonstrict-backspace");
            actionMap.put("nonstrict-backspace", new NonStrictBackspaceAction(actionMap.get("delete-previous"), actionMap.get("selection-backward"), abstractAutoCompleteAdaptor));
        }
    }

    static class NonStrictBackspaceAction
    extends TextAction {
        Action backspace;
        Action selectionBackward;
        AbstractAutoCompleteAdaptor adaptor;

        public NonStrictBackspaceAction(Action action, Action action2, AbstractAutoCompleteAdaptor abstractAutoCompleteAdaptor) {
            super("nonstrict-backspace");
            this.backspace = action;
            this.selectionBackward = action2;
            this.adaptor = abstractAutoCompleteAdaptor;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.adaptor.listContainsSelectedItem()) {
                this.selectionBackward.actionPerformed(actionEvent);
            } else {
                this.backspace.actionPerformed(actionEvent);
            }
        }
    }
}

