/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.auth;

import java.awt.EventQueue;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.EventListenerList;
import org.jdesktop.beans.AbstractBean;
import org.jdesktop.swingx.auth.LoginEvent;
import org.jdesktop.swingx.auth.LoginListener;

public abstract class LoginService
extends AbstractBean {
    private Logger LOG = Logger.getLogger(LoginService.class.getName());
    private EventListenerList listenerList = new EventListenerList();
    private SwingWorker<Boolean, Void> loginWorker;
    private boolean synchronous;
    private String server;

    public LoginService() {
    }

    public LoginService(String string) {
        this.setServer(string);
    }

    public abstract boolean authenticate(String var1, char[] var2, String var3) throws Exception;

    public String[] getUserRoles() {
        return null;
    }

    public void cancelAuthentication() {
        if (this.loginWorker != null) {
            this.loginWorker.cancel(true);
        }
    }

    public void startAuthentication(final String string, final char[] cArray, final String string2) throws Exception {
        block5: {
            if (this.getSynchronous()) {
                try {
                    if (this.authenticate(string, cArray, string2)) {
                        this.fireLoginSucceeded(new LoginEvent(this));
                        break block5;
                    }
                    this.fireLoginFailed(new LoginEvent(this));
                }
                catch (Throwable throwable) {
                    this.fireLoginFailed(new LoginEvent(this, throwable));
                }
            } else {
                this.loginWorker = new SwingWorker<Boolean, Void>(){

                    @Override
                    protected Boolean doInBackground() throws Exception {
                        try {
                            final boolean bl = LoginService.this.authenticate(string, cArray, string2);
                            if (this.isCancelled()) {
                                EventQueue.invokeLater(new Runnable(){

                                    public void run() {
                                        LoginService.this.fireLoginCanceled(new LoginEvent(this));
                                    }
                                });
                                return false;
                            }
                            EventQueue.invokeLater(new Runnable(){

                                public void run() {
                                    if (bl) {
                                        LoginService.this.fireLoginSucceeded(new LoginEvent(LoginService.this));
                                    } else {
                                        LoginService.this.fireLoginFailed(new LoginEvent(LoginService.this));
                                    }
                                }
                            });
                            return bl;
                        }
                        catch (Throwable throwable) {
                            if (!this.isCancelled()) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        LoginService.this.fireLoginFailed(new LoginEvent(LoginService.this, throwable));
                                    }
                                });
                            } else {
                                EventQueue.invokeLater(new Runnable(){

                                    public void run() {
                                        LoginService.this.fireLoginCanceled(new LoginEvent(this));
                                    }
                                });
                            }
                            return false;
                        }
                    }
                };
                this.loginWorker.execute();
                this.fireLoginStarted(new LoginEvent(this));
            }
        }
    }

    public boolean getSynchronous() {
        return this.synchronous;
    }

    public void setSynchronous(boolean bl) {
        boolean bl2 = this.getSynchronous();
        this.synchronous = bl;
        this.firePropertyChange("synchronous", bl2, this.getSynchronous());
    }

    public void addLoginListener(LoginListener loginListener) {
        this.listenerList.add(LoginListener.class, loginListener);
    }

    public void removeLoginListener(LoginListener loginListener) {
        this.listenerList.remove(LoginListener.class, loginListener);
    }

    void fireLoginStarted(LoginEvent loginEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != LoginListener.class) continue;
            ((LoginListener)objectArray[i + 1]).loginStarted(loginEvent);
        }
    }

    void fireLoginSucceeded(LoginEvent loginEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != LoginListener.class) continue;
            ((LoginListener)objectArray[i + 1]).loginSucceeded(loginEvent);
        }
    }

    void fireLoginFailed(LoginEvent loginEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != LoginListener.class) continue;
            ((LoginListener)objectArray[i + 1]).loginFailed(loginEvent);
        }
    }

    void fireLoginCanceled(LoginEvent loginEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != LoginListener.class) continue;
            ((LoginListener)objectArray[i + 1]).loginCanceled(loginEvent);
        }
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String string) {
        String string2 = this.getServer();
        this.server = string;
        this.firePropertyChange("server", string2, this.getServer());
    }
}

