/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.auth;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.spec.SecretKeySpec;

public class KeyChain {
    private static final Logger LOG = Logger.getLogger(KeyChain.class.getName());
    private KeyStore store;
    private char[] masterPassword;

    public KeyChain(char[] cArray, InputStream inputStream) throws IOException {
        this.masterPassword = cArray;
        try {
            this.store = KeyStore.getInstance("JCEKS");
            this.store.load(inputStream, cArray);
        }
        catch (KeyStoreException keyStoreException) {
            LOG.log(Level.WARNING, "", keyStoreException);
        }
        catch (CertificateException certificateException) {
            LOG.log(Level.WARNING, "", certificateException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            LOG.log(Level.WARNING, "", noSuchAlgorithmException);
        }
        catch (EOFException eOFException) {
            LOG.log(Level.WARNING, "", eOFException);
        }
    }

    public String getPassword(String string, String string2) {
        try {
            KeyStore.SecretKeyEntry secretKeyEntry = (KeyStore.SecretKeyEntry)this.store.getEntry(string + "@" + string2, new KeyStore.PasswordProtection(this.masterPassword));
            return new String(secretKeyEntry.getSecretKey().getEncoded());
        }
        catch (KeyStoreException keyStoreException) {
            LOG.log(Level.WARNING, "", keyStoreException);
        }
        catch (UnrecoverableEntryException unrecoverableEntryException) {
            LOG.log(Level.WARNING, "", unrecoverableEntryException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            LOG.log(Level.WARNING, "", noSuchAlgorithmException);
        }
        return null;
    }

    public void addPassword(String string, String string2, char[] cArray) {
        String string3 = new String(cArray);
        SecretKeySpec secretKeySpec = new SecretKeySpec(string3.getBytes(), "JCEKS");
        KeyStore.SecretKeyEntry secretKeyEntry = new KeyStore.SecretKeyEntry(secretKeySpec);
        try {
            this.store.setEntry(string + "@" + string2, secretKeyEntry, new KeyStore.PasswordProtection(this.masterPassword));
        }
        catch (KeyStoreException keyStoreException) {
            LOG.log(Level.WARNING, "", keyStoreException);
        }
    }

    public void removePassword(String string, String string2) {
        try {
            this.store.deleteEntry(string + "@" + string2);
        }
        catch (KeyStoreException keyStoreException) {
            LOG.log(Level.WARNING, "", keyStoreException);
        }
    }

    public void store(OutputStream outputStream) throws IOException {
        try {
            this.store.store(outputStream, this.masterPassword);
        }
        catch (KeyStoreException keyStoreException) {
            LOG.log(Level.WARNING, "", keyStoreException);
        }
        catch (CertificateException certificateException) {
            LOG.log(Level.WARNING, "", certificateException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            LOG.log(Level.WARNING, "", noSuchAlgorithmException);
        }
    }

    public static void main(String[] stringArray) {
        try {
            int n;
            FileInputStream fileInputStream;
            File file = new File("c:\\test.txt");
            if (!file.exists()) {
                file.createNewFile();
                fileInputStream = null;
            } else {
                fileInputStream = new FileInputStream(file);
            }
            KeyChain keyChain = new KeyChain("test".toCharArray(), fileInputStream);
            keyChain.addPassword("bino", "sun-ds.sfbay", "test123".toCharArray());
            LOG.fine("pass = " + keyChain.getPassword("bino", "sun-ds.sfbay"));
            LOG.fine("More testing :");
            for (n = 0; n < 100; ++n) {
                keyChain.addPassword("" + n, "sun-ds.sfbay", ("" + n).toCharArray());
            }
            for (n = 0; n < 100; ++n) {
                LOG.fine("key =" + n + " pass =" + keyChain.getPassword("" + n, "sun-ds.sfbay"));
            }
            keyChain.store(new FileOutputStream(file));
        }
        catch (Exception exception) {
            LOG.log(Level.WARNING, "", exception);
        }
    }
}

