/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.action;

import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.AccessControlException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Icon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerAction
extends AbstractAction {
    private static final Logger LOG = Logger.getLogger(ServerAction.class.getName());

    public ServerAction() {
        this("action");
    }

    public ServerAction(String string) {
        super(string);
    }

    public ServerAction(String string, String string2) {
        this(string, string2, null);
    }

    public ServerAction(String string, Icon icon) {
        super(string, icon);
    }

    public ServerAction(String string, String string2, Icon icon) {
        super(string, icon);
        this.putValue("ActionCommandKey", string2);
    }

    public void setURL(String string) {
        this.putValue("action-url", string);
        this.putValue("_URL-CACHE__", null);
    }

    public String getURL() {
        return (String)this.getValue("action-url");
    }

    private Map<String, String> getParams() {
        return (Map)this.getValue("action-params");
    }

    private void setParams(Map<String, String> map) {
        this.putValue("action-params", map);
    }

    public void addParam(String string, String string2) {
        Map<String, String> map = this.getParams();
        if (map == null) {
            map = new HashMap<String, String>();
            this.setParams(map);
        }
        map.put(string, string2);
    }

    public String getParamValue(String string) {
        Map<String, String> map = this.getParams();
        return map == null ? null : map.get(string);
    }

    public Set<String> getParamNames() {
        Map<String, String> map = this.getParams();
        return map == null ? null : map.keySet();
    }

    private Map<String, String> getHeaders() {
        return (Map)this.getValue("action-headers");
    }

    private void setHeaders(Map<String, String> map) {
        this.putValue("action-headers", map);
    }

    public void addHeader(String string, String string2) {
        Map<String, String> map = this.getHeaders();
        if (map == null) {
            map = new HashMap<String, String>();
            this.setHeaders(map);
        }
        map.put(string, string2);
    }

    public String getHeaderValue(String string) {
        Map<String, String> map = this.getHeaders();
        return map == null ? null : map.get(string);
    }

    public Set<String> getHeaderNames() {
        Map<String, String> map = this.getHeaders();
        return map == null ? null : map.keySet();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        URL uRL = (URL)this.getValue("_URL-CACHE__");
        if (uRL == null && !"".equals(this.getURL())) {
            try {
                object = this.getURL();
                if (((String)object).startsWith("http")) {
                    uRL = new URL((String)object);
                }
                if (uRL == null) {
                    return;
                }
                this.putValue("_URL-CACHE__", uRL);
            }
            catch (MalformedURLException malformedURLException) {
                LOG.log(Level.WARNING, "something went wrong...", malformedURLException);
            }
        }
        try {
            object = uRL.openConnection();
            Set<String> set = this.getHeaderNames();
            if (set != null && !set.isEmpty()) {
                for (String object22 : set) {
                    ((URLConnection)object).setRequestProperty(object22, this.getHeaderValue(object22));
                }
            }
            ((URLConnection)object).setUseCaches(false);
            ((URLConnection)object).setDoOutput(true);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
            PrintWriter printWriter = new PrintWriter(byteArrayOutputStream, true);
            printWriter.print(this.getPostData());
            printWriter.flush();
            String string = String.valueOf(byteArrayOutputStream.size());
            ((URLConnection)object).setRequestProperty("Content-length", string);
            byteArrayOutputStream.writeTo(((URLConnection)object).getOutputStream());
            BufferedReader bufferedReader = null;
            if (object instanceof HttpURLConnection) {
                String string2;
                HttpURLConnection httpURLConnection = (HttpURLConnection)object;
                int n = httpURLConnection.getResponseCode();
                String string3 = httpURLConnection.getResponseMessage();
                bufferedReader = n < 400 ? new BufferedReader(new InputStreamReader(((URLConnection)object).getInputStream())) : new BufferedReader(new InputStreamReader(httpURLConnection.getErrorStream()));
                StringBuffer stringBuffer = new StringBuffer();
                while ((string2 = bufferedReader.readLine()) != null) {
                    stringBuffer.append(string2);
                    stringBuffer.append('\n');
                }
                LOG.finer("returned from connection\n" + stringBuffer.toString());
            }
        }
        catch (UnknownHostException unknownHostException) {
            LOG.log(Level.WARNING, "UnknownHostException detected. Could it be a proxy issue?", unknownHostException);
        }
        catch (AccessControlException accessControlException) {
            LOG.log(Level.WARNING, "AccessControlException detected", accessControlException);
        }
        catch (IOException iOException) {
            LOG.log(Level.WARNING, "IOException detected", iOException);
        }
    }

    private String getPostData() {
        StringBuffer stringBuffer = new StringBuffer();
        Set<String> set = this.getParamNames();
        if (set != null && !set.isEmpty()) {
            Iterator<String> iterator = set.iterator();
            try {
                while (iterator.hasNext()) {
                    String string = iterator.next();
                    stringBuffer.append('&').append(string).append('=');
                    stringBuffer.append(this.getParamValue(string));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            stringBuffer.setCharAt(0, '?');
        }
        LOG.finer("ServerAction: POST data: " + stringBuffer.toString());
        return stringBuffer.toString();
    }
}

