/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import org.jdesktop.swingx.JXPanel;

public class JXTitledSeparator
extends JXPanel {
    private JLabel label;
    private JSeparator leftSeparator;
    private JSeparator rightSeparator;

    public JXTitledSeparator() {
        this("Untitled");
    }

    public JXTitledSeparator(String string) {
        this(string, 10, null);
    }

    public JXTitledSeparator(String string, int n) {
        this(string, n, null);
    }

    public JXTitledSeparator(String string, int n, Icon icon) {
        this.setLayout(new GridBagLayout());
        this.label = new JLabel(string){

            public void updateUI() {
                super.updateUI();
                JXTitledSeparator.this.updateTitle();
            }
        };
        this.label.setIcon(icon);
        this.label.setHorizontalAlignment(n);
        this.leftSeparator = new JSeparator();
        this.rightSeparator = new JSeparator();
        this.layoutSeparator();
        this.updateTitle();
        this.setOpaque(false);
    }

    protected void updateTitle() {
        Font font;
        if (this.label == null) {
            return;
        }
        Color color = this.label.getForeground();
        if (color == null || color instanceof ColorUIResource) {
            this.setForeground(UIManager.getColor("TitledBorder.titleColor"));
        }
        if ((font = this.label.getFont()) == null || font instanceof FontUIResource) {
            this.setFont(UIManager.getFont("TitledBorder.font"));
        }
    }

    private void layoutSeparator() {
        this.removeAll();
        int n = this.getHorizontalAlignment();
        if (!this.getComponentOrientation().isLeftToRight()) {
            switch (n) {
                case 2: {
                    n = 4;
                    break;
                }
                case 4: {
                    n = 2;
                    break;
                }
                case 3: {
                    n = 7;
                    break;
                }
                case 7: {
                    n = 3;
                    break;
                }
            }
        }
        switch (n) {
            case 2: 
            case 7: 
            case 10: {
                this.add((Component)this.label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.add(Box.createHorizontalStrut(3), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.add((Component)this.rightSeparator, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
                break;
            }
            case 3: 
            case 4: 
            case 11: {
                this.add((Component)this.rightSeparator, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
                this.add(Box.createHorizontalStrut(3), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.add((Component)this.label, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
                break;
            }
            default: {
                this.add((Component)this.leftSeparator, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
                this.add(Box.createHorizontalStrut(3), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.add((Component)this.label, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.add(Box.createHorizontalStrut(3), new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.add((Component)this.rightSeparator, new GridBagConstraints(4, 0, 1, 1, 0.5, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
            }
        }
    }

    public void setTitle(String string) {
        String string2 = this.getTitle();
        this.label.setText(string);
        this.firePropertyChange("title", string2, this.getTitle());
    }

    public String getTitle() {
        return this.label.getText();
    }

    public void setHorizontalAlignment(int n) {
        int n2 = this.getHorizontalAlignment();
        this.label.setHorizontalAlignment(n);
        if (n2 != this.getHorizontalAlignment()) {
            this.layoutSeparator();
        }
        this.firePropertyChange("horizontalAlignment", n2, this.getHorizontalAlignment());
    }

    public int getHorizontalAlignment() {
        return this.label.getHorizontalAlignment();
    }

    public void setHorizontalTextPosition(int n) {
        int n2 = this.getHorizontalTextPosition();
        this.label.setHorizontalTextPosition(n);
        this.firePropertyChange("horizontalTextPosition", n2, this.getHorizontalTextPosition());
    }

    public int getHorizontalTextPosition() {
        return this.label.getHorizontalTextPosition();
    }

    public ComponentOrientation getComponentOrientation() {
        return this.label.getComponentOrientation();
    }

    public void setComponentOrientation(ComponentOrientation componentOrientation) {
        ComponentOrientation componentOrientation2 = this.label.getComponentOrientation();
        this.label.setComponentOrientation(componentOrientation);
        this.firePropertyChange("componentOrientation", componentOrientation2, this.label.getComponentOrientation());
    }

    public void setIcon(Icon icon) {
        Icon icon2 = this.getIcon();
        this.label.setIcon(icon);
        this.firePropertyChange("icon", icon2, this.getIcon());
    }

    public Icon getIcon() {
        return this.label.getIcon();
    }

    public void setForeground(Color color) {
        if (this.label != null) {
            this.label.setForeground(color);
        }
        super.setForeground(color);
    }

    public void setFont(Font font) {
        if (this.label != null) {
            this.label.setFont(font);
        }
        super.setFont(font);
    }
}

