/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.print.PrinterException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTableHeader;
import org.jdesktop.swingx.SwingXUtilities;
import org.jdesktop.swingx.UIAction;
import org.jdesktop.swingx.action.AbstractActionExt;
import org.jdesktop.swingx.action.BoundAction;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.CompoundHighlighter;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.ResetDTCRColorHighlighter;
import org.jdesktop.swingx.decorator.UIDependent;
import org.jdesktop.swingx.event.TableColumnModelExtListener;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;
import org.jdesktop.swingx.plaf.UIManagerExt;
import org.jdesktop.swingx.renderer.AbstractRenderer;
import org.jdesktop.swingx.renderer.CheckBoxProvider;
import org.jdesktop.swingx.renderer.DefaultTableRenderer;
import org.jdesktop.swingx.renderer.IconValues;
import org.jdesktop.swingx.renderer.MappedValue;
import org.jdesktop.swingx.renderer.StringValue;
import org.jdesktop.swingx.renderer.StringValues;
import org.jdesktop.swingx.rollover.RolloverProducer;
import org.jdesktop.swingx.rollover.TableRolloverController;
import org.jdesktop.swingx.rollover.TableRolloverProducer;
import org.jdesktop.swingx.search.SearchFactory;
import org.jdesktop.swingx.search.Searchable;
import org.jdesktop.swingx.search.TableSearchable;
import org.jdesktop.swingx.sort.SortController;
import org.jdesktop.swingx.sort.SortUtils;
import org.jdesktop.swingx.sort.StringValueRegistry;
import org.jdesktop.swingx.sort.TableSortController;
import org.jdesktop.swingx.table.ColumnControlButton;
import org.jdesktop.swingx.table.ColumnFactory;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.jdesktop.swingx.table.TableColumnExt;
import org.jdesktop.swingx.table.TableColumnModelExt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JXTable
extends JTable
implements TableColumnModelExtListener {
    public static final String FOCUS_PREVIOUS_COMPONENT = "focusPreviousComponent";
    public static final String FOCUS_NEXT_COMPONENT = "focusNextComponent";
    private static final Logger LOG = Logger.getLogger(JXTable.class.getName());
    public static final String HORIZONTALSCROLL_ACTION_COMMAND = "column.horizontalScroll";
    public static final String PACKALL_ACTION_COMMAND = "column.packAll";
    public static final String PACKSELECTED_ACTION_COMMAND = "column.packSelected";
    public static final String UIPREFIX = "JXTable.";
    public static final String MATCH_HIGHLIGHTER = "match.highlighter";
    protected CompoundHighlighter compoundHighlighter;
    public static final String USE_DTCR_COLORMEMORY_HACK = "useDTCRColorMemoryHack";
    protected Highlighter resetDefaultTableCellRendererHighlighter;
    protected ComponentAdapter dataAdapter;
    private ChangeListener highlighterChangeListener;
    private ColumnFactory columnFactory;
    private int visibleRowCount = 20;
    private int visibleColumnCount = -1;
    private boolean columnControlVisible;
    private int verticalScrollPolicy;
    private JComponent columnControlButton;
    private RolloverProducer rolloverProducer;
    private TableRolloverController<JXTable> linkController;
    private int oldAutoResizeMode;
    private boolean intelliMode;
    private boolean inLayout;
    protected boolean isXTableRowHeightSet;
    protected Searchable searchable;
    private boolean editable;
    private Dimension calculatedPrefScrollableViewportSize;
    private boolean autoCreateRowSorter;
    private boolean sortable;
    private boolean sortsOnUpdates;
    private boolean ignoreAddColumn;
    private StringValueRegistry stringValueRegistry;
    protected transient CellEditorRemover editorRemover;

    public JXTable() {
        this.init();
    }

    public JXTable(TableModel tableModel) {
        super(tableModel);
        this.init();
    }

    public JXTable(TableModel tableModel, TableColumnModel tableColumnModel) {
        super(tableModel, tableColumnModel);
        this.init();
    }

    public JXTable(TableModel tableModel, TableColumnModel tableColumnModel, ListSelectionModel listSelectionModel) {
        super(tableModel, tableColumnModel, listSelectionModel);
        this.init();
    }

    public JXTable(int n, int n2) {
        super(n, n2);
        this.init();
    }

    public JXTable(Vector vector, Vector vector2) {
        super(vector, vector2);
        this.init();
    }

    public JXTable(Object[][] objectArray, Object[] objectArray2) {
        super(objectArray, objectArray2);
        this.init();
    }

    private void init() {
        this.putClientProperty(USE_DTCR_COLORMEMORY_HACK, Boolean.TRUE);
        this.initDefaultStringValues();
        this.setEditable(true);
        this.setAutoCreateRowSorter(true);
        this.setSortsOnUpdates(true);
        this.setSortable(true);
        this.setRolloverEnabled(true);
        this.setTerminateEditOnFocusLost(true);
        this.initActionsAndBindings();
        this.initFocusBindings();
        this.updateRowHeightUI(false);
        this.setPreferredScrollableViewportSize(null);
        this.initializeColumnWidths();
        this.setFillsViewportHeight(true);
        this.updateLocaleState(this.getLocale());
    }

    public void setRolloverEnabled(boolean bl) {
        boolean bl2 = this.isRolloverEnabled();
        if (bl == bl2) {
            return;
        }
        if (bl) {
            this.rolloverProducer = this.createRolloverProducer();
            this.addMouseListener(this.rolloverProducer);
            this.addMouseMotionListener(this.rolloverProducer);
            this.getLinkController().install(this);
        } else {
            this.removeMouseListener(this.rolloverProducer);
            this.removeMouseMotionListener(this.rolloverProducer);
            this.rolloverProducer = null;
            this.getLinkController().release();
        }
        this.firePropertyChange("rolloverEnabled", bl2, this.isRolloverEnabled());
    }

    public boolean isRolloverEnabled() {
        return this.rolloverProducer != null;
    }

    protected TableRolloverController<JXTable> getLinkController() {
        if (this.linkController == null) {
            this.linkController = this.createLinkController();
        }
        return this.linkController;
    }

    protected TableRolloverController<JXTable> createLinkController() {
        return new TableRolloverController<JXTable>();
    }

    protected RolloverProducer createRolloverProducer() {
        return new TableRolloverProducer();
    }

    public boolean isColumnControlVisible() {
        return this.columnControlVisible;
    }

    public void setColumnControlVisible(boolean bl) {
        if (this.isColumnControlVisible() == bl) {
            return;
        }
        boolean bl2 = this.isColumnControlVisible();
        if (bl2) {
            this.unconfigureColumnControl();
        }
        this.columnControlVisible = bl;
        if (this.isColumnControlVisible()) {
            this.configureColumnControl();
        }
        this.firePropertyChange("columnControlVisible", bl2, !bl2);
    }

    public JComponent getColumnControl() {
        if (this.columnControlButton == null) {
            this.columnControlButton = this.createDefaultColumnControl();
        }
        return this.columnControlButton;
    }

    public void setColumnControl(JComponent jComponent) {
        JComponent jComponent2 = this.columnControlButton;
        this.columnControlButton = jComponent;
        this.configureColumnControl();
        this.firePropertyChange("columnControl", jComponent2, this.getColumnControl());
    }

    protected JComponent createDefaultColumnControl() {
        return new ColumnControlButton(this);
    }

    @Override
    public void setComponentOrientation(ComponentOrientation componentOrientation) {
        super.setComponentOrientation(componentOrientation);
        this.configureColumnControl();
    }

    @Override
    protected void configureEnclosingScrollPane() {
        super.configureEnclosingScrollPane();
        this.configureColumnControl();
    }

    @Override
    protected void unconfigureEnclosingScrollPane() {
        this.unconfigureColumnControl();
        super.unconfigureEnclosingScrollPane();
    }

    protected void unconfigureColumnControl() {
        Container container;
        Container container2 = this.getParent();
        if (container2 instanceof JViewport && (container = container2.getParent()) instanceof JScrollPane) {
            JScrollPane jScrollPane = (JScrollPane)container;
            JViewport jViewport = jScrollPane.getViewport();
            if (jViewport == null || jViewport.getView() != this) {
                return;
            }
            if (this.verticalScrollPolicy != 0) {
                jScrollPane.setVerticalScrollBarPolicy(this.verticalScrollPolicy);
                this.verticalScrollPolicy = 0;
            }
            if (this.isColumnControlVisible()) {
                jScrollPane.setCorner("UPPER_TRAILING_CORNER", null);
            }
        }
    }

    protected void configureColumnControl() {
        Container container;
        Container container2 = this.getParent();
        if (container2 instanceof JViewport && (container = container2.getParent()) instanceof JScrollPane) {
            JScrollPane jScrollPane = (JScrollPane)container;
            JViewport jViewport = jScrollPane.getViewport();
            if (jViewport == null || jViewport.getView() != this) {
                return;
            }
            if (this.isColumnControlVisible()) {
                if (this.verticalScrollPolicy == 0) {
                    this.verticalScrollPolicy = jScrollPane.getVerticalScrollBarPolicy();
                }
                jScrollPane.setCorner("UPPER_TRAILING_CORNER", this.getColumnControl());
                jScrollPane.setVerticalScrollBarPolicy(22);
            }
        }
    }

    private void initFocusBindings() {
        this.setFocusTraversalKeys(0, new TreeSet());
        this.setFocusTraversalKeys(1, new TreeSet());
        this.getInputMap(1).put(KeyStroke.getKeyStroke("ctrl TAB"), FOCUS_NEXT_COMPONENT);
        this.getInputMap(1).put(KeyStroke.getKeyStroke("shift ctrl TAB"), FOCUS_PREVIOUS_COMPONENT);
        this.getActionMap().put(FOCUS_NEXT_COMPONENT, this.createFocusTransferAction(true));
        this.getActionMap().put(FOCUS_PREVIOUS_COMPONENT, this.createFocusTransferAction(false));
    }

    private Action createFocusTransferAction(boolean bl) {
        BoundAction boundAction = new BoundAction(null, bl ? FOCUS_NEXT_COMPONENT : FOCUS_PREVIOUS_COMPONENT);
        boundAction.registerCallback(this, bl ? "transferFocus" : "transferFocusBackward");
        return boundAction;
    }

    private void initActionsAndBindings() {
        ActionMap actionMap = this.getActionMap();
        actionMap.put("print", new Actions("print"));
        actionMap.put("find", new Actions("find"));
        actionMap.put("cancel", this.createCancelAction());
        actionMap.put(PACKALL_ACTION_COMMAND, this.createPackAllAction());
        actionMap.put(PACKSELECTED_ACTION_COMMAND, this.createPackSelectedAction());
        actionMap.put(HORIZONTALSCROLL_ACTION_COMMAND, this.createHorizontalScrollAction());
        KeyStroke keyStroke = SearchFactory.getInstance().getSearchAccelerator();
        this.getInputMap(1).put(keyStroke, "find");
    }

    private Action createCancelAction() {
        AbstractActionExt abstractActionExt = new AbstractActionExt(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!JXTable.this.isEditing()) {
                    return;
                }
                JXTable.this.getCellEditor().cancelCellEditing();
            }

            public boolean isEnabled() {
                return JXTable.this.isEditing();
            }
        };
        return abstractActionExt;
    }

    private Action createHorizontalScrollAction() {
        BoundAction boundAction = new BoundAction(null, HORIZONTALSCROLL_ACTION_COMMAND);
        boundAction.setStateAction();
        boundAction.registerCallback(this, "setHorizontalScrollEnabled");
        boundAction.setSelected(this.isHorizontalScrollEnabled());
        return boundAction;
    }

    protected String getUIString(String string) {
        return this.getUIString(string, this.getLocale());
    }

    protected String getUIString(String string, Locale locale) {
        String string2 = UIManagerExt.getString(UIPREFIX + string, locale);
        return string2 != null ? string2 : string;
    }

    private Action createPackSelectedAction() {
        BoundAction boundAction = new BoundAction(null, PACKSELECTED_ACTION_COMMAND);
        boundAction.registerCallback(this, "packSelected");
        boundAction.setEnabled(this.getSelectedColumnCount() > 0);
        return boundAction;
    }

    private Action createPackAllAction() {
        BoundAction boundAction = new BoundAction(null, PACKALL_ACTION_COMMAND);
        boundAction.registerCallback(this, "packAll");
        return boundAction;
    }

    @Override
    public void setLocale(Locale locale) {
        this.updateLocaleState(locale);
        super.setLocale(locale);
    }

    protected void updateLocaleState(Locale locale) {
        this.updateLocaleActionState(HORIZONTALSCROLL_ACTION_COMMAND, locale);
        this.updateLocaleActionState(PACKALL_ACTION_COMMAND, locale);
        this.updateLocaleActionState(PACKSELECTED_ACTION_COMMAND, locale);
    }

    protected void updateLocaleActionState(String string, Locale locale) {
        Action action = this.getActionMap().get(string);
        if (action == null) {
            return;
        }
        action.putValue("Name", this.getUIString(string, locale));
    }

    public void packAll() {
        this.packTable(-1);
    }

    public void packSelected() {
        int n = this.getColumnModel().getSelectionModel().getLeadSelectionIndex();
        if (n >= 0) {
            this.packColumn(n, -1);
        }
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        super.columnSelectionChanged(listSelectionEvent);
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        Action action = this.getActionMap().get(PACKSELECTED_ACTION_COMMAND);
        if (action != null) {
            action.setEnabled(!((ListSelectionModel)listSelectionEvent.getSource()).isSelectionEmpty());
        }
    }

    public void setHorizontalScrollEnabled(boolean bl) {
        if (bl == this.isHorizontalScrollEnabled()) {
            return;
        }
        boolean bl2 = this.isHorizontalScrollEnabled();
        if (bl) {
            if (this.getAutoResizeMode() != 0) {
                this.oldAutoResizeMode = this.getAutoResizeMode();
            }
            this.setAutoResizeMode(0);
            this.intelliMode = true;
            this.updateHorizontalAction();
        } else {
            this.setAutoResizeMode(this.oldAutoResizeMode);
        }
        this.firePropertyChange("horizontalScrollEnabled", bl2, this.isHorizontalScrollEnabled());
    }

    public boolean isHorizontalScrollEnabled() {
        return this.intelliMode && this.getAutoResizeMode() == 0;
    }

    @Override
    public void setAutoResizeMode(int n) {
        if (n != 0) {
            this.oldAutoResizeMode = n;
        }
        this.intelliMode = false;
        super.setAutoResizeMode(n);
        this.updateHorizontalAction();
    }

    protected void updateHorizontalAction() {
        Action action = this.getActionMap().get(HORIZONTALSCROLL_ACTION_COMMAND);
        if (action instanceof BoundAction) {
            ((BoundAction)action).setSelected(this.isHorizontalScrollEnabled());
        }
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        boolean bl = super.getScrollableTracksViewportWidth();
        if (this.isHorizontalScrollEnabled()) {
            return this.hasExcessWidth();
        }
        return bl;
    }

    @Override
    public void doLayout() {
        int n = this.getAutoResizeMode();
        if (this.isHorizontalScrollEnabled() && this.hasRealizedParent() && this.hasExcessWidth()) {
            this.autoResizeMode = this.oldAutoResizeMode;
        }
        this.inLayout = true;
        super.doLayout();
        this.inLayout = false;
        this.autoResizeMode = n;
    }

    private boolean hasRealizedParent() {
        return this.getWidth() > 0 && this.getParent() != null && this.getParent().getWidth() > 0;
    }

    private boolean hasExcessWidth() {
        return this.getPreferredSize().width < this.getParent().getWidth();
    }

    @Override
    public void columnMarginChanged(ChangeEvent changeEvent) {
        TableColumn tableColumn;
        if (this.isEditing()) {
            this.removeEditor();
        }
        if ((tableColumn = this.getResizingColumn()) != null && this.autoResizeMode == 0 && !this.inLayout) {
            tableColumn.setPreferredWidth(tableColumn.getWidth());
        }
        this.resizeAndRepaint();
    }

    private TableColumn getResizingColumn() {
        return this.tableHeader == null ? null : this.tableHeader.getResizingColumn();
    }

    @Override
    public void setFillsViewportHeight(boolean bl) {
        if (bl == this.getFillsViewportHeight()) {
            return;
        }
        super.setFillsViewportHeight(bl);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (!this.isCellEditable(n, n2)) {
            return;
        }
        super.setValueAt(object, n, n2);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        TableColumnExt tableColumnExt;
        if (!this.isEditable()) {
            return false;
        }
        boolean bl = super.isCellEditable(n, n2);
        if (bl && (tableColumnExt = this.getColumnExt(n2)) != null) {
            bl = tableColumnExt.isEditable();
        }
        return bl;
    }

    @Override
    public boolean getAutoCreateColumnsFromModel() {
        return super.getAutoCreateColumnsFromModel();
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        super.tableChanged(tableModelEvent);
        if (this.isStructureChanged(tableModelEvent) && this.getAutoCreateColumnsFromModel()) {
            this.initializeColumnWidths();
            this.resetCalculatedScrollableSize(true);
        }
        if (this.isStructureChanged(tableModelEvent)) {
            this.updateStringValueRegistryColumnClasses();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setModel(TableModel tableModel) {
        boolean bl = this.getAutoCreateRowSorter();
        try {
            this.autoCreateRowSorter = false;
            this.ignoreAddColumn = true;
            super.setModel(tableModel);
        }
        finally {
            this.autoCreateRowSorter = bl;
            this.ignoreAddColumn = false;
        }
        if (this.getAutoCreateRowSorter()) {
            this.setRowSorter(this.createDefaultRowSorter());
        }
    }

    @Override
    public void setColumnModel(TableColumnModel tableColumnModel) {
        super.setColumnModel(tableColumnModel);
        this.configureSorterProperties();
        this.initPerColumnStringValues();
    }

    @Override
    public void setAutoCreateRowSorter(boolean bl) {
        if (this.getAutoCreateRowSorter() == bl) {
            return;
        }
        boolean bl2 = this.getAutoCreateRowSorter();
        this.autoCreateRowSorter = bl;
        if (bl) {
            this.setRowSorter(this.createDefaultRowSorter());
        }
        this.firePropertyChange("autoCreateRowSorter", bl2, this.getAutoCreateRowSorter());
    }

    @Override
    public boolean getAutoCreateRowSorter() {
        return this.autoCreateRowSorter;
    }

    @Override
    public void setRowSorter(RowSorter<? extends TableModel> rowSorter) {
        super.setRowSorter(rowSorter);
        this.configureSorterProperties();
    }

    protected void configureSorterProperties() {
        if (this.ignoreAddColumn || this.getSortController() == null) {
            return;
        }
        this.getSortController().setStringValueProvider(this.getStringValueRegistry());
        this.getSortController().setSortable(this.sortable);
        this.getSortController().setSortsOnUpdates(this.sortsOnUpdates);
        List<TableColumn> list = this.getColumns(true);
        for (TableColumn tableColumn : list) {
            int n = tableColumn.getModelIndex();
            this.getSortController().setSortable(n, tableColumn instanceof TableColumnExt ? ((TableColumnExt)tableColumn).isSortable() : true);
            this.getSortController().setComparator(n, tableColumn instanceof TableColumnExt ? ((TableColumnExt)tableColumn).getComparator() : null);
        }
    }

    protected RowSorter<? extends TableModel> createDefaultRowSorter() {
        return new TableSortController<TableModel>(this.getModel());
    }

    protected boolean isDataChanged(TableModelEvent tableModelEvent) {
        if (tableModelEvent == null) {
            return false;
        }
        return tableModelEvent.getType() == 0 && tableModelEvent.getFirstRow() == 0 && tableModelEvent.getLastRow() == Integer.MAX_VALUE;
    }

    protected boolean isUpdate(TableModelEvent tableModelEvent) {
        if (this.isStructureChanged(tableModelEvent)) {
            return false;
        }
        return tableModelEvent.getType() == 0 && tableModelEvent.getLastRow() < Integer.MAX_VALUE;
    }

    protected boolean isStructureChanged(TableModelEvent tableModelEvent) {
        return tableModelEvent == null || tableModelEvent.getFirstRow() == -1;
    }

    public void setSortable(boolean bl) {
        boolean bl2 = this.isSortable();
        this.sortable = bl;
        if (this.getSortController() != null) {
            this.getSortController().setSortable(bl);
        }
        this.firePropertyChange("sortable", bl2, this.isSortable());
    }

    public boolean isSortable() {
        return this.getSortController() != null ? this.getSortController().isSortable() : this.sortable;
    }

    public void setSortsOnUpdates(boolean bl) {
        boolean bl2 = this.getSortsOnUpdates();
        this.sortsOnUpdates = bl;
        if (this.getSortController() != null) {
            this.getSortController().setSortsOnUpdates(bl);
        }
        this.firePropertyChange("sortsOnUpdates", bl2, this.getSortsOnUpdates());
    }

    public boolean getSortsOnUpdates() {
        return this.getSortController() != null ? this.getSortController().getSortsOnUpdates() : this.sortsOnUpdates;
    }

    public void resetSortOrder() {
        if (this.getSortController() == null) {
            return;
        }
        this.getSortController().resetSortOrders();
        if (this.getTableHeader() != null) {
            this.getTableHeader().repaint();
        }
    }

    public void toggleSortOrder(int n) {
        if (this.getSortController() == null) {
            return;
        }
        this.getSortController().toggleSortOrder(this.convertColumnIndexToModel(n));
    }

    public void setSortOrder(int n, SortOrder sortOrder) {
        if (this.getSortController() == null) {
            return;
        }
        this.getSortController().setSortOrder(this.convertColumnIndexToModel(n), sortOrder);
    }

    public SortOrder getSortOrder(int n) {
        if (this.getSortController() == null) {
            return SortOrder.UNSORTED;
        }
        return this.getSortController().getSortOrder(this.convertColumnIndexToModel(n));
    }

    public void toggleSortOrder(Object object) {
        if (this.getSortController() == null) {
            return;
        }
        TableColumn tableColumn = this.getColumnByIdentifier(object);
        if (tableColumn == null) {
            return;
        }
        this.getSortController().toggleSortOrder(tableColumn.getModelIndex());
    }

    public void setSortOrder(Object object, SortOrder sortOrder) {
        if (this.getSortController() == null) {
            return;
        }
        TableColumn tableColumn = this.getColumnByIdentifier(object);
        if (tableColumn == null) {
            return;
        }
        this.getSortController().setSortOrder(tableColumn.getModelIndex(), sortOrder);
    }

    public SortOrder getSortOrder(Object object) {
        if (this.getSortController() == null) {
            return SortOrder.UNSORTED;
        }
        TableColumn tableColumn = this.getColumnByIdentifier(object);
        if (tableColumn == null) {
            return SortOrder.UNSORTED;
        }
        int n = tableColumn.getModelIndex();
        return this.getSortController().getSortOrder(n);
    }

    private TableColumn getColumnByIdentifier(Object object) {
        TableColumn tableColumn;
        try {
            tableColumn = this.getColumn(object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            tableColumn = this.getColumnExt(object);
        }
        return tableColumn;
    }

    protected boolean isSortable(int n) {
        if (this.getSortController() != null) {
            return this.getSortController().isSortable(this.convertColumnIndexToModel(n));
        }
        boolean bl = this.isSortable();
        TableColumnExt tableColumnExt = this.getColumnExt(n);
        if (tableColumnExt != null) {
            bl = bl && tableColumnExt.isSortable();
        }
        return bl;
    }

    protected boolean isSortable(Object object) {
        if (this.getSortController() != null) {
            TableColumn tableColumn = null;
            tableColumn = this.getColumnByIdentifier(object);
            if (tableColumn != null) {
                return this.getSortController().isSortable(tableColumn.getModelIndex());
            }
            return this.getSortController().isSortable();
        }
        boolean bl = this.isSortable();
        TableColumnExt tableColumnExt = this.getColumnExt(object);
        if (tableColumnExt != null) {
            bl = bl && tableColumnExt.isSortable();
        }
        return bl;
    }

    protected SortController getSortController() {
        if (this.getRowSorter() instanceof SortController) {
            return (SortController)((Object)this.getRowSorter());
        }
        return null;
    }

    public TableColumn getSortedColumn() {
        RowSorter.SortKey sortKey;
        RowSorter<? extends TableModel> rowSorter = this.getRowSorter();
        if (rowSorter != null && (sortKey = SortUtils.getFirstSortingKey(rowSorter.getSortKeys())) != null) {
            int n = sortKey.getColumn();
            List<TableColumn> list = this.getColumns(true);
            for (TableColumn tableColumn : list) {
                if (tableColumn.getModelIndex() != n) continue;
                return tableColumn;
            }
        }
        return null;
    }

    @Override
    public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
        super.columnAdded(tableColumnModelEvent);
        TableColumn tableColumn = this.getColumn(tableColumnModelEvent.getToIndex());
        this.updateStringValueForColumn(tableColumn, tableColumn.getCellRenderer());
        if (this.ignoreAddColumn) {
            return;
        }
        this.updateSortableAfterColumnChanged(tableColumn, tableColumn instanceof TableColumnExt ? ((TableColumnExt)tableColumn).isSortable() : true);
        this.updateComparatorAfterColumnChanged(tableColumn, tableColumn instanceof TableColumnExt ? ((TableColumnExt)tableColumn).getComparator() : null);
    }

    public TableColumn getColumn(int n) {
        return this.getColumnModel().getColumn(n);
    }

    public List<TableColumn> getColumns() {
        return Collections.list(this.getColumnModel().getColumns());
    }

    public int getColumnMargin() {
        return this.getColumnModel().getColumnMargin();
    }

    public void setColumnMargin(int n) {
        this.getColumnModel().setColumnMargin(n);
    }

    public int getColumnCount(boolean bl) {
        if (this.getColumnModel() instanceof TableColumnModelExt) {
            return ((TableColumnModelExt)this.getColumnModel()).getColumnCount(bl);
        }
        return this.getColumnCount();
    }

    public List<TableColumn> getColumns(boolean bl) {
        if (this.getColumnModel() instanceof TableColumnModelExt) {
            return ((TableColumnModelExt)this.getColumnModel()).getColumns(bl);
        }
        return this.getColumns();
    }

    public TableColumnExt getColumnExt(Object object) {
        if (this.getColumnModel() instanceof TableColumnModelExt) {
            return ((TableColumnModelExt)this.getColumnModel()).getColumnExt(object);
        }
        try {
            TableColumn tableColumn = this.getColumn(object);
            if (tableColumn instanceof TableColumnExt) {
                return (TableColumnExt)tableColumn;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public TableColumnExt getColumnExt(int n) {
        TableColumn tableColumn = this.getColumn(n);
        if (tableColumn instanceof TableColumnExt) {
            return (TableColumnExt)tableColumn;
        }
        return null;
    }

    public void setColumnSequence(Object[] objectArray) {
        List<TableColumn> list = this.getColumns(true);
        HashMap<Object, TableColumn> hashMap = new HashMap<Object, TableColumn>();
        for (TableColumn tableColumn : list) {
            hashMap.put(tableColumn.getIdentifier(), tableColumn);
            this.getColumnModel().removeColumn(tableColumn);
        }
        for (int i = 0; i < objectArray.length; ++i) {
            TableColumn tableColumn;
            tableColumn = (TableColumn)hashMap.get(objectArray[i]);
            if (tableColumn == null) continue;
            this.getColumnModel().addColumn(tableColumn);
            list.remove(tableColumn);
        }
        for (TableColumn tableColumn : list) {
            this.getColumnModel().addColumn(tableColumn);
        }
    }

    @Override
    public void columnPropertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("editable")) {
            this.updateEditingAfterColumnChanged((TableColumn)propertyChangeEvent.getSource(), (Boolean)propertyChangeEvent.getNewValue());
        } else if (propertyChangeEvent.getPropertyName().equals("sortable")) {
            this.updateSortableAfterColumnChanged((TableColumn)propertyChangeEvent.getSource(), (Boolean)propertyChangeEvent.getNewValue());
        } else if (propertyChangeEvent.getPropertyName().equals("comparator")) {
            this.updateComparatorAfterColumnChanged((TableColumn)propertyChangeEvent.getSource(), (Comparator)propertyChangeEvent.getNewValue());
        } else if (propertyChangeEvent.getPropertyName().equals("cellRenderer")) {
            this.updateStringValueForColumn((TableColumn)propertyChangeEvent.getSource(), (TableCellRenderer)propertyChangeEvent.getNewValue());
        } else if (propertyChangeEvent.getPropertyName().startsWith("highlighter")) {
            if (propertyChangeEvent.getSource() instanceof TableColumnExt && this.getRowCount() > 0) {
                TableColumnExt tableColumnExt = (TableColumnExt)propertyChangeEvent.getSource();
                Rectangle rectangle = this.getCellRect(0, this.convertColumnIndexToView(tableColumnExt.getModelIndex()), true);
                rectangle.height = this.getHeight();
                this.repaint(rectangle);
            } else {
                this.repaint();
            }
        }
    }

    private void updateEditingAfterColumnChanged(TableColumn tableColumn, boolean bl) {
        if (!this.isEditing()) {
            return;
        }
        int n = this.convertColumnIndexToView(tableColumn.getModelIndex());
        if (n < 0 || n != this.getEditingColumn()) {
            return;
        }
        this.getCellEditor().cancelCellEditing();
    }

    private void updateSortableAfterColumnChanged(TableColumn tableColumn, boolean bl) {
        if (this.getSortController() == null) {
            return;
        }
        this.getSortController().setSortable(tableColumn.getModelIndex(), bl);
    }

    private void updateComparatorAfterColumnChanged(TableColumn tableColumn, Comparator<?> comparator) {
        if (this.getSortController() == null) {
            return;
        }
        this.getSortController().setComparator(tableColumn.getModelIndex(), comparator);
    }

    @Override
    public final void createDefaultColumnsFromModel() {
        if (this.getModel() == null) {
            return;
        }
        this.removeColumns();
        this.createAndAddColumns();
    }

    private void createAndAddColumns() {
        for (int i = 0; i < this.getModel().getColumnCount(); ++i) {
            TableColumnExt tableColumnExt = this.getColumnFactory().createAndConfigureTableColumn(this.getModel(), i);
            if (tableColumnExt == null) continue;
            this.getColumnModel().addColumn(tableColumnExt);
        }
    }

    private void removeColumns() {
        List<TableColumn> list = this.getColumns(true);
        Iterator<TableColumn> iterator = list.iterator();
        while (iterator.hasNext()) {
            this.getColumnModel().removeColumn(iterator.next());
        }
    }

    public ColumnFactory getColumnFactory() {
        if (this.columnFactory == null) {
            return ColumnFactory.getInstance();
        }
        return this.columnFactory;
    }

    public void setColumnFactory(ColumnFactory columnFactory) {
        ColumnFactory columnFactory2 = this.getColumnFactory();
        this.columnFactory = columnFactory;
        this.firePropertyChange("columnFactory", columnFactory2, this.getColumnFactory());
    }

    public void packTable(int n) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.packColumn(i, n, -1);
        }
    }

    public void packColumn(int n, int n2) {
        this.packColumn(n, n2, -1);
    }

    public void packColumn(int n, int n2, int n3) {
        this.getColumnFactory().packColumn(this, this.getColumnExt(n), n2, n3);
    }

    public int getVisibleRowCount() {
        return this.visibleRowCount;
    }

    public void setVisibleRowCount(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("visible row count must not be negative " + n);
        }
        if (this.getVisibleRowCount() == n) {
            return;
        }
        int n2 = this.getVisibleRowCount();
        this.visibleRowCount = n;
        this.resetCalculatedScrollableSize(false);
        this.firePropertyChange("visibleRowCount", n2, this.getVisibleRowCount());
    }

    public int getVisibleColumnCount() {
        return this.visibleColumnCount;
    }

    public void setVisibleColumnCount(int n) {
        if (this.getVisibleColumnCount() == n) {
            return;
        }
        int n2 = this.getVisibleColumnCount();
        this.visibleColumnCount = n;
        this.resetCalculatedScrollableSize(true);
        this.firePropertyChange("visibleColumnCount", n2, this.getVisibleColumnCount());
    }

    private void resetCalculatedScrollableSize(boolean bl) {
        if (this.calculatedPrefScrollableViewportSize != null) {
            if (bl) {
                this.calculatedPrefScrollableViewportSize.width = -1;
            } else {
                this.calculatedPrefScrollableViewportSize.height = -1;
            }
        }
    }

    @Override
    public void setPreferredScrollableViewportSize(Dimension dimension) {
        super.setPreferredScrollableViewportSize(dimension);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        Dimension dimension = super.getPreferredScrollableViewportSize();
        if (dimension != null) {
            return new Dimension(dimension);
        }
        if (this.calculatedPrefScrollableViewportSize == null) {
            this.calculatedPrefScrollableViewportSize = new Dimension();
        }
        if (this.calculatedPrefScrollableViewportSize.width <= 0) {
            this.calculatedPrefScrollableViewportSize.width = this.getColumnFactory().getPreferredScrollableViewportWidth(this);
        }
        if (this.calculatedPrefScrollableViewportSize.height <= 0) {
            this.calculatedPrefScrollableViewportSize.height = this.getVisibleRowCount() * this.getRowHeight();
        }
        return new Dimension(this.calculatedPrefScrollableViewportSize);
    }

    protected void initializeColumnWidths() {
        for (TableColumn tableColumn : this.getColumns(true)) {
            this.initializeColumnPreferredWidth(tableColumn);
        }
    }

    protected void initializeColumnPreferredWidth(TableColumn tableColumn) {
        if (tableColumn instanceof TableColumnExt) {
            this.getColumnFactory().configureColumnWidths(this, (TableColumnExt)tableColumn);
        }
    }

    public void scrollRowToVisible(int n) {
        Rectangle rectangle = this.getCellRect(n, 0, false);
        Rectangle rectangle2 = this.getVisibleRect();
        rectangle.x = rectangle2.x;
        rectangle.width = rectangle2.width;
        this.scrollRectToVisible(rectangle);
    }

    public void scrollColumnToVisible(int n) {
        Rectangle rectangle = this.getCellRect(0, n, false);
        Rectangle rectangle2 = this.getVisibleRect();
        rectangle.y = rectangle2.y;
        rectangle.height = rectangle2.height;
        this.scrollRectToVisible(rectangle);
    }

    public void scrollCellToVisible(int n, int n2) {
        Rectangle rectangle = this.getCellRect(n, n2, false);
        this.scrollRectToVisible(rectangle);
    }

    public int getSelectionMode() {
        return this.getSelectionModel().getSelectionMode();
    }

    protected void doFind() {
        SearchFactory.getInstance().showFindInput(this, this.getSearchable());
    }

    public Searchable getSearchable() {
        if (this.searchable == null) {
            this.searchable = new TableSearchable(this);
        }
        return this.searchable;
    }

    public void setSearchable(Searchable searchable) {
        this.searchable = searchable;
    }

    protected ComponentAdapter getComponentAdapter() {
        if (this.dataAdapter == null) {
            this.dataAdapter = new TableAdapter(this);
        }
        return this.dataAdapter;
    }

    protected ComponentAdapter getComponentAdapter(int n, int n2) {
        ComponentAdapter componentAdapter = this.getComponentAdapter();
        componentAdapter.row = n;
        componentAdapter.column = n2;
        return componentAdapter;
    }

    public void setHighlighters(Highlighter ... highlighterArray) {
        Highlighter[] highlighterArray2 = this.getHighlighters();
        this.getCompoundHighlighter().setHighlighters(highlighterArray);
        this.firePropertyChange("highlighters", highlighterArray2, this.getHighlighters());
    }

    public Highlighter[] getHighlighters() {
        return this.getCompoundHighlighter().getHighlighters();
    }

    public void addHighlighter(Highlighter highlighter) {
        Highlighter[] highlighterArray = this.getHighlighters();
        this.getCompoundHighlighter().addHighlighter(highlighter);
        this.firePropertyChange("highlighters", highlighterArray, this.getHighlighters());
    }

    public void removeHighlighter(Highlighter highlighter) {
        Highlighter[] highlighterArray = this.getHighlighters();
        this.getCompoundHighlighter().removeHighlighter(highlighter);
        this.firePropertyChange("highlighters", highlighterArray, this.getHighlighters());
    }

    protected CompoundHighlighter getCompoundHighlighter() {
        if (this.compoundHighlighter == null) {
            this.compoundHighlighter = new CompoundHighlighter(new Highlighter[0]);
            this.compoundHighlighter.addChangeListener(this.getHighlighterChangeListener());
        }
        return this.compoundHighlighter;
    }

    protected ChangeListener getHighlighterChangeListener() {
        if (this.highlighterChangeListener == null) {
            this.highlighterChangeListener = this.createHighlighterChangeListener();
        }
        return this.highlighterChangeListener;
    }

    protected ChangeListener createHighlighterChangeListener() {
        return new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JXTable.this.repaint();
            }
        };
    }

    protected StringValueRegistry getStringValueRegistry() {
        if (this.stringValueRegistry == null) {
            this.stringValueRegistry = this.createDefaultStringValueRegistry();
        }
        return this.stringValueRegistry;
    }

    protected StringValueRegistry createDefaultStringValueRegistry() {
        return new StringValueRegistry();
    }

    private void updateStringValueRegistryColumnClasses() {
        this.getStringValueRegistry().setColumnClasses(null);
        for (int i = 0; i < this.getModel().getColumnCount(); ++i) {
            this.getStringValueRegistry().setColumnClass(this.getModel().getColumnClass(i), i);
        }
    }

    private void updateStringValueForColumn(TableColumn tableColumn, TableCellRenderer tableCellRenderer) {
        this.getStringValueRegistry().setStringValue(tableCellRenderer instanceof StringValue ? (StringValue)((Object)tableCellRenderer) : null, tableColumn.getModelIndex());
    }

    private void initDefaultStringValues() {
        for (Object k : this.defaultRenderersByColumnClass.keySet()) {
            Object v = this.defaultRenderersByColumnClass.get(k);
            if (!(v instanceof StringValue)) continue;
            this.getStringValueRegistry().setStringValue((StringValue)v, (Class)k);
        }
    }

    private void initPerColumnStringValues() {
        this.getStringValueRegistry().clearColumnStringValues();
        for (TableColumn tableColumn : this.getColumns(true)) {
            this.updateStringValueForColumn(tableColumn, tableColumn.getCellRenderer());
        }
    }

    @Override
    public void setDefaultRenderer(Class<?> clazz, TableCellRenderer tableCellRenderer) {
        super.setDefaultRenderer(clazz, tableCellRenderer);
        this.getStringValueRegistry().setStringValue(tableCellRenderer instanceof StringValue ? (StringValue)((Object)tableCellRenderer) : null, clazz);
    }

    public String getStringAt(int n, int n2) {
        StringValue stringValue = this.getStringValueRegistry().getStringValue(this.convertRowIndexToModel(n), this.convertColumnIndexToModel(n2));
        return stringValue.getString(this.getValueAt(n, n2));
    }

    @Override
    public TableCellRenderer getCellRenderer(int n, int n2) {
        TableCellRenderer tableCellRenderer = super.getCellRenderer(n, n2);
        if (tableCellRenderer == null) {
            tableCellRenderer = this.getDefaultRenderer(Object.class);
        }
        return tableCellRenderer;
    }

    @Override
    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
        TableColumnExt tableColumnExt;
        Component component = super.prepareRenderer(tableCellRenderer, n, n2);
        this.adjustComponentOrientation(component);
        this.resetDefaultTableCellRendererColors(component, n, n2);
        ComponentAdapter componentAdapter = this.getComponentAdapter(n, n2);
        if (this.compoundHighlighter != null) {
            component = this.compoundHighlighter.highlight(component, componentAdapter);
        }
        if ((tableColumnExt = this.getColumnExt(n2)) != null) {
            for (Highlighter highlighter : tableColumnExt.getHighlighters()) {
                component = highlighter.highlight(component, componentAdapter);
            }
        }
        return component;
    }

    protected void resetDefaultTableCellRendererColors(Component component, int n, int n2) {
        if (!Boolean.TRUE.equals(this.getClientProperty(USE_DTCR_COLORMEMORY_HACK))) {
            return;
        }
        ComponentAdapter componentAdapter = this.getComponentAdapter(n, n2);
        if (this.resetDefaultTableCellRendererHighlighter == null) {
            this.resetDefaultTableCellRendererHighlighter = new ResetDTCRColorHighlighter();
        }
        this.resetDefaultTableCellRendererHighlighter.highlight(component, componentAdapter);
    }

    @Override
    public Component prepareEditor(TableCellEditor tableCellEditor, int n, int n2) {
        Component component = super.prepareEditor(tableCellEditor, n, n2);
        if (component != null) {
            this.adjustComponentOrientation(component);
        }
        return component;
    }

    protected void adjustComponentOrientation(Component component) {
        if (component.getComponentOrientation().equals(this.getComponentOrientation())) {
            return;
        }
        component.applyComponentOrientation(this.getComponentOrientation());
    }

    public TableCellRenderer getNewDefaultRenderer(Class<?> clazz) {
        TableCellRenderer tableCellRenderer = this.getDefaultRenderer(clazz);
        if (tableCellRenderer != null) {
            try {
                return (TableCellRenderer)tableCellRenderer.getClass().newInstance();
            }
            catch (Exception exception) {
                LOG.fine("could not create renderer for " + clazz);
            }
        }
        return null;
    }

    @Override
    protected void createDefaultRenderers() {
        super.createDefaultRenderers();
        Object[] objectArray = new Object[]{1, 0, 2, 0, 3, 0, 4, 0, 5, 0, 6, 0, 7, 0, 8, 0, 9, 0, 10, 0};
        this.defaultRenderersByColumnClass = new UIDefaults(objectArray);
        this.defaultRenderersByColumnClass.clear();
        this.setDefaultRenderer(Object.class, new DefaultTableRenderer());
        this.setDefaultRenderer(Number.class, new DefaultTableRenderer((StringValue)StringValues.NUMBER_TO_STRING, 4));
        this.setDefaultRenderer(Date.class, new DefaultTableRenderer(StringValues.DATE_TO_STRING));
        DefaultTableRenderer defaultTableRenderer = new DefaultTableRenderer((StringValue)new MappedValue(StringValues.EMPTY, IconValues.ICON), 0);
        this.setDefaultRenderer(Icon.class, defaultTableRenderer);
        this.setDefaultRenderer(ImageIcon.class, defaultTableRenderer);
        this.setDefaultRenderer(Boolean.class, new DefaultTableRenderer(new CheckBoxProvider()));
    }

    private void setLazyValue(Hashtable hashtable, Class clazz, String string) {
        hashtable.put(clazz, new UIDefaults.ProxyLazyValue(string));
    }

    private void setLazyEditor(Class<?> clazz, String string) {
        this.setLazyValue(this.defaultEditorsByColumnClass, clazz, string);
    }

    @Override
    protected void createDefaultEditors() {
        Object[] objectArray = new Object[]{1, 0, 2, 0, 3, 0, 4, 0, 5, 0, 6, 0, 7, 0, 8, 0, 9, 0, 10, 0};
        this.defaultEditorsByColumnClass = new UIDefaults(objectArray);
        this.defaultEditorsByColumnClass.clear();
        this.setLazyEditor(Object.class, "org.jdesktop.swingx.JXTable$GenericEditor");
        this.setLazyEditor(Number.class, "org.jdesktop.swingx.table.NumberEditorExt");
        this.setLazyEditor(Boolean.class, "org.jdesktop.swingx.JXTable$BooleanEditor");
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean bl) {
        boolean bl2 = this.isEditable();
        this.editable = bl;
        this.firePropertyChange("editable", bl2, this.isEditable());
    }

    public boolean isTerminateEditOnFocusLost() {
        return Boolean.TRUE.equals(this.getClientProperty("terminateEditOnFocusLost"));
    }

    public void setTerminateEditOnFocusLost(boolean bl) {
        this.putClientProperty("terminateEditOnFocusLost", bl);
    }

    public boolean isAutoStartEditOnKeyStroke() {
        return !Boolean.FALSE.equals(this.getClientProperty("JTable.autoStartsEdit"));
    }

    public void setAutoStartEditOnKeyStroke(boolean bl) {
        boolean bl2 = this.isAutoStartEditOnKeyStroke();
        this.putClientProperty("JTable.autoStartsEdit", bl);
        this.firePropertyChange("autoStartEditOnKeyStroke", bl2, this.isAutoStartEditOnKeyStroke());
    }

    @Override
    public boolean editCellAt(int n, int n2, EventObject eventObject) {
        boolean bl = super.editCellAt(n, n2, eventObject);
        if (bl) {
            this.hackEditorRemover();
        }
        return bl;
    }

    @Override
    public void removeEditor() {
        boolean bl = this.isFocusOwnerDescending();
        super.removeEditor();
        if (bl) {
            this.requestFocusInWindow();
        }
    }

    private boolean isFocusOwnerDescending() {
        if (!this.isEditing()) {
            return false;
        }
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (component == null) {
            return false;
        }
        if (SwingXUtilities.isDescendingFrom(component, this)) {
            return true;
        }
        Component component2 = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
        return SwingXUtilities.isDescendingFrom(component2, this);
    }

    private void hackEditorRemover() {
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        PropertyChangeListener[] propertyChangeListenerArray = keyboardFocusManager.getPropertyChangeListeners("permanentFocusOwner");
        for (int i = propertyChangeListenerArray.length - 1; i >= 0; --i) {
            if (!propertyChangeListenerArray[i].getClass().getName().startsWith("javax.swing.JTable")) continue;
            keyboardFocusManager.removePropertyChangeListener("permanentFocusOwner", propertyChangeListenerArray[i]);
            break;
        }
        if (this.editorRemover == null) {
            this.editorRemover = new CellEditorRemover();
        }
    }

    @Override
    public void removeNotify() {
        if (this.editorRemover != null) {
            this.editorRemover.uninstall();
            this.editorRemover = null;
        }
        super.removeNotify();
    }

    @Override
    public boolean isFocusCycleRoot() {
        if (this.isEditingFocusCycleRoot()) {
            return true;
        }
        return super.isFocusCycleRoot();
    }

    @Override
    public void transferFocus() {
        if (this.isEditingFocusCycleRoot() && !this.getCellEditor().stopCellEditing()) {
            return;
        }
        super.transferFocus();
    }

    @Override
    public void transferFocusBackward() {
        if (this.isEditingFocusCycleRoot() && !this.getCellEditor().stopCellEditing()) {
            return;
        }
        super.transferFocusBackward();
    }

    private boolean isEditingFocusCycleRoot() {
        return this.isEditing() && this.isTerminateEditOnFocusLost();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.updateColumnControlUI();
        Object object = this.defaultEditorsByColumnClass.elements();
        while (object.hasMoreElements()) {
            this.updateEditorUI(object.nextElement());
        }
        object = this.defaultRenderersByColumnClass.elements();
        while (object.hasMoreElements()) {
            this.updateRendererUI(object.nextElement());
        }
        for (TableColumn tableColumn : this.getColumns(true)) {
            this.updateColumnUI(tableColumn);
        }
        this.updateRowHeightUI(true);
        this.updateHighlighterUI();
    }

    protected void updateColumnControlUI() {
        if (this.columnControlButton != null && this.columnControlButton.getParent() == null) {
            SwingUtilities.updateComponentTreeUI(this.columnControlButton);
        }
    }

    private void updateEditorUI(Object object) {
        if (!(object instanceof TableCellEditor)) {
            return;
        }
        if (object instanceof JComponent || object instanceof DefaultCellEditor) {
            return;
        }
        try {
            Component component = ((TableCellEditor)object).getTableCellEditorComponent(this, null, false, -1, -1);
            if (component != null) {
                SwingUtilities.updateComponentTreeUI(component);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateRendererUI(Object object) {
        if (!(object instanceof TableCellRenderer)) {
            return;
        }
        if (object instanceof JComponent) {
            return;
        }
        Component component = null;
        if (object instanceof AbstractRenderer) {
            component = (Component)((AbstractRenderer)object).getComponentProvider().getRendererComponent(null);
        } else {
            try {
                component = ((TableCellRenderer)object).getTableCellRendererComponent(this, null, false, false, -1, -1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (component != null) {
            SwingUtilities.updateComponentTreeUI(component);
        }
    }

    protected void updateColumnUI(TableColumn tableColumn) {
        if (tableColumn instanceof UIDependent) {
            ((UIDependent)((Object)tableColumn)).updateUI();
        } else {
            this.updateEditorUI(tableColumn.getCellEditor());
            this.updateRendererUI(tableColumn.getCellRenderer());
            this.updateRendererUI(tableColumn.getHeaderRenderer());
        }
    }

    protected void updateHighlighterUI() {
        if (this.compoundHighlighter == null) {
            return;
        }
        this.compoundHighlighter.updateUI();
    }

    protected void updateRowHeightUI(boolean bl) {
        if (bl && this.isXTableRowHeightSet) {
            return;
        }
        int n = UIManager.getInt("JXTable.rowHeight");
        if (n > 0) {
            this.setRowHeight(n);
        } else {
            int n2 = this.getFontMetrics(this.getFont()).getHeight() + 2;
            int n3 = 18;
            this.setRowHeight(Math.max(n2, n3));
        }
        this.isXTableRowHeightSet = false;
    }

    public void setShowGrid(boolean bl, boolean bl2) {
        int n = bl ? 1 : 0;
        this.setRowMargin(n);
        this.setShowHorizontalLines(bl);
        int n2 = bl2 ? 1 : 0;
        this.setColumnMargin(n2);
        this.setShowVerticalLines(bl2);
    }

    @Override
    public void setShowGrid(boolean bl) {
        super.setShowGrid(bl);
    }

    @Override
    public void setRowHeight(int n) {
        super.setRowHeight(n);
        if (n > 0) {
            this.isXTableRowHeightSet = true;
        }
    }

    @Deprecated
    public void setRowHeightEnabled(boolean bl) {
    }

    @Deprecated
    public boolean isRowHeightEnabled() {
        return true;
    }

    protected void adminSetRowHeight(int n) {
        boolean bl = this.isXTableRowHeightSet;
        this.setRowHeight(n);
        this.isXTableRowHeightSet = bl;
    }

    @Override
    public int rowAtPoint(Point point) {
        if (point.y < 0) {
            return -1;
        }
        return super.rowAtPoint(point);
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        return new JXTableHeader(this.columnModel);
    }

    @Override
    protected TableColumnModel createDefaultColumnModel() {
        return new DefaultTableColumnModelExt();
    }

    @Override
    public void setSelectionBackground(Color color) {
        Color color2 = this.getSelectionBackground();
        this.selectionBackground = color;
        this.firePropertyChange("selectionBackground", color2, this.getSelectionBackground());
        this.repaint();
    }

    @Override
    public void setSelectionForeground(Color color) {
        Color color2 = this.getSelectionForeground();
        this.selectionForeground = color;
        this.firePropertyChange("selectionForeground", color2, this.getSelectionForeground());
        this.repaint();
    }

    @Override
    public void setGridColor(Color color) {
        Color color2 = this.getGridColor();
        this.gridColor = color;
        this.firePropertyChange("gridColor", color2, this.getGridColor());
        this.repaint();
    }

    static {
        LookAndFeelAddons.getAddon();
    }

    class CellEditorRemover
    implements PropertyChangeListener {
        KeyboardFocusManager focusManager;

        public CellEditorRemover() {
            this.install();
        }

        private void install() {
            this.focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            this.focusManager.addPropertyChangeListener("permanentFocusOwner", this);
            this.focusManager.addPropertyChangeListener("managingFocus", this);
        }

        public void uninstall() {
            this.focusManager.removePropertyChangeListener("permanentFocusOwner", this);
            this.focusManager.removePropertyChangeListener("managingFocus", this);
            this.focusManager = null;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent == null) {
                return;
            }
            if ("permanentFocusOwner".equals(propertyChangeEvent.getPropertyName())) {
                this.permanentFocusOwnerChange();
            } else if ("managingFocus".equals(propertyChangeEvent.getPropertyName())) {
                // empty if block
            }
        }

        private void permanentFocusOwnerChange() {
            if (!JXTable.this.isEditing() || !JXTable.this.isTerminateEditOnFocusLost()) {
                return;
            }
            Component component = this.focusManager.getPermanentFocusOwner();
            while (component != null) {
                if (component instanceof JPopupMenu) {
                    component = ((JPopupMenu)component).getInvoker();
                    continue;
                }
                if (component == JXTable.this) {
                    return;
                }
                if (!(component instanceof JPopupMenu) && (component instanceof Window || component instanceof Applet && component.getParent() == null)) {
                    if (component != SwingUtilities.getRoot(JXTable.this) || JXTable.this.getCellEditor().stopCellEditing()) break;
                    JXTable.this.getCellEditor().cancelCellEditing();
                    break;
                }
                component = component.getParent();
            }
        }
    }

    public static class BooleanEditor
    extends DefaultCellEditor {
        public BooleanEditor() {
            super(new JCheckBox());
            JCheckBox jCheckBox = (JCheckBox)this.getComponent();
            jCheckBox.setHorizontalAlignment(0);
        }
    }

    public static class NumberEditor
    extends GenericEditor {
        public NumberEditor() {
            ((JTextField)this.getComponent()).setHorizontalAlignment(4);
        }
    }

    public static class GenericEditor
    extends DefaultCellEditor {
        Class<?>[] argTypes = new Class[]{String.class};
        Constructor<?> constructor;
        Object value;

        public GenericEditor() {
            this(new JTextField());
        }

        public GenericEditor(JTextField jTextField) {
            super(jTextField);
            this.getComponent().setName("Table.editor");
        }

        public boolean stopCellEditing() {
            String string = (String)super.getCellEditorValue();
            if ("".equals(string)) {
                if (this.constructor.getDeclaringClass() == String.class) {
                    this.value = string;
                }
                super.stopCellEditing();
            }
            try {
                this.value = this.constructor.newInstance(string);
            }
            catch (Exception exception) {
                ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.red));
                return false;
            }
            return super.stopCellEditing();
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.value = null;
            ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.black));
            try {
                Class<Object> clazz = jTable.getColumnClass(n2);
                if (clazz == Object.class) {
                    clazz = String.class;
                }
                this.constructor = clazz.getConstructor(this.argTypes);
            }
            catch (Exception exception) {
                return null;
            }
            return super.getTableCellEditorComponent(jTable, object, bl, n, n2);
        }

        public Object getCellEditorValue() {
            return this.value;
        }
    }

    protected static class TableAdapter
    extends ComponentAdapter {
        private final JXTable table;

        public TableAdapter(JXTable jXTable) {
            super(jXTable);
            this.table = jXTable;
        }

        public JXTable getTable() {
            return this.table;
        }

        public String getColumnName(int n) {
            TableColumn tableColumn = this.getColumnByModelIndex(n);
            return tableColumn == null ? "" : tableColumn.getHeaderValue().toString();
        }

        protected TableColumn getColumnByModelIndex(int n) {
            if (n < 0 || n >= this.getColumnCount()) {
                throw new IllegalArgumentException("invalid column index, must be positive and less than " + this.getColumnCount() + " was: " + n);
            }
            List<TableColumn> list = this.table.getColumns(true);
            for (TableColumn tableColumn : list) {
                if (tableColumn.getModelIndex() != n) continue;
                return tableColumn;
            }
            return null;
        }

        public Object getColumnIdentifierAt(int n) {
            if (n < 0 || n >= this.getColumnCount()) {
                throw new ArrayIndexOutOfBoundsException("invalid column index: " + n);
            }
            TableColumn tableColumn = this.getColumnByModelIndex(n);
            Object object = tableColumn != null ? tableColumn.getIdentifier() : null;
            return object;
        }

        public int getColumnIndex(Object object) {
            TableColumnExt tableColumnExt = this.table.getColumnExt(object);
            return tableColumnExt != null ? tableColumnExt.getModelIndex() : -1;
        }

        public int getColumnCount() {
            return this.table.getModel().getColumnCount();
        }

        public int getRowCount() {
            return this.table.getModel().getRowCount();
        }

        public Object getValueAt(int n, int n2) {
            return this.table.getModel().getValueAt(n, n2);
        }

        public boolean isCellEditable(int n, int n2) {
            return this.table.getModel().isCellEditable(n, n2);
        }

        public boolean isTestable(int n) {
            return this.getColumnByModelIndex(n) != null;
        }

        public Object getFilteredValueAt(int n, int n2) {
            return this.getValueAt(this.table.convertRowIndexToModel(n), n2);
        }

        public Object getValue() {
            return this.table.getValueAt(this.row, this.column);
        }

        public String getFilteredStringAt(int n, int n2) {
            return this.getStringAt(this.table.convertRowIndexToModel(n), n2);
        }

        public String getString() {
            return this.table.getStringAt(this.row, this.column);
        }

        public String getStringAt(int n, int n2) {
            StringValue stringValue = this.table.getStringValueRegistry().getStringValue(n, n2);
            return stringValue.getString(this.getValueAt(n, n2));
        }

        public boolean isEditable() {
            return this.table.isCellEditable(this.row, this.column);
        }

        public boolean isSelected() {
            return this.table.isCellSelected(this.row, this.column);
        }

        public boolean hasFocus() {
            boolean bl = this.table.getSelectionModel().getLeadSelectionIndex() == this.row;
            boolean bl2 = this.table.getColumnModel().getSelectionModel().getLeadSelectionIndex() == this.column;
            return this.table.isFocusOwner() && bl && bl2;
        }

        public int modelToView(int n) {
            return this.table.convertColumnIndexToView(n);
        }

        public int viewToModel(int n) {
            return this.table.convertColumnIndexToModel(n);
        }
    }

    private class Actions
    extends UIAction {
        Actions(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if ("print".equals(this.getName())) {
                try {
                    JXTable.this.print();
                }
                catch (PrinterException printerException) {
                    LOG.log(Level.WARNING, "", printerException);
                }
            } else if ("find".equals(this.getName())) {
                JXTable.this.doFind();
            }
        }
    }
}

