/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.jdesktop.swingx.AbstractPatternPanel;
import org.jdesktop.swingx.decorator.PatternMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JXSearchPanel
extends AbstractPatternPanel {
    public static final String MATCH_RULE_ACTION_COMMAND = "selectMatchRule";
    private JComboBox searchCriteria;
    private List<PatternMatcher> patternMatchers;

    public JXSearchPanel() {
        this.initComponents();
        this.build();
        this.initActions();
        this.bind();
        this.getPatternModel().setIncremental(true);
    }

    public void addPatternMatcher(PatternMatcher patternMatcher) {
        this.getPatternMatchers().add(patternMatcher);
        this.updateFieldName(patternMatcher);
    }

    public void setFieldName(String string) {
        String string2 = this.searchLabel.getText();
        this.searchLabel.setText(string);
        this.firePropertyChange("fieldName", string2, this.searchLabel.getText());
    }

    public String getFieldName() {
        return this.searchLabel.getText();
    }

    public Pattern getPattern() {
        return this.patternModel.getPattern();
    }

    protected void updateFieldName(PatternMatcher patternMatcher) {
        if (this.searchLabel.getText().length() == 0) {
            this.searchLabel.setText("Field");
        }
    }

    @Override
    public void match() {
        Iterator<PatternMatcher> iterator = this.getPatternMatchers().iterator();
        while (iterator.hasNext()) {
            iterator.next().setPattern(this.getPattern());
        }
    }

    public void updateMatchRule() {
        this.getPatternModel().setMatchRule((String)this.searchCriteria.getSelectedItem());
    }

    private List<PatternMatcher> getPatternMatchers() {
        if (this.patternMatchers == null) {
            this.patternMatchers = new ArrayList<PatternMatcher>();
        }
        return this.patternMatchers;
    }

    @Override
    protected void initExecutables() {
        super.initExecutables();
        this.getActionMap().put(MATCH_RULE_ACTION_COMMAND, this.createBoundAction(MATCH_RULE_ACTION_COMMAND, "updateMatchRule"));
    }

    @Override
    protected void bind() {
        super.bind();
        List list = this.getPatternModel().getMatchRules();
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(list.toArray());
        defaultComboBoxModel.setSelectedItem(this.getPatternModel().getMatchRule());
        this.searchCriteria.setModel(defaultComboBoxModel);
        this.searchCriteria.setAction(this.getAction(MATCH_RULE_ACTION_COMMAND));
    }

    private void build() {
        this.add(this.searchLabel);
        this.add(this.searchCriteria);
        this.add(this.searchField);
        this.add(this.matchCheck);
    }

    @Override
    protected void initComponents() {
        super.initComponents();
        this.searchCriteria = new JComboBox();
    }
}

