/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JXRadioGroup<T>
extends JPanel {
    private ButtonGroup buttonGroup;
    private final List<T> values = new ArrayList<T>();
    private ActionSelectionListener actionHandler;
    private List<ActionListener> actionListeners;

    public JXRadioGroup() {
        this.setLayout(new BoxLayout(this, 0));
        this.buttonGroup = new ButtonGroup();
    }

    public JXRadioGroup(T[] TArray) {
        this();
        for (int i = 0; i < TArray.length; ++i) {
            this.add(TArray[i]);
        }
    }

    public static <T> JXRadioGroup<T> create(T[] TArray) {
        return new JXRadioGroup<T>(TArray);
    }

    public void setLayoutAxis(int n) {
        this.setLayout(new BoxLayout(this, n));
    }

    public void setValues(T[] TArray) {
        this.clearAll();
        for (int i = 0; i < TArray.length; ++i) {
            this.add(TArray[i]);
        }
    }

    private void clearAll() {
        this.values.clear();
        this.buttonGroup = new ButtonGroup();
        this.removeAll();
    }

    public void add(T t) {
        if (this.values.contains(t)) {
            throw new IllegalArgumentException("cannot add the same value twice " + t);
        }
        if (t instanceof AbstractButton) {
            this.values.add(t);
            this.addButton((AbstractButton)t);
        } else {
            this.values.add(t);
            this.addButton(new JRadioButton("" + t));
        }
    }

    private void addButton(AbstractButton abstractButton) {
        this.buttonGroup.add(abstractButton);
        super.add(abstractButton);
        if (this.actionHandler == null) {
            this.actionHandler = new ActionSelectionListener();
        }
        abstractButton.addActionListener(this.actionHandler);
        abstractButton.addItemListener(this.actionHandler);
    }

    public AbstractButton getSelectedButton() {
        ButtonModel buttonModel = this.buttonGroup.getSelection();
        AbstractButton[] abstractButtonArray = this.getButtonComponents();
        for (int i = 0; i < abstractButtonArray.length; ++i) {
            AbstractButton abstractButton = abstractButtonArray[i];
            if (abstractButton.getModel() != buttonModel) continue;
            return abstractButton;
        }
        return null;
    }

    private AbstractButton[] getButtonComponents() {
        Component[] componentArray = this.getComponents();
        ArrayList<AbstractButton> arrayList = new ArrayList<AbstractButton>();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof AbstractButton)) continue;
            arrayList.add((AbstractButton)componentArray[i]);
        }
        return arrayList.toArray(new AbstractButton[arrayList.size()]);
    }

    private int getSelectedIndex() {
        ButtonModel buttonModel = this.buttonGroup.getSelection();
        AbstractButton[] abstractButtonArray = this.getButtonComponents();
        for (int i = 0; i < abstractButtonArray.length; ++i) {
            AbstractButton abstractButton = abstractButtonArray[i];
            if (abstractButton.getModel() != buttonModel) continue;
            return i;
        }
        return -1;
    }

    public T getSelectedValue() {
        int n = this.getSelectedIndex();
        return n < 0 || n >= this.values.size() ? null : (T)this.values.get(n);
    }

    public void setSelectedValue(T t) {
        int n = this.values.indexOf(t);
        AbstractButton abstractButton = this.getButtonComponents()[n];
        abstractButton.setSelected(true);
    }

    public AbstractButton getChildButton(int n) {
        return this.getButtonComponents()[n];
    }

    public AbstractButton getChildButton(T t) {
        int n = this.values.indexOf(t);
        return this.getButtonComponents()[n];
    }

    public int getChildButtonCount() {
        return this.getButtonComponents().length;
    }

    public void addActionListener(ActionListener actionListener) {
        if (this.actionListeners == null) {
            this.actionListeners = new ArrayList<ActionListener>();
        }
        this.actionListeners.add(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        if (this.actionListeners != null) {
            this.actionListeners.remove(actionListener);
        }
    }

    public ActionListener[] getActionListeners() {
        if (this.actionListeners != null) {
            return this.actionListeners.toArray(new ActionListener[0]);
        }
        return new ActionListener[0];
    }

    protected void fireActionEvent(ActionEvent actionEvent) {
        if (this.actionListeners != null) {
            for (int i = 0; i < this.actionListeners.size(); ++i) {
                ActionListener actionListener = this.actionListeners.get(i);
                actionListener.actionPerformed(actionEvent);
            }
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        Enumeration<AbstractButton> enumeration = this.buttonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            AbstractButton abstractButton = enumeration.nextElement();
            if (bl && abstractButton.getAction() != null && !abstractButton.getAction().isEnabled()) continue;
            abstractButton.setEnabled(bl);
        }
    }

    private class ActionSelectionListener
    implements ActionListener,
    ItemListener {
        private ActionSelectionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JXRadioGroup.this.fireActionEvent(actionEvent);
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            JXRadioGroup.this.fireActionEvent(null);
        }
    }
}

