/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;
import org.jdesktop.swingx.MultiSplitLayout;
import org.jdesktop.swingx.painter.AbstractPainter;
import org.jdesktop.swingx.painter.Painter;

public class JXMultiSplitPane
extends JPanel {
    private AccessibleContext accessibleContext = null;
    private boolean continuousLayout = true;
    private DividerPainter dividerPainter = new DefaultDividerPainter();
    private Painter backgroundPainter;
    private boolean dragUnderway = false;
    private MultiSplitLayout.Divider dragDivider = null;
    private Rectangle initialDividerBounds = null;
    private boolean oldFloatingDividers = true;
    private int dragOffsetX = 0;
    private int dragOffsetY = 0;
    private int dragMin = -1;
    private int dragMax = -1;

    public JXMultiSplitPane() {
        this(new MultiSplitLayout());
    }

    public JXMultiSplitPane(MultiSplitLayout multiSplitLayout) {
        super(multiSplitLayout);
        InputHandler inputHandler = new InputHandler();
        this.addMouseListener(inputHandler);
        this.addMouseMotionListener(inputHandler);
        this.addKeyListener(inputHandler);
        this.setFocusable(true);
    }

    public final MultiSplitLayout getMultiSplitLayout() {
        return (MultiSplitLayout)this.getLayout();
    }

    public final void setModel(MultiSplitLayout.Node node) {
        this.getMultiSplitLayout().setModel(node);
    }

    public final void setDividerSize(int n) {
        this.getMultiSplitLayout().setDividerSize(n);
    }

    public final int getDividerSize() {
        return this.getMultiSplitLayout().getDividerSize();
    }

    public void setContinuousLayout(boolean bl) {
        boolean bl2 = this.isContinuousLayout();
        this.continuousLayout = bl;
        this.firePropertyChange("continuousLayout", bl2, this.isContinuousLayout());
    }

    public boolean isContinuousLayout() {
        return this.continuousLayout;
    }

    public MultiSplitLayout.Divider activeDivider() {
        return this.dragDivider;
    }

    public DividerPainter getDividerPainter() {
        return this.dividerPainter;
    }

    public void setDividerPainter(DividerPainter dividerPainter) {
        DividerPainter dividerPainter2 = this.getDividerPainter();
        this.dividerPainter = dividerPainter;
        this.firePropertyChange("dividerPainter", dividerPainter2, this.getDividerPainter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintComponent(Graphics graphics) {
        if (this.backgroundPainter != null) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            try {
                Insets insets = this.getInsets();
                graphics2D.translate(insets.left, insets.top);
                this.backgroundPainter.paint(graphics2D, this, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom);
            }
            finally {
                graphics2D.dispose();
            }
        } else {
            super.paintComponent(graphics);
        }
    }

    public void setBackgroundPainter(Painter painter) {
        Painter painter2 = this.getBackgroundPainter();
        this.backgroundPainter = painter;
        if (painter != null) {
            this.setOpaque(false);
        }
        this.firePropertyChange("backgroundPainter", painter2, this.getBackgroundPainter());
        this.repaint();
    }

    public Painter getBackgroundPainter() {
        return this.backgroundPainter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintChildren(Graphics graphics) {
        MultiSplitLayout multiSplitLayout;
        super.paintChildren(graphics);
        DividerPainter dividerPainter = this.getDividerPainter();
        Rectangle rectangle = graphics.getClipBounds();
        if (dividerPainter != null && rectangle != null && (multiSplitLayout = this.getMultiSplitLayout()).hasModel()) {
            for (MultiSplitLayout.Divider divider : multiSplitLayout.dividersThatOverlap(rectangle)) {
                Rectangle rectangle2 = divider.getBounds();
                Graphics graphics2 = graphics.create(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                try {
                    dividerPainter.paint((Graphics2D)graphics2, divider, rectangle2.width, rectangle2.height);
                }
                finally {
                    graphics2.dispose();
                }
            }
        }
    }

    private void startDrag(int n, int n2) {
        this.requestFocusInWindow();
        MultiSplitLayout multiSplitLayout = this.getMultiSplitLayout();
        MultiSplitLayout.Divider divider = multiSplitLayout.dividerAt(n, n2);
        if (divider != null) {
            MultiSplitLayout.Node node = divider.previousSibling();
            MultiSplitLayout.Node node2 = divider.nextSibling();
            if (node == null || node2 == null) {
                this.dragUnderway = false;
            } else {
                this.initialDividerBounds = divider.getBounds();
                this.dragOffsetX = n - this.initialDividerBounds.x;
                this.dragOffsetY = n2 - this.initialDividerBounds.y;
                this.dragDivider = divider;
                Rectangle rectangle = node.getBounds();
                Rectangle rectangle2 = node2.getBounds();
                if (this.dragDivider.isVertical()) {
                    this.dragMin = rectangle.x;
                    this.dragMax = rectangle2.x + rectangle2.width;
                    this.dragMax -= this.dragDivider.getBounds().width;
                    if (multiSplitLayout.getLayoutMode() == 2) {
                        this.dragMax -= multiSplitLayout.getUserMinSize();
                    }
                } else {
                    this.dragMin = rectangle.y;
                    this.dragMax = rectangle2.y + rectangle2.height;
                    this.dragMax -= this.dragDivider.getBounds().height;
                    if (multiSplitLayout.getLayoutMode() == 2) {
                        this.dragMax -= multiSplitLayout.getUserMinSize();
                    }
                }
                if (multiSplitLayout.getLayoutMode() == 2) {
                    this.dragMin += multiSplitLayout.getUserMinSize();
                } else if (this.dragDivider.isVertical()) {
                    this.dragMin = Math.max(this.dragMin, this.dragMin + this.getMinNodeSize((MultiSplitLayout)multiSplitLayout, (MultiSplitLayout.Node)node).width);
                    this.dragMax = Math.min(this.dragMax, this.dragMax - this.getMinNodeSize((MultiSplitLayout)multiSplitLayout, (MultiSplitLayout.Node)node2).width);
                    Dimension dimension = this.getMaxNodeSize(multiSplitLayout, node);
                    if (dimension != null) {
                        this.dragMax = Math.min(this.dragMax, rectangle.x + dimension.width);
                    }
                } else {
                    this.dragMin = Math.max(this.dragMin, this.dragMin + this.getMinNodeSize((MultiSplitLayout)multiSplitLayout, (MultiSplitLayout.Node)node).height);
                    this.dragMax = Math.min(this.dragMax, this.dragMax - this.getMinNodeSize((MultiSplitLayout)multiSplitLayout, (MultiSplitLayout.Node)node2).height);
                    Dimension dimension = this.getMaxNodeSize(multiSplitLayout, node);
                    if (dimension != null) {
                        this.dragMax = Math.min(this.dragMax, rectangle.y + dimension.height);
                    }
                }
                this.oldFloatingDividers = this.getMultiSplitLayout().getFloatingDividers();
                this.getMultiSplitLayout().setFloatingDividers(false);
                this.dragUnderway = true;
            }
        } else {
            this.dragUnderway = false;
        }
    }

    protected Dimension getMaxNodeSize(MultiSplitLayout multiSplitLayout, MultiSplitLayout.Node node) {
        return null;
    }

    protected Dimension getMinNodeSize(MultiSplitLayout multiSplitLayout, MultiSplitLayout.Node node) {
        return multiSplitLayout.minimumNodeSize(node);
    }

    private void repaintDragLimits() {
        Rectangle rectangle = this.dragDivider.getBounds();
        if (this.dragDivider.isVertical()) {
            rectangle.x = this.dragMin;
            rectangle.width = this.dragMax - this.dragMin;
        } else {
            rectangle.y = this.dragMin;
            rectangle.height = this.dragMax - this.dragMin;
        }
        this.repaint(rectangle);
    }

    private void updateDrag(int n, int n2) {
        if (!this.dragUnderway) {
            return;
        }
        Rectangle rectangle = this.dragDivider.getBounds();
        Rectangle rectangle2 = new Rectangle(rectangle);
        if (this.dragDivider.isVertical()) {
            rectangle2.x = n - this.dragOffsetX;
            rectangle2.x = Math.max(rectangle2.x, this.dragMin);
            rectangle2.x = Math.min(rectangle2.x, this.dragMax);
        } else {
            rectangle2.y = n2 - this.dragOffsetY;
            rectangle2.y = Math.max(rectangle2.y, this.dragMin);
            rectangle2.y = Math.min(rectangle2.y, this.dragMax);
        }
        this.dragDivider.setBounds(rectangle2);
        if (this.isContinuousLayout()) {
            this.revalidate();
            this.repaintDragLimits();
        } else {
            this.repaint(rectangle.union(rectangle2));
        }
    }

    private void clearDragState() {
        this.dragDivider = null;
        this.initialDividerBounds = null;
        this.oldFloatingDividers = true;
        this.dragOffsetY = 0;
        this.dragOffsetX = 0;
        this.dragMax = -1;
        this.dragMin = -1;
        this.dragUnderway = false;
    }

    private void finishDrag(int n, int n2) {
        if (this.dragUnderway) {
            this.clearDragState();
            if (!this.isContinuousLayout()) {
                this.revalidate();
                this.repaint();
            }
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void cancelDrag() {
        if (this.dragUnderway) {
            this.dragDivider.setBounds(this.initialDividerBounds);
            this.getMultiSplitLayout().setFloatingDividers(this.oldFloatingDividers);
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.repaint();
            this.revalidate();
            this.clearDragState();
        }
    }

    private void updateCursor(int n, int n2, boolean bl) {
        MultiSplitLayout.Divider divider;
        if (this.dragUnderway) {
            return;
        }
        int n3 = 0;
        if (bl && (divider = this.getMultiSplitLayout().dividerAt(n, n2)) != null) {
            n3 = divider.isVertical() ? 11 : 8;
        }
        this.setCursor(Cursor.getPredefinedCursor(n3));
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleMultiSplitPane();
        }
        return this.accessibleContext;
    }

    protected class AccessibleMultiSplitPane
    extends JPanel.AccessibleJPanel {
        protected AccessibleMultiSplitPane() {
            super(JXMultiSplitPane.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SPLIT_PANE;
        }
    }

    private class InputHandler
    extends MouseInputAdapter
    implements KeyListener {
        private InputHandler() {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            JXMultiSplitPane.this.updateCursor(mouseEvent.getX(), mouseEvent.getY(), true);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            JXMultiSplitPane.this.updateCursor(mouseEvent.getX(), mouseEvent.getY(), true);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            JXMultiSplitPane.this.updateCursor(mouseEvent.getX(), mouseEvent.getY(), false);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            JXMultiSplitPane.this.startDrag(mouseEvent.getX(), mouseEvent.getY());
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            JXMultiSplitPane.this.finishDrag(mouseEvent.getX(), mouseEvent.getY());
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            JXMultiSplitPane.this.updateDrag(mouseEvent.getX(), mouseEvent.getY());
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 27) {
                JXMultiSplitPane.this.cancelDrag();
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }
    }

    private class DefaultDividerPainter
    extends DividerPainter {
        private DefaultDividerPainter() {
        }

        protected void doPaint(Graphics2D graphics2D, MultiSplitLayout.Divider divider, int n, int n2) {
            if (divider == JXMultiSplitPane.this.activeDivider() && !JXMultiSplitPane.this.isContinuousLayout()) {
                graphics2D.setColor(Color.black);
                graphics2D.fillRect(0, 0, n, n2);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class DividerPainter
    extends AbstractPainter<MultiSplitLayout.Divider> {
    }
}

