/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.plaf.ButtonUI;
import org.jdesktop.swingx.plaf.HyperlinkAddon;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;

public class JXHyperlink
extends JButton {
    public static final String uiClassID = "HyperlinkUI";
    private boolean hasBeenVisited = false;
    private Color unclickedColor = new Color(0, 51, 255);
    private Color clickedColor = new Color(153, 0, 153);
    private boolean overrulesActionOnClick;

    public JXHyperlink() {
        this((Action)null);
    }

    public JXHyperlink(Action action) {
        this.setAction(action);
        this.init();
    }

    public Color getUnclickedColor() {
        return this.unclickedColor;
    }

    public void setClickedColor(Color color) {
        Color color2 = this.getClickedColor();
        this.clickedColor = color;
        if (this.isClicked()) {
            this.setForeground(this.getClickedColor());
        }
        this.firePropertyChange("clickedColor", color2, this.getClickedColor());
    }

    public Color getClickedColor() {
        return this.clickedColor;
    }

    public void setUnclickedColor(Color color) {
        Color color2 = this.getUnclickedColor();
        this.unclickedColor = color;
        if (!this.isClicked()) {
            this.setForeground(this.getUnclickedColor());
        }
        this.firePropertyChange("unclickedColor", color2, this.getUnclickedColor());
    }

    public void setClicked(boolean bl) {
        boolean bl2 = this.isClicked();
        this.hasBeenVisited = bl;
        this.setForeground(this.isClicked() ? this.getClickedColor() : this.getUnclickedColor());
        this.firePropertyChange("clicked", bl2, this.isClicked());
    }

    public boolean isClicked() {
        return this.hasBeenVisited;
    }

    public void setOverrulesActionOnClick(boolean bl) {
        boolean bl2 = this.getOverrulesActionOnClick();
        this.overrulesActionOnClick = bl;
        this.firePropertyChange("overrulesActionOnClick", bl2, this.getOverrulesActionOnClick());
    }

    public boolean getOverrulesActionOnClick() {
        return this.overrulesActionOnClick;
    }

    protected void fireActionPerformed(ActionEvent actionEvent) {
        super.fireActionPerformed(actionEvent);
        if (this.isAutoSetClicked()) {
            this.setClicked(true);
        }
    }

    protected boolean isAutoSetClicked() {
        return this.getAction() == null || this.getOverrulesActionOnClick();
    }

    protected PropertyChangeListener createActionPropertyChangeListener(final Action action) {
        final PropertyChangeListener propertyChangeListener = super.createActionPropertyChangeListener(action);
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("visited".equals(propertyChangeEvent.getPropertyName())) {
                    JXHyperlink.this.configureClickedPropertyFromAction(action);
                } else {
                    propertyChangeListener.propertyChange(propertyChangeEvent);
                }
            }
        };
    }

    protected void configurePropertiesFromAction(Action action) {
        super.configurePropertiesFromAction(action);
        this.configureClickedPropertyFromAction(action);
    }

    private void configureClickedPropertyFromAction(Action action) {
        boolean bl = false;
        if (action != null) {
            bl = Boolean.TRUE.equals(action.getValue("visited"));
        }
        this.setClicked(bl);
    }

    private void init() {
        this.setForeground(this.isClicked() ? this.getClickedColor() : this.getUnclickedColor());
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public void updateUI() {
        this.setUI((ButtonUI)LookAndFeelAddons.getUI(this, ButtonUI.class));
    }

    static {
        LookAndFeelAddons.contribute(new HyperlinkAddon());
    }
}

