/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.util.Locale;
import java.util.regex.Pattern;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import org.jdesktop.swingx.AbstractPatternPanel;
import org.jdesktop.swingx.search.Searchable;

public class JXFindPanel
extends AbstractPatternPanel {
    public static final String FIND_NEXT_ACTION_COMMAND = "findNext";
    public static final String FIND_PREVIOUS_ACTION_COMMAND = "findPrevious";
    protected Searchable searchable;
    protected JCheckBox wrapCheck;
    protected JCheckBox backCheck;
    private boolean initialized;

    public JXFindPanel() {
        this((Searchable)null);
    }

    public JXFindPanel(Searchable searchable) {
        this.setName(this.getUIString("searchTitle"));
        this.setSearchable(searchable);
        this.initActions();
    }

    public void setSearchable(Searchable searchable) {
        if (this.searchable != null && this.searchable.equals(searchable)) {
            return;
        }
        Searchable searchable2 = this.searchable;
        if (searchable2 != null) {
            searchable2.search((Pattern)null);
        }
        this.searchable = searchable;
        this.getPatternModel().setFoundIndex(-1);
        this.firePropertyChange("searchable", searchable2, this.searchable);
    }

    public void addNotify() {
        this.init();
        super.addNotify();
    }

    protected void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.initComponents();
        this.build();
        this.bind();
    }

    protected void bind() {
        super.bind();
        this.getActionContainerFactory().configureButton(this.wrapCheck, this.getAction("wrapSearch"), null);
        this.getActionContainerFactory().configureButton(this.backCheck, this.getAction("backwardsSearch"), null);
    }

    protected void refreshEmptyFromModel() {
        super.refreshEmptyFromModel();
        boolean bl = !this.getPatternModel().isEmpty();
        this.getAction(FIND_NEXT_ACTION_COMMAND).setEnabled(bl);
        this.getAction(FIND_PREVIOUS_ACTION_COMMAND).setEnabled(bl);
    }

    public void match() {
        this.doFind();
    }

    public void findNext() {
        this.getPatternModel().setBackwards(false);
        this.doFind();
    }

    public void findPrevious() {
        this.getPatternModel().setBackwards(true);
        this.doFind();
    }

    protected void doFind() {
        boolean bl;
        if (this.searchable == null) {
            return;
        }
        int n = this.doSearch();
        boolean bl2 = bl = n == -1 && !this.getPatternModel().isEmpty();
        if (bl && this.getPatternModel().isWrapping()) {
            boolean bl3 = bl = this.doSearch() == -1;
        }
        if (bl) {
            this.showNotFoundMessage();
        } else {
            this.showFoundMessage();
        }
    }

    protected int doSearch() {
        int n = this.searchable.search(this.getPatternModel().getPattern(), this.getPatternModel().getFoundIndex(), this.getPatternModel().isBackwards());
        this.getPatternModel().setFoundIndex(n);
        return this.getPatternModel().getFoundIndex();
    }

    protected void showFoundMessage() {
    }

    protected void showNotFoundMessage() {
        JOptionPane.showMessageDialog(this, this.getUIString("notFound"));
    }

    protected void updateLocaleState(Locale locale) {
        super.updateLocaleState(locale);
        this.setName(this.getUIString("searchTitle", locale));
    }

    protected void initExecutables() {
        this.getActionMap().put(FIND_NEXT_ACTION_COMMAND, this.createBoundAction(FIND_NEXT_ACTION_COMMAND, FIND_NEXT_ACTION_COMMAND));
        this.getActionMap().put(FIND_PREVIOUS_ACTION_COMMAND, this.createBoundAction(FIND_PREVIOUS_ACTION_COMMAND, FIND_PREVIOUS_ACTION_COMMAND));
        super.initExecutables();
    }

    protected void initComponents() {
        super.initComponents();
        this.wrapCheck = new JCheckBox();
        this.backCheck = new JCheckBox();
    }

    protected void build() {
        Box box = new Box(2);
        box.add(this.searchLabel);
        box.add(new JLabel(":"));
        box.add(new JLabel("  "));
        box.setAlignmentY(0.0f);
        Box box2 = new Box(3);
        box2.add(this.searchField);
        box2.add(this.matchCheck);
        box2.add(this.wrapCheck);
        box2.add(this.backCheck);
        box2.setAlignmentY(0.0f);
        this.setLayout(new BoxLayout(this, 2));
        this.add(box);
        this.add(box2);
    }
}

