/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.Locale;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.plaf.basic.BasicOptionPaneUI;
import org.jdesktop.swingx.JXRootPane;
import org.jdesktop.swingx.JXStatusBar;
import org.jdesktop.swingx.action.BoundAction;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;
import org.jdesktop.swingx.plaf.UIManagerExt;

public class JXDialog
extends JDialog {
    public static final String EXECUTE_ACTION_COMMAND = "execute";
    public static final String CLOSE_ACTION_COMMAND = "close";
    public static final String UIPREFIX = "XDialog.";
    protected JComponent content;

    public JXDialog(JComponent jComponent) {
        this.setContent(jComponent);
    }

    public JXDialog(Frame frame, JComponent jComponent) {
        super(frame);
        this.setContent(jComponent);
    }

    public JXDialog(Dialog dialog, JComponent jComponent) {
        super(dialog);
        this.setContent(jComponent);
    }

    protected JXRootPane createRootPane() {
        return new JXRootPane();
    }

    public JXRootPane getRootPane() {
        return (JXRootPane)super.getRootPane();
    }

    public void setStatusBar(JXStatusBar jXStatusBar) {
        this.getRootPane().setStatusBar(jXStatusBar);
    }

    public JXStatusBar getStatusBar() {
        return this.getRootPane().getStatusBar();
    }

    public void setToolBar(JToolBar jToolBar) {
        this.getRootPane().setToolBar(jToolBar);
    }

    public JToolBar getToolBar() {
        return this.getRootPane().getToolBar();
    }

    private void setContent(JComponent jComponent) {
        Action action;
        if (this.content != null) {
            throw new IllegalStateException("content must not be set more than once");
        }
        this.initActions();
        Action action2 = jComponent.getActionMap().get(CLOSE_ACTION_COMMAND);
        if (action2 != null) {
            this.putAction(CLOSE_ACTION_COMMAND, action2);
        }
        if ((action = jComponent.getActionMap().get(EXECUTE_ACTION_COMMAND)) != null) {
            this.putAction(EXECUTE_ACTION_COMMAND, action);
        }
        this.content = jComponent;
        this.build();
        this.setTitleFromContent();
    }

    protected void setTitleFromContent() {
        if (this.content == null) {
            return;
        }
        this.setTitle(this.content.getName());
    }

    private void build() {
        Box box = new Box(3);
        box.add(this.content);
        JComponent jComponent = this.createButtonPanel();
        box.add(jComponent);
        box.setBorder(BorderFactory.createEmptyBorder(14, 14, 14, 14));
        this.add(box);
    }

    public void setVisible(boolean bl) {
        if (this.content == null) {
            throw new IllegalStateException("content must be built before showing the dialog");
        }
        super.setVisible(bl);
    }

    public void setLocale(Locale locale) {
        if (this.content != null) {
            this.content.setLocale(locale);
            this.updateLocaleState(locale);
        }
        super.setLocale(locale);
    }

    protected void updateLocaleState(Locale locale) {
        this.setTitleFromContent();
        for (Object object : this.getRootPane().getActionMap().allKeys()) {
            String string;
            if (!(object instanceof String)) continue;
            Action action = this.content.getActionMap().get(object);
            Action action2 = this.getAction(object);
            if (action2.equals(action) || object.equals(string = this.getUIString((String)object, locale))) continue;
            action2.putValue("Name", string);
        }
    }

    public void doClose() {
        this.dispose();
    }

    private void initActions() {
        Action action = this.createCloseAction();
        this.putAction(CLOSE_ACTION_COMMAND, action);
        this.putAction(EXECUTE_ACTION_COMMAND, action);
    }

    private Action createCloseAction() {
        String string = this.getUIString(CLOSE_ACTION_COMMAND);
        BoundAction boundAction = new BoundAction(string, CLOSE_ACTION_COMMAND);
        boundAction.registerCallback(this, "doClose");
        return boundAction;
    }

    protected JComponent createButtonPanel() {
        JPanel jPanel = new JPanel(new BasicOptionPaneUI.ButtonAreaLayout(true, 6)){

            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        };
        jPanel.setBorder(BorderFactory.createEmptyBorder(9, 0, 0, 0));
        Action action = this.getAction(EXECUTE_ACTION_COMMAND);
        Action action2 = this.getAction(CLOSE_ACTION_COMMAND);
        JButton jButton = new JButton(action);
        jPanel.add(jButton);
        this.getRootPane().setDefaultButton(jButton);
        if (action != action2) {
            JButton jButton2 = new JButton(action2);
            jPanel.add(jButton2);
            this.getRootPane().setCancelButton(jButton2);
        }
        return jPanel;
    }

    private void putAction(Object object, Action action) {
        this.getRootPane().getActionMap().put(object, action);
    }

    private Action getAction(Object object) {
        return this.getRootPane().getActionMap().get(object);
    }

    protected String getUIString(String string) {
        return this.getUIString(string, this.getLocale());
    }

    protected String getUIString(String string, Locale locale) {
        String string2 = UIManagerExt.getString(UIPREFIX + string, locale);
        return string2 != null ? string2 : string;
    }

    static {
        LookAndFeelAddons.getAddon();
    }
}

