/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import org.jdesktop.swingx.painter.AbstractPainter;
import org.jdesktop.swingx.painter.Painter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JXButton
extends JButton {
    private String text = "";
    private boolean borderPainted;
    private boolean contentAreaFilled;
    private Painter<JXButton> fgPainter = new DefaultForegroundPainter();
    private Painter<JXButton> bgPainter = new DefaultBackgroundPainter();
    private boolean paintBorderInsets = true;
    private boolean painting;
    private boolean opaque = true;

    public JXButton() {
    }

    public JXButton(String string) {
        super(string);
        this.text = string;
    }

    public JXButton(Action action) {
        this.setAction(action);
    }

    public JXButton(Icon icon) {
        super(icon);
    }

    public JXButton(String string, Icon icon) {
        super(string, icon);
        this.text = string;
    }

    @Override
    protected void init(String string, Icon icon) {
        this.borderPainted = true;
        this.contentAreaFilled = true;
        super.init(string, icon);
    }

    @Override
    public void setText(String string) {
        this.text = string;
        super.setText(string);
    }

    @Override
    public void repaint() {
        if (this.painting) {
            return;
        }
        super.repaint();
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setBorderPainted(boolean bl) {
        this.borderPainted = bl;
        super.setBorderPainted(bl);
    }

    @Override
    public boolean isBorderPainted() {
        return this.borderPainted;
    }

    @Override
    public void setContentAreaFilled(boolean bl) {
        this.contentAreaFilled = bl;
        super.setContentAreaFilled(bl);
    }

    @Override
    public boolean isContentAreaFilled() {
        return this.contentAreaFilled;
    }

    public Painter<JXButton> getBackgroundPainter() {
        return this.bgPainter;
    }

    public void setBackgroundPainter(Painter<JXButton> painter) {
        Painter<JXButton> painter2 = this.getBackgroundPainter();
        this.bgPainter = painter;
        this.firePropertyChange("backgroundPainter", painter2, this.getBackgroundPainter());
        this.repaint();
    }

    public Painter<JXButton> getForegroundPainter() {
        return this.fgPainter;
    }

    public void setForegroundPainter(Painter<JXButton> painter) {
        Painter<JXButton> painter2 = this.getForegroundPainter();
        this.fgPainter = painter;
        this.firePropertyChange("foregroundPainter", painter2, this.getForegroundPainter());
        this.repaint();
    }

    public boolean isPaintBorderInsets() {
        return this.paintBorderInsets;
    }

    public void setPaintBorderInsets(boolean bl) {
        boolean bl2 = this.isPaintBorderInsets();
        this.paintBorderInsets = bl;
        this.firePropertyChange("paintBorderInsets", bl2, this.isPaintBorderInsets());
    }

    @Override
    public boolean isOpaque() {
        return this.painting ? this.opaque : super.isOpaque();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Painter<JXButton> painter = this.getBackgroundPainter();
        Painter<JXButton> painter2 = this.getForegroundPainter();
        if (this.painting || painter == null && painter2 == null) {
            super.paintComponent(graphics);
        } else {
            this.invokePainter(graphics, painter);
            this.invokePainter(graphics, painter2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokePainter(Graphics graphics, Painter<JXButton> painter) {
        if (painter == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        try {
            if (this.isPaintBorderInsets()) {
                painter.paint(graphics2D, this, this.getWidth(), this.getHeight());
            } else {
                Insets insets = this.getInsets();
                graphics2D.translate(insets.left, insets.top);
                painter.paint(graphics2D, this, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom);
            }
        }
        finally {
            graphics2D.dispose();
        }
    }

    protected void setPainting(boolean bl) {
        this.painting = bl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DefaultForegroundPainter
    extends AbstractPainter<JXButton> {
        private DefaultForegroundPainter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doPaint(Graphics2D graphics2D, JXButton jXButton, int n, int n2) {
            jXButton.setPainting(true);
            boolean bl = jXButton.isBorderPainted();
            boolean bl2 = jXButton.isContentAreaFilled();
            boolean bl3 = jXButton.opaque;
            jXButton.borderPainted = false;
            jXButton.contentAreaFilled = false;
            jXButton.opaque = false;
            try {
                jXButton.paint(graphics2D);
            }
            finally {
                jXButton.opaque = bl3;
                jXButton.borderPainted = bl;
                jXButton.contentAreaFilled = bl2;
                jXButton.setPainting(false);
            }
        }

        @Override
        protected boolean shouldUseCache() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DefaultBackgroundPainter
    extends AbstractPainter<JXButton> {
        private DefaultBackgroundPainter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doPaint(Graphics2D graphics2D, JXButton jXButton, int n, int n2) {
            boolean bl = jXButton.opaque;
            jXButton.opaque = jXButton.isOpaque();
            jXButton.setPainting(true);
            String string = jXButton.text;
            Icon icon = jXButton.getIcon();
            jXButton.setIcon(null);
            jXButton.text = "";
            try {
                jXButton.paint(graphics2D);
            }
            finally {
                jXButton.opaque = bl;
                jXButton.text = string;
                jXButton.setIcon(icon);
                jXButton.setPainting(false);
            }
        }

        @Override
        protected boolean shouldUseCache() {
            return false;
        }
    }
}

