/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.swingx;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Map;
import java.util.Set;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.icon.EmptyIcon;
import org.jdesktop.swingx.plaf.basic.BasicTaskPaneUI;
import org.jvnet.lafwidget.LafWidget;
import org.jvnet.lafwidget.LafWidgetRepository;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.animation.FadeState;
import org.jvnet.lafwidget.animation.FadeStateListener;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.lafwidget.utils.RenderingUtils;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.api.ColorSchemeAssociationKind;
import org.jvnet.substance.api.ComponentState;
import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.painter.decoration.DecorationAreaType;
import org.jvnet.substance.painter.utils.DecorationPainterUtils;
import org.jvnet.substance.painter.utils.HighlightPainterUtils;
import org.jvnet.substance.swingx.SubstanceSwingxFillBackgroundDelegate;
import org.jvnet.substance.utils.RolloverControlListener;
import org.jvnet.substance.utils.SubstanceColorSchemeUtilities;
import org.jvnet.substance.utils.SubstanceColorUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceFadeUtilities;
import org.jvnet.substance.utils.SubstanceImageCreator;
import org.jvnet.substance.utils.SubstanceSizeUtils;
import org.jvnet.substance.utils.Trackable;
import org.jvnet.substance.utils.icon.TransitionAwareIcon;

public class SubstanceTaskPaneUI
extends BasicTaskPaneUI
implements Trackable {
    protected Set lafWidgets;
    private SubstanceSwingxFillBackgroundDelegate bgDelegate = new SubstanceSwingxFillBackgroundDelegate();
    private RolloverControlListener substanceRolloverListener;
    protected FadeStateListener substanceFadeStateListener;
    protected ButtonModel taskPaneModel = new DefaultButtonModel();

    public void __org__jvnet__substance__swingx__SubstanceTaskPaneUI__update(Graphics graphics, JComponent jComponent) {
        super.update(graphics, jComponent);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        Object object;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = graphics2D.getComposite();
        float f = 1.0f;
        if (composite instanceof AlphaComposite && ((AlphaComposite)(object = (AlphaComposite)composite)).getRule() == 3) {
            f = ((AlphaComposite)object).getAlpha();
        }
        graphics2D.setComposite(TransitionLayout.getAlphaComposite((Component)jComponent, (float)f));
        object = RenderingUtils.installDesktopHints((Graphics2D)graphics2D, (Component)jComponent);
        this.__org__jvnet__substance__swingx__SubstanceTaskPaneUI__update(graphics2D, jComponent);
        graphics2D.setComposite(composite);
        if (object != null) {
            graphics2D.addRenderingHints((Map<?, ?>)object);
        }
    }

    public void __org__jvnet__substance__swingx__SubstanceTaskPaneUI__installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        this.__org__jvnet__substance__swingx__SubstanceTaskPaneUI__installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    public void uninstallUI(JComponent jComponent) {
        this.__org__jvnet__substance__swingx__SubstanceTaskPaneUI__uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    protected void installListeners() {
        this.__org__jvnet__substance__swingx__SubstanceTaskPaneUI__installListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    protected void installDefaults() {
        this.__org__jvnet__substance__swingx__SubstanceTaskPaneUI__installDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    protected void uninstallListeners() {
        this.__org__jvnet__substance__swingx__SubstanceTaskPaneUI__uninstallListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation((Component)comp);
        return new SubstanceTaskPaneUI();
    }

    public SubstanceTaskPaneUI() {
        this.taskPaneModel.setArmed(false);
        this.taskPaneModel.setSelected(false);
        this.taskPaneModel.setPressed(false);
        this.taskPaneModel.setRollover(false);
    }

    protected void __org__jvnet__substance__swingx__SubstanceTaskPaneUI__installListeners() {
        super.installListeners();
        this.substanceRolloverListener = new RolloverControlListener((Trackable)this, this.taskPaneModel);
        this.group.addMouseListener((MouseListener)this.substanceRolloverListener);
        this.group.addMouseMotionListener((MouseMotionListener)this.substanceRolloverListener);
        this.substanceFadeStateListener = new FadeStateListener((Component)this.group, this.taskPaneModel, SubstanceCoreUtilities.getFadeCallback((JComponent)this.group, (ButtonModel)this.taskPaneModel, (boolean)true, (boolean)false, (Component)this.group));
        this.substanceFadeStateListener.registerListeners(false);
    }

    protected void __org__jvnet__substance__swingx__SubstanceTaskPaneUI__uninstallListeners() {
        this.group.removeMouseListener((MouseListener)this.substanceRolloverListener);
        this.group.removeMouseMotionListener((MouseMotionListener)this.substanceRolloverListener);
        this.substanceRolloverListener = null;
        this.substanceFadeStateListener.unregisterListeners();
        this.substanceFadeStateListener = null;
        super.uninstallListeners();
    }

    protected void __org__jvnet__substance__swingx__SubstanceTaskPaneUI__installDefaults() {
        SubstanceLookAndFeel.setDecorationType((JComponent)this.group, (DecorationAreaType)DecorationAreaType.GENERAL);
        super.installDefaults();
    }

    public void __org__jvnet__substance__swingx__SubstanceTaskPaneUI__uninstallUI(JComponent c) {
        DecorationPainterUtils.clearDecorationType((JComponent)this.group);
        super.uninstallUI(c);
    }

    protected Border createPaneBorder() {
        return new SubstancePaneBorder();
    }

    protected Border createContentPaneBorder() {
        SubstanceColorScheme colorScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)this.group, (ColorSchemeAssociationKind)ColorSchemeAssociationKind.BORDER, (ComponentState)ComponentState.DEFAULT);
        final Color borderColor = colorScheme.isDark() ? colorScheme.getDarkColor() : SubstanceColorUtilities.getInterpolatedColor((Color)colorScheme.getMidColor(), (Color)colorScheme.getDarkColor(), (double)0.4);
        Border outer = new Border(){

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.setColor(borderColor);
                g2d.drawLine(x, y, x, y + height - 1);
                g2d.drawLine(x + width - 1, y, x + width - 1, y + height - 1);
                g2d.drawLine(x, y + height - 1, x + width - 1, y + height - 1);
                g2d.dispose();
            }

            @Override
            public boolean isBorderOpaque() {
                return true;
            }

            @Override
            public Insets getBorderInsets(Component c) {
                return new Insets(0, 1, 1, 1);
            }
        };
        return new CompoundBorder(outer, new EmptyBorder(1, 2, 2, 2));
    }

    public void paint(Graphics g, JComponent c) {
        this.bgDelegate.paint(c, (Graphics2D)g, false);
        super.paint(g, c);
    }

    public boolean isInside(MouseEvent me) {
        return this.isInBorder(me);
    }

    protected int getTitleHeight(Component c) {
        return SubstanceSizeUtils.getAdjustedSize((int)SubstanceSizeUtils.getComponentFontSize((Component)c), (int)super.getTitleHeight(c), (int)2, (int)3, (boolean)false);
    }

    protected class SubstancePaneBorder
    extends BasicTaskPaneUI.PaneBorder {
        protected Icon expandedIcon;
        protected Icon collapsedIcon;

        public SubstancePaneBorder() {
            super((BasicTaskPaneUI)SubstanceTaskPaneUI.this);
            this.borderColor = SubstanceColorSchemeUtilities.getColorScheme((Component)SubstanceTaskPaneUI.this.group, (ColorSchemeAssociationKind)ColorSchemeAssociationKind.BORDER, (ComponentState)ComponentState.DEFAULT).getMidColor();
            TransitionAwareIcon.ColorSchemeAssociationKindDelegate colorSchemeAssociationDelegate = new TransitionAwareIcon.ColorSchemeAssociationKindDelegate(){

                public ColorSchemeAssociationKind getColorSchemeAssociationKind(ComponentState state) {
                    if (state.isKindActive(FadeKind.ENABLE) && state != ComponentState.DEFAULT) {
                        return ColorSchemeAssociationKind.HIGHLIGHT;
                    }
                    return ColorSchemeAssociationKind.MARK;
                }
            };
            this.expandedIcon = new TransitionAwareIcon((JComponent)SubstanceTaskPaneUI.this.group, SubstanceTaskPaneUI.this.taskPaneModel, new TransitionAwareIcon.Delegate(){

                public Icon getColorSchemeIcon(SubstanceColorScheme scheme) {
                    return SubstanceImageCreator.getDoubleArrowIconDelta((int)SubstanceSizeUtils.getComponentFontSize((Component)SubstanceTaskPaneUI.this.group), (float)0.0f, (float)3.0f, (float)0.0f, (int)1, (SubstanceColorScheme)scheme);
                }
            }, colorSchemeAssociationDelegate, "substance.swingx.taskpane.expanded");
            this.collapsedIcon = new TransitionAwareIcon((JComponent)SubstanceTaskPaneUI.this.group, SubstanceTaskPaneUI.this.taskPaneModel, new TransitionAwareIcon.Delegate(){

                public Icon getColorSchemeIcon(SubstanceColorScheme scheme) {
                    return SubstanceImageCreator.getDoubleArrowIconDelta((int)SubstanceSizeUtils.getComponentFontSize((Component)SubstanceTaskPaneUI.this.group), (float)0.0f, (float)3.0f, (float)0.0f, (int)5, (SubstanceColorScheme)scheme);
                }
            }, colorSchemeAssociationDelegate, "substance.swingx.taskpane.collapsed");
            SubstanceLookAndFeel.setDecorationType((JComponent)this.label, (DecorationAreaType)DecorationAreaType.GENERAL);
            this.label.putClientProperty("substancelaf.internal.textUtilities.enforceFgColor", Boolean.TRUE);
        }

        protected void paintTitleBackground(JXTaskPane group, Graphics g) {
            Graphics2D graphics = (Graphics2D)g.create();
            ComponentState currState = ComponentState.getState((ButtonModel)SubstanceTaskPaneUI.this.taskPaneModel, (JComponent)group);
            ComponentState prevState = SubstanceCoreUtilities.getPrevComponentState((JComponent)group);
            FadeState state = SubstanceFadeUtilities.getFadeState((Component)group, (FadeKind[])new FadeKind[]{FadeKind.ROLLOVER});
            float fadeCoef = 0.0f;
            if (state != null) {
                fadeCoef = state.getFadePosition();
                if (state.isFadingIn()) {
                    fadeCoef = 1.0f - fadeCoef;
                }
            }
            HighlightPainterUtils.paintHighlight((Graphics)graphics, null, (Component)group, (Rectangle)new Rectangle(0, 0, group.getWidth(), SubstanceTaskPaneUI.this.getTitleHeight((Component)group)), (float)0.5f, null, (ComponentState)currState, (ComponentState)prevState, (float)fadeCoef);
            graphics.dispose();
        }

        protected Color getPaintColor(JXTaskPane group) {
            SubstanceColorScheme currScheme;
            ComponentState state = ComponentState.getState((ButtonModel)SubstanceTaskPaneUI.this.taskPaneModel, (JComponent)group);
            ComponentState prevState = SubstanceCoreUtilities.getPrevComponentState((JComponent)group);
            ColorSchemeAssociationKind assocKind = ColorSchemeAssociationKind.FILL;
            if (state.isKindActive(FadeKind.ENABLE) && state != ComponentState.DEFAULT) {
                assocKind = ColorSchemeAssociationKind.HIGHLIGHT;
            }
            SubstanceColorScheme prevScheme = currScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)group, (ColorSchemeAssociationKind)assocKind, (ComponentState)state);
            if (prevState != state) {
                ColorSchemeAssociationKind prevAssocKind = ColorSchemeAssociationKind.FILL;
                if (prevState.isKindActive(FadeKind.ENABLE) && prevState != ComponentState.DEFAULT) {
                    prevAssocKind = ColorSchemeAssociationKind.HIGHLIGHT;
                }
                prevScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)group, (ColorSchemeAssociationKind)prevAssocKind, (ComponentState)prevState);
            }
            Color result = SubstanceColorUtilities.getInterpolatedForegroundColor((Component)group, null, (SubstanceColorScheme)currScheme, (ComponentState)state, (SubstanceColorScheme)prevScheme, (ComponentState)prevState, (FadeKind[])new FadeKind[]{FadeKind.ROLLOVER, FadeKind.SELECTION, FadeKind.PRESS});
            return result;
        }

        protected void paintExpandedControls(JXTaskPane group, Graphics g, int x, int y, int width, int height) {
            Icon arrowIcon = group.isCollapsed() ? this.collapsedIcon : this.expandedIcon;
            int dx = (width - arrowIcon.getIconWidth()) / 2;
            int dy = 1 + (height - arrowIcon.getIconHeight()) / 2;
            arrowIcon.paintIcon((Component)group, g, x + dx, y + dy);
        }

        protected boolean isMouseOverBorder() {
            return true;
        }

        protected void paintFocus(Graphics g, Color paintColor, int x, int y, int width, int height) {
            SubstanceCoreUtilities.paintFocus((Graphics)g, (Component)SubstanceTaskPaneUI.this.group, (Component)SubstanceTaskPaneUI.this.group, (Shape)new Rectangle(x, y, width - 1, height - 1), (Rectangle)this.label.getBounds(), (float)1.0f, (int)0);
        }

        protected void configureLabel(JXTaskPane group) {
            this.label.applyComponentOrientation(group.getComponentOrientation());
            this.label.setFont(group.getFont());
            this.label.setText(group.getTitle());
            this.label.setIcon((Icon)(group.getIcon() == null ? new EmptyIcon() : group.getIcon()));
        }
    }
}

