/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.utilities.os;

import cz.vity.freerapid.utilities.LogUtils;
import cz.vity.freerapid.utilities.Utils;
import cz.vity.freerapid.utilities.os.OSCommand;
import cz.vity.freerapid.utilities.os.SystemCommander;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Logger;

class LinuxCmdUtils
implements SystemCommander {
    private static final String SYSTEM_COMMAND_PROPERTIES_FILE = "syscmd.properties";
    private static final Logger logger = Logger.getLogger(LinuxCmdUtils.class.getName());
    private Properties commands;

    LinuxCmdUtils(File file) {
        this.init(file);
    }

    private void init(File file) {
        File file2 = new File(file, SYSTEM_COMMAND_PROPERTIES_FILE);
        this.commands = file2.isFile() && file2.exists() ? Utils.loadProperties(file2.getAbsolutePath(), false) : ((file2 = new File(Utils.getAppPath(), SYSTEM_COMMAND_PROPERTIES_FILE)).isFile() && file2.exists() ? Utils.loadProperties(file2.getAbsolutePath(), false) : new Properties());
    }

    @Override
    public boolean createShortCut(OSCommand oSCommand) {
        if (!OSCommand.shortCutCommands.contains((Object)oSCommand)) {
            throw new IllegalArgumentException("OS command " + (Object)((Object)oSCommand) + " is not a shortcut command");
        }
        switch (oSCommand) {
            case CREATE_DESKTOP_SHORTCUT: {
                return this.createDesktopShortcut();
            }
            case CREATE_QUICKLAUNCH_SHORTCUT: {
                return this.createQuickLaunchShortcut();
            }
            case CREATE_STARTMENU_SHORTCUT: {
                return this.createStartMenuShortcut();
            }
            case CREATE_STARTUP_SHORTCUT: {
                return this.createStartupShortcut();
            }
        }
        assert (false);
        return false;
    }

    private boolean createDesktopShortcut() {
        return this.makeShortcut(OSCommand.CREATE_DESKTOP_SHORTCUT);
    }

    private boolean makeShortcut(OSCommand oSCommand) {
        return this.isSupported(oSCommand) && LinuxCmdUtils.runCommand(this.getCommand(oSCommand), true);
    }

    private static String prepareCommand(String string) {
        String string2 = Utils.getAppPath();
        String string3 = Utils.addFileSeparator(string2);
        string = string.replaceAll("%DIR%", string2);
        string = string.replaceAll("%VERSION%", "0.83u1");
        string = string.replaceAll("%APPVERSION%", "FreeRapid 0.83u1");
        string = string.replaceAll("%AUTHORS%", "Authors (c) 2008/09 Vity");
        string = string.replaceAll("%PRODUCT%", "FreeRapid");
        string = string.replaceAll("%ICON_PATH%", string3 + "frd.png");
        string = string.replaceAll("%SH_SCRIPT_PATH%", string3 + "frd.sh");
        string = string.replaceAll("%ARGS%", Utils.getApplicationArguments());
        return string;
    }

    private static boolean runCommand(String string, boolean bl) {
        string = LinuxCmdUtils.prepareCommand(string);
        logger.info("Xcommand:" + string);
        try {
            Process process = Runtime.getRuntime().exec(string);
            if (bl) {
                process.waitFor();
                return process.exitValue() == 0;
            }
            return true;
        }
        catch (IOException iOException) {
            logger.warning("XCommand command:" + string);
            LogUtils.processException(logger, iOException);
            return false;
        }
        catch (InterruptedException interruptedException) {
            LogUtils.processException(logger, interruptedException);
            return false;
        }
    }

    private boolean createStartMenuShortcut() {
        return this.makeShortcut(OSCommand.CREATE_STARTMENU_SHORTCUT);
    }

    private boolean createStartupShortcut() {
        return this.makeShortcut(OSCommand.CREATE_STARTUP_SHORTCUT);
    }

    private boolean createQuickLaunchShortcut() {
        return this.makeShortcut(OSCommand.CREATE_QUICKLAUNCH_SHORTCUT);
    }

    @Override
    public boolean shutDown(OSCommand oSCommand, boolean bl) {
        if (!OSCommand.shutDownCommands.contains((Object)oSCommand)) {
            throw new IllegalArgumentException("OS command " + (Object)((Object)oSCommand) + " is not a shut down command");
        }
        return this.isSupported(oSCommand) && LinuxCmdUtils.runCommand(this.getCommand(oSCommand), false);
    }

    @Override
    public boolean isSupported(OSCommand oSCommand) {
        String string = LinuxCmdUtils.getKey(oSCommand);
        return this.commands.containsKey(string) && !this.commands.getProperty(string, "").trim().isEmpty();
    }

    private String getCommand(OSCommand oSCommand) {
        return this.commands.getProperty(LinuxCmdUtils.getKey(oSCommand), "");
    }

    private static String getKey(OSCommand oSCommand) {
        return oSCommand.toString().toLowerCase();
    }
}

