/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.utilities;

import cz.vity.freerapid.utilities.LogUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Properties;
import java.util.logging.Logger;

public final class Utils {
    private static final Logger logger = Logger.getLogger(Utils.class.getName());
    private static final int WINDOWS_OS = 0;
    private static int operatingSystem = -1;
    private static String actualJavaVersion = null;
    private static final int XOR_VALUE = 35132;
    public static volatile String appPath = null;

    private Utils() {
    }

    public static String generateXorString(String string) {
        if (string == null) {
            return null;
        }
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        if (n > 0) {
            StringBuilder stringBuilder = new StringBuilder(n);
            for (int i = 0; i < n; ++i) {
                stringBuilder.append((char)(cArray[i] ^ 0x893C));
            }
            return stringBuilder.toString();
        }
        return "";
    }

    public static boolean isJVMVersion(double d) {
        Object object;
        if (actualJavaVersion == null) {
            object = System.getProperty("java.version");
            if (object == null) {
                return false;
            }
            actualJavaVersion = ((String)object).substring(0, 3);
        }
        return ((Double)(object = new Double(actualJavaVersion))).compareTo(d) >= 0;
    }

    public static String getExtension(File file) {
        String string = null;
        String string2 = file.getName();
        int n = string2.lastIndexOf(46);
        if (n > 0 && n < string2.length() - 1) {
            string = string2.substring(n + 1).toLowerCase();
        }
        return string;
    }

    public static String getPureFilename(File file) {
        String[] stringArray = file.getName().split("\\.", 2);
        return stringArray[0];
    }

    public static String getPureFilenameWithDots(File file) {
        String string = file.getName();
        int n = string.lastIndexOf(46);
        if (n > 0) {
            return string.substring(0, n);
        }
        return string;
    }

    public static String addFileSeparator(String string) {
        return string.endsWith(File.separator) ? string : string + File.separator;
    }

    public static String shortenFileName(File file, int n) {
        return Utils.shortenFileName(file.getAbsolutePath(), n);
    }

    public static String shortenFileName(String string, int n) {
        int n2 = string.length();
        if (n2 < n) {
            return string;
        }
        String string2 = File.separator;
        String[] stringArray = string.split(string2.equals("\\") ? "\\\\" : string2);
        int n3 = stringArray.length;
        if (n3 > 3) {
            int n4 = 0;
            for (int i = 2; i < n3 - 2 && n2 - (n4 += stringArray[i].length()) + 3 >= n; ++i) {
            }
            StringBuilder stringBuilder = new StringBuilder(n2 - n4 + 3);
            stringBuilder.append(stringArray[0]).append(string2).append(stringArray[1]).append(string2).append("...");
            for (int i = i + 1; i < n3; ++i) {
                stringBuilder.append(string2);
                stringBuilder.append(stringArray[i]);
            }
            return stringBuilder.toString();
        }
        return string;
    }

    public static void addParam(StringBuilder stringBuilder, String string, String string2) {
        String string3;
        if (string2 == null) {
            string2 = "";
        }
        try {
            string3 = URLEncoder.encode(string2, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string3 = "";
            LogUtils.processException(logger, unsupportedEncodingException);
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append('&');
        }
        stringBuilder.append(string).append('=').append(string3);
    }

    public static boolean isWindows() {
        if (operatingSystem == -1) {
            String string = System.getProperty("os.name");
            operatingSystem = string == null || string.startsWith("Windows") ? 0 : 1;
        }
        return operatingSystem == 0;
    }

    public static void setFileAsHidden(File file) {
        if (!file.exists() || !file.isFile()) {
            return;
        }
        if (Utils.isWindows()) {
            try {
                Runtime.getRuntime().exec("attrib.exe +H " + file.getAbsolutePath());
            }
            catch (IOException iOException) {
                logger.warning("Setting file " + file.getAbsolutePath() + " as hidden failed.");
                LogUtils.processException(logger, iOException);
            }
        } else {
            File file2;
            String string = file.getName();
            if (!string.startsWith(".") && !file.renameTo(file2 = new File(file.getParentFile(), "." + string))) {
                logger.warning("Setting file " + file.getAbsolutePath() + " as hidden failed.");
            }
        }
    }

    public static Properties loadProperties(String string, boolean bl) {
        Properties properties = new Properties();
        InputStream inputStream = null;
        try {
            InputStream inputStream2 = inputStream = !bl ? new FileInputStream(string) : Utils.class.getClassLoader().getResourceAsStream(string);
            if (inputStream == null) {
                throw new IOException("Couldn't read Properties file");
            }
            properties.load(inputStream);
            inputStream.close();
            return properties;
        }
        catch (IOException iOException) {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException2) {
                LogUtils.processException(logger, iOException2);
            }
            logger.warning("Couldn't load properties:" + string);
            return properties;
        }
    }

    public static String addParam(String string, String string2, String string3) {
        String string4;
        try {
            string4 = URLEncoder.encode(string3, "ISO-8859-2");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string4 = "";
            LogUtils.processException(logger, unsupportedEncodingException);
        }
        String string5 = string2 + "=" + string4;
        return string.length() > 0 ? string + "&" + string5 : string5;
    }

    public static boolean hasValue(String string) {
        return string != null && !string.isEmpty();
    }

    public static String getExceptionMessage(Throwable throwable) {
        String string = throwable.getLocalizedMessage();
        if (string == null) {
            string = throwable.getMessage() != null ? throwable.getMessage() : throwable.toString();
        }
        return string;
    }

    public static String loadFile(String string) {
        return Utils.loadFile(new File(string), null);
    }

    public static String loadFile(File file) {
        return Utils.loadFile(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadFile(File file, String string) {
        StringBuilder stringBuilder = new StringBuilder(2000);
        BufferedReader bufferedReader = null;
        try {
            int n;
            InputStreamReader inputStreamReader = string == null ? new InputStreamReader(new FileInputStream(file)) : new InputStreamReader((InputStream)new FileInputStream(file), string);
            bufferedReader = new BufferedReader(inputStreamReader);
            char[] cArray = new char[2000];
            while ((n = bufferedReader.read(cArray)) != -1) {
                stringBuilder.append(cArray, 0, n);
            }
        }
        catch (IOException iOException) {
            LogUtils.processException(logger, iOException);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    LogUtils.processException(logger, iOException);
                }
            }
        }
        return stringBuilder.toString();
    }

    public static String getAppPath() {
        if (appPath != null) {
            return appPath;
        }
        try {
            URI uRI = LogUtils.class.getProtectionDomain().getCodeSource().getLocation().toURI();
            if (!"file".equalsIgnoreCase(uRI.getScheme())) {
                logger.info("Running Webstart application");
                appPath = "";
                return "";
            }
            appPath = new File(uRI).getParent();
        }
        catch (URISyntaxException uRISyntaxException) {
            LogUtils.processException(logger, uRISyntaxException);
            appPath = "";
            return "";
        }
        logger.config("App Path is " + appPath);
        return appPath;
    }

    public static String getSystemLineSeparator() {
        return System.getProperty("line.separator", "\n");
    }

    public static String getApplicationArguments() {
        Properties properties = System.getProperties();
        if (properties.containsKey("arguments")) {
            String[] stringArray = (String[])properties.get("arguments");
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : stringArray) {
                stringBuilder.append(string).append(' ');
            }
            return stringBuilder.toString().trim();
        }
        return "";
    }

    public static String ltrim(String string) {
        return string.replaceAll("^\\s+", "");
    }

    public static String rtrim(String string) {
        return string.replaceAll("\\s+$", "");
    }
}

