/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.swing;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.MainApp;
import cz.vity.freerapid.swing.KunstoffMetalTheme;
import cz.vity.freerapid.swing.LaF;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.utilities.LogUtils;
import cz.vity.freerapid.utilities.Utils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;
import org.jdesktop.swingx.util.OS;

public final class LookAndFeels {
    private static final String DEFAULT_LAF = "com.pagosoft.plaf.PgsLookAndFeel";
    private static final String DEFAULT_THEME = "";
    private static final String KUNSTSTOFF = "com.incors.plaf.kunststoff.KunststoffLookAndFeel";
    private LaF selectedLookAndFeel;
    private static final Logger logger = Logger.getLogger(LookAndFeels.class.getName());
    private static final LookAndFeels instance = new LookAndFeels();
    private static final String AQUA = "apple.laf.AquaLookAndFeel";
    private ClassLoader classLoader = this.initClassLoader();
    private List<LaF> availableLaFs = null;

    public static LookAndFeels getInstance() {
        return instance;
    }

    private LookAndFeels() {
        String string = AppPrefs.getProperty("lookAndFeel", null);
        String string2 = AppPrefs.getProperty("theme", DEFAULT_THEME);
        if (string == null) {
            String string3 = Swinger.getResourceMap().getString("Application.lookAndFeelDefault", new Object[0]);
            String string4 = string3 == null ? DEFAULT_THEME : string3.trim();
            string2 = null;
            string = "system".equals(string4) ? UIManager.getSystemLookAndFeelClassName() : (!"default".equals(string4) && string4 != null && !string4.isEmpty() ? string4 : (OS.isMacOSX() ? AQUA : DEFAULT_LAF));
        }
        boolean bl = AppPrefs.getProperty("lafOpaque", true);
        if (string2 == null && KUNSTSTOFF.equals(string)) {
            string2 = KunstoffMetalTheme.class.getName();
        }
        if (string2 == null) {
            string2 = DEFAULT_THEME;
        }
        this.selectedLookAndFeel = new LaF(string, DEFAULT_THEME, string2, bl);
    }

    private ClassLoader initClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (Utils.getAppPath().isEmpty()) {
            return classLoader;
        }
        String string = Utils.addFileSeparator(Utils.getAppPath()) + "lookandfeel";
        logger.info("Loading lookandfeel path " + string);
        File file = new File(string);
        try {
            if (file.exists()) {
                File[] fileArray = file.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File file, String string) {
                        return string.endsWith(".jar");
                    }
                });
                int n = fileArray.length;
                URL[] uRLArray = new URL[n];
                boolean bl = logger.isLoggable(Level.INFO);
                for (int i = 0; i < n; ++i) {
                    uRLArray[i] = fileArray[i].toURI().toURL();
                    if (!bl) continue;
                    logger.info("Loading URL with a jar " + uRLArray[i]);
                }
                classLoader = new URLClassLoader(uRLArray, classLoader);
            }
        }
        catch (Exception exception) {
            LogUtils.processException(logger, exception);
        }
        return classLoader;
    }

    public final List<LaF> getAvailableLookAndFeels() {
        if (this.availableLaFs == null) {
            String[] stringArray;
            this.availableLaFs = new ArrayList<LaF>();
            Properties properties = Utils.loadProperties("lookandfeels.properties", true);
            for (String string : stringArray = properties.getProperty("lafs", DEFAULT_THEME).split("\\|")) {
                String string2;
                String string3;
                String string4 = properties.getProperty(string + ".class");
                if (string4 == null || this.isPresent(string4) == null) continue;
                boolean bl = "true".equals(properties.getProperty(string + ".opaque", "true"));
                int n = -1;
                String string5 = properties.getProperty(string + ".name", string4);
                if ("true".equals(properties.getProperty(string + ".alone", "true"))) {
                    this.availableLaFs.add(new LaF(string4, string5, DEFAULT_THEME, bl));
                }
                while (!(string3 = properties.getProperty(string2 = string + ".theme" + ++n, DEFAULT_THEME)).isEmpty()) {
                    if (this.isPresent(string3) == null) continue;
                    String string6 = string5 + " - " + properties.getProperty(string2 + ".name", " - theme");
                    this.availableLaFs.add(new LaF(string4, string6, string3, bl));
                }
            }
        }
        return this.availableLaFs;
    }

    public final LaF getSelectedLaF() {
        return this.selectedLookAndFeel;
    }

    public final void storeSelectedLaF(LaF laF) {
        AppPrefs.storeProperty("lookAndFeel", laF.getClassName());
        AppPrefs.storeProperty("lafOpaque", laF.isToolbarOpaque());
        if (!laF.hasThemeClass()) {
            AppPrefs.removeProperty("theme");
        } else {
            AppPrefs.storeProperty("theme", laF.getThemeClass());
        }
        this.selectedLookAndFeel = laF;
        logger.config("LaF " + laF + " has been set. It will be effective on restart.");
    }

    public final void loadLookAndFeelSettings() {
        this.loadLookAndFeel(this.selectedLookAndFeel, false);
    }

    private Class<?> isPresent(String string) {
        try {
            return this.classLoader.loadClass(string);
        }
        catch (UnsupportedClassVersionError unsupportedClassVersionError) {
            logger.info("Look and feel class/theme " + string + " cannot be instantied. Probably higher version of the JDK is required.");
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean loadLookAndFeel(LaF laF, boolean bl) {
        String string = laF.getClassName();
        String string2 = laF.getThemeClass();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            if (string.equals(KUNSTSTOFF)) {
                this.initKunststoff();
            } else {
                this.initLaf(string, string2);
            }
        }
        catch (Exception exception) {
            logger.warning(string + " was not found. Reason: " + exception.getMessage());
            if (!string.equals(KUNSTSTOFF)) {
                if (logger.isLoggable(Level.INFO)) {
                    LogUtils.processException(logger, exception);
                }
                try {
                    this.initKunststoff();
                }
                catch (Exception exception2) {
                    logger.warning("Kunststoff Look and Feel was not found. Using a default metal theme.");
                    boolean bl2 = false;
                    return bl2;
                }
            }
            boolean bl3 = false;
            return bl3;
        }
        finally {
            if (bl) {
                JFrame jFrame = MainApp.getInstance(MainApp.class).getMainFrame();
                LookAndFeels.updateAllUIs();
                UIManager.getLookAndFeel().getDefaults();
                jFrame.invalidate();
                jFrame.validate();
                jFrame.repaint();
            }
        }
        return true;
    }

    private void initKunststoff() throws Exception {
        this.initLafWithTheme(KUNSTSTOFF, new KunstoffMetalTheme());
    }

    private void initLafWithTheme(String string, MetalTheme metalTheme) throws Exception {
        LookAndFeel lookAndFeel = (LookAndFeel)this.classLoader.loadClass(string).newInstance();
        if (metalTheme != null && lookAndFeel instanceof MetalLookAndFeel) {
            lookAndFeel.getClass().getMethod("setCurrentTheme", MetalTheme.class).invoke((Object)lookAndFeel, metalTheme);
        }
        UIManager.put("ClassLoader", this.classLoader);
        UIManager.setLookAndFeel(lookAndFeel);
        UIManager.put("ClassLoader", this.classLoader);
        Font font = (Font)UIManager.get("TitledBorder.font");
        if (font != null) {
            UIManager.put("TitledBorder.font", font.deriveFont(1));
        }
    }

    private void initLaf(String string, String string2) throws Exception {
        if (string2 != null && !string2.isEmpty()) {
            Class<?> clazz = this.isPresent(string2);
            if (clazz != null) {
                Object obj = clazz.newInstance();
                if (obj instanceof MetalTheme) {
                    this.initLafWithTheme(string, (MetalTheme)obj);
                } else {
                    logger.warning("Theme " + obj.getClass().getName() + " cannot be set.Theme is not an instance of Metaltheme");
                    this.initLafWithTheme(string, null);
                }
            }
        } else {
            this.initLafWithTheme(string, null);
        }
    }

    private static void updateAllUIs() {
        Frame[] frameArray;
        for (Frame frame : frameArray = Frame.getFrames()) {
            LookAndFeels.updateWindowUI(frame);
        }
    }

    public static void updateWindowUI(Window window) {
        Window[] windowArray;
        try {
            LookAndFeels.updateComponentTreeUI(window);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (Window window2 : windowArray = window.getOwnedWindows()) {
            LookAndFeels.updateWindowUI(window2);
        }
    }

    public static void updateComponentTreeUI(Component component) {
        LookAndFeels.updateComponentTreeUI0(component);
        component.invalidate();
        component.validate();
        component.repaint();
    }

    private static void updateComponentTreeUI0(Component component) {
        Component[] componentArray = null;
        if (component instanceof JToolBar) {
            componentArray = ((JToolBar)component).getComponents();
            if (componentArray != null) {
                boolean bl = LookAndFeels.getInstance().getSelectedLaF().isToolbarOpaque();
                for (Component component2 : componentArray) {
                    LookAndFeels.updateComponentTreeUI0(component2);
                    if (!(component2 instanceof JComponent)) continue;
                    ((JComponent)component2).setOpaque(!bl);
                }
            }
            ((JComponent)component).updateUI();
        } else {
            if (component instanceof JComponent) {
                ((JComponent)component).updateUI();
            }
            if (component instanceof JMenu) {
                componentArray = ((JMenu)component).getMenuComponents();
            } else if (component instanceof Container) {
                componentArray = ((Container)component).getComponents();
            }
            if (componentArray != null) {
                for (Component component3 : componentArray) {
                    LookAndFeels.updateComponentTreeUI0(component3);
                }
            }
        }
    }
}

