/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.plugins.webclient.ssl;

import cz.vity.freerapid.plugins.webclient.ssl.EasyX509TrustManager;
import cz.vity.freerapid.utilities.LogUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.commons.httpclient.HttpClientError;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;

public class EasySSLProtocolSocketFactory
implements SecureProtocolSocketFactory {
    private static final Logger logger = Logger.getLogger(EasySSLProtocolSocketFactory.class.getName());
    private SSLContext sslcontext = null;

    private static SSLContext createEasySSLContext() {
        try {
            SSLContext sSLContext = SSLContext.getInstance("SSL");
            sSLContext.init(null, new TrustManager[]{new EasyX509TrustManager(null)}, null);
            return sSLContext;
        }
        catch (Exception exception) {
            LogUtils.processException(logger, exception);
            throw new HttpClientError(exception.toString());
        }
    }

    private SSLContext getSSLContext() {
        if (this.sslcontext == null) {
            this.sslcontext = EasySSLProtocolSocketFactory.createEasySSLContext();
        }
        return this.sslcontext;
    }

    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException {
        return this.getSSLContext().getSocketFactory().createSocket(string, n, inetAddress, n2);
    }

    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2, HttpConnectionParams httpConnectionParams) throws IOException {
        if (httpConnectionParams == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        int n3 = httpConnectionParams.getConnectionTimeout();
        SSLSocketFactory sSLSocketFactory = this.getSSLContext().getSocketFactory();
        if (n3 == 0) {
            return sSLSocketFactory.createSocket(string, n, inetAddress, n2);
        }
        Socket socket = sSLSocketFactory.createSocket();
        InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, n2);
        InetSocketAddress inetSocketAddress2 = new InetSocketAddress(string, n);
        socket.bind(inetSocketAddress);
        socket.connect(inetSocketAddress2, n3);
        return socket;
    }

    public Socket createSocket(String string, int n) throws IOException {
        return this.getSSLContext().getSocketFactory().createSocket(string, n);
    }

    public Socket createSocket(Socket socket, String string, int n, boolean bl) throws IOException {
        return this.getSSLContext().getSocketFactory().createSocket(socket, string, n, bl);
    }

    public boolean equals(Object object) {
        return object != null && object.getClass().equals(EasySSLProtocolSocketFactory.class);
    }

    public int hashCode() {
        return EasySSLProtocolSocketFactory.class.hashCode();
    }
}

