/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.model;

import cz.vity.freerapid.model.DownloadFile;
import cz.vity.freerapid.utilities.DescriptorUtils;
import cz.vity.freerapid.utilities.LogUtils;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.Locale;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.java.plugin.registry.PluginDescriptor;
import org.jdesktop.application.AbstractBean;

public final class PluginMetaData
extends AbstractBean
implements Comparable<PluginMetaData> {
    private static final Logger logger = Logger.getLogger(PluginMetaData.class.getName());
    private String id;
    private boolean updatesEnabled;
    private boolean enabled;
    private Pattern supportedURL;
    private PluginDescriptor descriptor;
    private boolean hasOptions;
    private String services;
    private String www;
    private boolean premium;
    private boolean favicon;
    private boolean removeCompleted;
    private boolean resumeSupported;

    public PluginMetaData() {
    }

    public PluginMetaData(PluginDescriptor pluginDescriptor) {
        this.descriptor = pluginDescriptor;
        this.id = pluginDescriptor.getId();
        this.enabled = true;
        this.updatesEnabled = true;
        this.setPluginDescriptor(pluginDescriptor);
    }

    public void setPluginDescriptor(PluginDescriptor pluginDescriptor) {
        this.descriptor = pluginDescriptor;
        this.supportedURL = Pattern.compile(DescriptorUtils.getAttribute("urlRegex", "XX", pluginDescriptor), 2);
        this.hasOptions = DescriptorUtils.getAttribute("hasOptions", false, pluginDescriptor);
        this.services = DescriptorUtils.getAttribute("services", this.getId(), pluginDescriptor).toLowerCase(Locale.ENGLISH);
        this.www = DescriptorUtils.getAttribute("www", "http://wordrider.net/freerapid", pluginDescriptor);
        this.premium = DescriptorUtils.getAttribute("premium", false, pluginDescriptor);
        this.favicon = DescriptorUtils.getAttribute("faviconImage", null, pluginDescriptor) != null;
        this.removeCompleted = DescriptorUtils.getAttribute("removeCompleted", false, pluginDescriptor);
        this.resumeSupported = DescriptorUtils.getAttribute("resumeSupported", true, pluginDescriptor);
    }

    public boolean isSupported(String string) {
        return this.supportedURL.matcher(string).matches();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isOptionable() {
        return this.hasOptions;
    }

    public String getServices() {
        return this.services;
    }

    public String getVendor() {
        return this.descriptor.getVendor();
    }

    public String getWWW() {
        return this.www;
    }

    public boolean isDescriptorSet() {
        return this.descriptor != null;
    }

    public void setEnabled(boolean bl) {
        boolean bl2 = this.enabled;
        this.enabled = bl;
        this.firePropertyChange("enabled", bl2, bl);
    }

    public boolean isUpdatesEnabled() {
        return this.updatesEnabled;
    }

    public void setUpdatesEnabled(boolean bl) {
        boolean bl2 = this.updatesEnabled;
        this.updatesEnabled = bl;
        this.firePropertyChange("updatesEnabled", bl2, bl);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        PluginMetaData pluginMetaData = (PluginMetaData)object;
        return this.id.equals(pluginMetaData.id);
    }

    @Override
    public int compareTo(PluginMetaData pluginMetaData) {
        return this.id.compareToIgnoreCase(pluginMetaData.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String getVersion() {
        return this.descriptor.getVersion().toString();
    }

    public boolean isPremium() {
        return this.premium;
    }

    public boolean hasFavicon() {
        return this.favicon;
    }

    public boolean isRemoveCompleted() {
        return this.removeCompleted;
    }

    public String toString() {
        return "PluginMetaData{id='" + this.id + '\'' + " Version=" + this.getVersion() + '}';
    }

    public boolean isResumeSupported() {
        return this.resumeSupported;
    }

    static {
        try {
            PropertyDescriptor[] propertyDescriptorArray;
            BeanInfo beanInfo = Introspector.getBeanInfo(DownloadFile.class);
            for (PropertyDescriptor propertyDescriptor : propertyDescriptorArray = beanInfo.getPropertyDescriptors()) {
                String string = propertyDescriptor.getName();
                if (!"supportedURL".equals(string) && !"descriptor".equals(string) && !"www".equals(string) && !"services".equals(string) && !"hasOptions".equals(string) && !"premium".equals(string) && !"favicon".equals(string) && !"resumeSupported".equals(string)) continue;
                propertyDescriptor.setValue("transient", Boolean.TRUE);
            }
        }
        catch (IntrospectionException introspectionException) {
            LogUtils.processException(logger, introspectionException);
        }
    }
}

