/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.managers;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.MainApp;
import cz.vity.freerapid.core.tasks.CheckPluginUpdateTask;
import cz.vity.freerapid.core.tasks.DownloadNewPluginsTask;
import cz.vity.freerapid.gui.dialogs.UpdateDialog;
import cz.vity.freerapid.gui.dialogs.WrappedPluginData;
import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.gui.managers.PluginsManager;
import cz.vity.freerapid.model.DownloadFile;
import cz.vity.freerapid.plugins.webclient.DownloadState;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.utilities.LogUtils;
import cz.vity.freerapid.xmlimport.ver1.Plugin;
import java.awt.Frame;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Calendar;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.SwingUtilities;
import org.jdesktop.application.AbstractBean;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;
import org.jdesktop.application.TaskEvent;
import org.jdesktop.application.TaskListener;

public class UpdateManager {
    private static final Logger logger = Logger.getLogger(UpdateManager.class.getName());
    private final ManagerDirector director;
    private final ApplicationContext context;
    private Set<String> updatedPluginsCode = new HashSet<String>();
    private Timer timer;

    public UpdateManager(ManagerDirector managerDirector, ApplicationContext applicationContext) {
        this.director = managerDirector;
        this.context = applicationContext;
        if (AppPrefs.getProperty("blindMode", false)) {
            AppPrefs.storeProperty("pluginUpdateMethod", 2);
        }
        this.initListeners();
        this.initUpdateTimer();
    }

    private void initListeners() {
        AppPrefs.getPreferences().addPreferenceChangeListener(new PreferenceChangeListener(){

            @Override
            public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
                String string = preferenceChangeEvent.getKey();
                if ("pluginUpdateCheckInterval".equals(string) || "pluginLastUpdateDateTime".equals(string)) {
                    UpdateManager.this.initUpdateTimer();
                }
            }
        });
    }

    private void initUpdateTimer() {
        Calendar calendar;
        int n = Math.max(AppPrefs.getProperty("pluginUpdateCheckInterval", 24), 4);
        long l = AppPrefs.getProperty("pluginLastUpdateDateTime", 0L);
        Calendar calendar2 = Calendar.getInstance();
        if (l < 0L) {
            calendar2.add(11, 1);
            calendar = calendar2;
        } else {
            calendar = Calendar.getInstance();
            calendar.setTimeInMillis(l);
            calendar.add(11, n);
            if (l == 0L || calendar2.after(calendar)) {
                calendar2.add(13, 17);
                calendar = calendar2;
            }
        }
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = new Timer("UpdateTimer");
        logger.info(String.format("Rescheduling plugins update check to %1$ta %1$tb %1$td %1$tT", calendar.getTime()));
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (UpdateManager.this.checkForUpdates()) {
                    UpdateManager.this.checkUpdate(true);
                }
            }
        }, calendar.getTime(), (long)(n * 1000) * 3600L);
    }

    private boolean checkForUpdates() {
        return AppPrefs.getProperty("check4PluginUpdatesAutomatically", true);
    }

    public void checkUpdate(final boolean bl) {
        CheckPluginUpdateTask checkPluginUpdateTask = new CheckPluginUpdateTask(this.director, this.context, bl);
        checkPluginUpdateTask.addTaskListener(new TaskListener.Adapter<List<Plugin>, Void>(){

            @Override
            public void succeeded(final TaskEvent<List<Plugin>> taskEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        UpdateManager.this.updateDetected((List)taskEvent.getValue(), bl);
                    }
                });
            }
        });
        this.context.getTaskService().execute(checkPluginUpdateTask);
    }

    private void updateDetected(List<Plugin> list, boolean bl) {
        int n = AppPrefs.getProperty("pluginUpdateMethod", 0);
        List<WrappedPluginData> list2 = n == 2 ? this.generateUpdateData(list, false) : this.generateUpdateData(list, true);
        if (list2.isEmpty()) {
            if (!bl) {
                Swinger.showInformationDialog(this.context.getResourceMap().getString("updatesNotFoundMessage", new Object[0]));
            }
            return;
        }
        if (n == 0) {
            int n2 = Swinger.showOptionDialog(this.context.getResourceMap(), 3, "informationMessage", "updatesFoundMessage", new String[]{"updateWithDetails", "updateNowButton", "updateCancel"}, new Object[0]);
            n = n2 == 0 ? 1 : (n2 == 1 ? 2 : -1);
        }
        switch (n) {
            case 1: {
                this.showUpdateDialog(list2);
                break;
            }
            case 2: {
                this.downloadUpdate(list2);
                break;
            }
        }
    }

    private void showUpdateDialog(List<WrappedPluginData> list) {
        UpdateDialog updateDialog = new UpdateDialog((Frame)this.director.getMainFrame(), this.director);
        updateDialog.initData(list);
        MainApp mainApp = (MainApp)this.context.getApplication();
        mainApp.prepareDialog(updateDialog, true);
    }

    public void downloadUpdate(List<WrappedPluginData> list) {
        Task task = this.getDownloadPluginsTask(list);
        if (task != null) {
            this.executeUpdateTask(task);
        }
    }

    public DownloadFile getDownloadFileInstance(Plugin plugin) throws MalformedURLException {
        DownloadFile downloadFile = new DownloadFile();
        downloadFile.setFileUrl(new URL(plugin.getUrl()));
        downloadFile.setFileName(plugin.getFilename());
        downloadFile.setState(DownloadState.PAUSED);
        downloadFile.setErrorAttemptsCount(0);
        downloadFile.setFileSize(plugin.getFilesize());
        return downloadFile;
    }

    public Task getDownloadPluginsTask(final List<WrappedPluginData> list) {
        LinkedList<DownloadFile> linkedList = new LinkedList<DownloadFile>();
        for (WrappedPluginData wrappedPluginData : list) {
            DownloadFile downloadFile;
            if (!wrappedPluginData.isSelected() || this.updatedPluginsCode.contains(this.getUniqueId(wrappedPluginData.getID(), wrappedPluginData.getVersion())) || (downloadFile = wrappedPluginData.getHttpFile()).getState() == DownloadState.COMPLETED) continue;
            linkedList.add(wrappedPluginData.getHttpFile());
        }
        if (linkedList.isEmpty()) {
            return null;
        }
        DownloadNewPluginsTask downloadNewPluginsTask = new DownloadNewPluginsTask(this.director, this.context, linkedList);
        downloadNewPluginsTask.addTaskListener(new TaskListener.Adapter<Void, Long>(){

            @Override
            public void succeeded(TaskEvent<Void> taskEvent) {
                super.succeeded(taskEvent);
            }

            @Override
            public void finished(TaskEvent<Void> taskEvent) {
                for (WrappedPluginData wrappedPluginData : list) {
                    if (wrappedPluginData.getHttpFile().getState() != DownloadState.COMPLETED) continue;
                    UpdateManager.this.updatedPluginsCode.add(UpdateManager.this.getUniqueId(wrappedPluginData.getID(), wrappedPluginData.getVersion()));
                }
            }
        });
        return downloadNewPluginsTask;
    }

    public void executeUpdateTask(Task task) {
        this.context.getTaskService().execute(task);
    }

    private List<WrappedPluginData> generateUpdateData(List<Plugin> list, boolean bl) {
        PluginsManager pluginsManager = this.director.getPluginsManager();
        boolean bl2 = AppPrefs.getProperty("downloadNotExistingPlugins", true);
        LinkedList<WrappedPluginData> linkedList = new LinkedList<WrappedPluginData>();
        for (Plugin plugin : list) {
            boolean bl3;
            AbstractBean abstractBean;
            boolean bl4;
            String string = plugin.getId();
            if (this.updatedPluginsCode.contains(this.getUniqueId(string, plugin.getVersion()))) continue;
            boolean bl5 = bl4 = !pluginsManager.hasPlugin(string);
            if (!bl4 && !(abstractBean = pluginsManager.getPluginMetadata(string)).isUpdatesEnabled()) continue;
            boolean bl6 = bl3 = bl2 || !bl4;
            if (!bl3 && !bl) continue;
            try {
                abstractBean = this.getDownloadFileInstance(plugin);
                WrappedPluginData wrappedPluginData = new WrappedPluginData(bl3, (DownloadFile)abstractBean, plugin);
                wrappedPluginData.setNew(bl4);
                linkedList.add(wrappedPluginData);
            }
            catch (MalformedURLException malformedURLException) {
                LogUtils.processException(logger, malformedURLException);
            }
        }
        return linkedList;
    }

    private String getUniqueId(String string, String string2) {
        return string + '@' + string2;
    }
}

