/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.managers;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.model.PluginMetaData;
import cz.vity.freerapid.utilities.FileUtils;
import cz.vity.freerapid.utilities.LogUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.LocalStorage;

public class PluginMetaDataManager {
    private static final Logger logger = Logger.getLogger(PluginMetaDataManager.class.getName());
    private final ApplicationContext context;
    private final Set<PluginMetaData> items = new HashSet<PluginMetaData>();
    private static final String FILES_LIST_XML = "plugins.xml";
    private final Object saveFileLock = new Object();

    public PluginMetaDataManager(ApplicationContext applicationContext) {
        this.context = applicationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToFile(Set<PluginMetaData> set) {
        Object object = this.saveFileLock;
        synchronized (object) {
            logger.info("=====Saving PluginMetaData list into XML file=====");
            LocalStorage localStorage = this.context.getLocalStorage();
            File file = new File(localStorage.getDirectory(), FILES_LIST_XML);
            try {
                if (AppPrefs.getProperty("makeFileBackups", true)) {
                    FileUtils.makeBackup(file);
                }
                localStorage.save(set, FILES_LIST_XML);
            }
            catch (IOException iOException) {
                LogUtils.processException(logger, iOException);
            }
            finally {
                logger.info("=====Saving PluginMetaData list finished =====");
            }
        }
    }

    private Set<PluginMetaData> loadList(File file) throws IOException {
        HashSet<PluginMetaData> hashSet = new HashSet<PluginMetaData>();
        LocalStorage localStorage = this.context.getLocalStorage();
        if (!file.exists()) {
            return hashSet;
        }
        Object object = localStorage.load(FILES_LIST_XML);
        if (object instanceof Set) {
            return (Set)object;
        }
        return hashSet;
    }

    public synchronized Set<PluginMetaData> getItems() {
        this.loadData();
        return Collections.unmodifiableSet(this.items);
    }

    private void loadData() {
        Set<PluginMetaData> set = null;
        File file = new File(this.context.getLocalStorage().getDirectory(), FILES_LIST_XML);
        if (file.exists()) {
            try {
                set = this.loadList(file);
            }
            catch (Exception exception) {
                LogUtils.processException(logger, exception);
                logger.info("Trying to renew file from backup");
                try {
                    FileUtils.renewBackup(file);
                    set = this.loadList(file);
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (Exception exception2) {
                    LogUtils.processException(logger, exception);
                }
            }
            if (set != null) {
                this.items.addAll(set);
            }
        }
    }
}

