/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.dialogs.filechooser;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.gui.FRDUtils;
import cz.vity.freerapid.gui.dialogs.filechooser.EnhancedFileFilter;
import cz.vity.freerapid.gui.dialogs.filechooser.IFileType;
import cz.vity.freerapid.gui.dialogs.filechooser.JAppFileChooser;
import cz.vity.freerapid.gui.dialogs.filechooser.OpenFileChooser;
import cz.vity.freerapid.gui.dialogs.filechooser.SaveFileChooser;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.utilities.Utils;
import java.awt.Frame;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.filechooser.FileFilter;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ResourceMap;

public class OpenSaveDialogFactory {
    private static OpenSaveDialogFactory instance = null;

    private OpenSaveDialogFactory(ApplicationContext applicationContext) {
    }

    public static synchronized OpenSaveDialogFactory getInstance(ApplicationContext applicationContext) {
        if (instance == null) {
            return new OpenSaveDialogFactory(applicationContext);
        }
        return instance;
    }

    public File getSaveResultsDialog() {
        ArrayList<EnhancedFileFilter> arrayList = new ArrayList<EnhancedFileFilter>(3);
        arrayList.add(EnhancedFileFilter.createFilter(new String[]{"txt"}, "filterTxt"));
        arrayList.add(EnhancedFileFilter.createFilter(new String[]{"csv"}, "filterCsv"));
        arrayList.add(EnhancedFileFilter.createFilter(new String[]{"dxf"}, "filterDxf"));
        String string = AppPrefs.getProperty("lastUsedFolderExport", "export");
        String string2 = AppPrefs.getProperty("lastExportFilename", new File(string).getName());
        File file = this.getSaveFileDialog(arrayList, "lastExportFilter", "lastUsedFolderExport", string2);
        if (file != null) {
            AppPrefs.storeProperty("lastExportFilename", file.getName());
        }
        return file;
    }

    public File[] getChooseImageFileDialog() {
        ArrayList<EnhancedFileFilter> arrayList = new ArrayList<EnhancedFileFilter>(3);
        arrayList.add(EnhancedFileFilter.createFilter(new String[]{"tif", "tiff"}, "filterTIF"));
        return this.getOpenFileDialog(arrayList, "lastUsedImportFilter", "importLastUsedFolder");
    }

    private File[] getOpenFileDialog(List<EnhancedFileFilter> list, String string, String string2) {
        OpenFileChooser openFileChooser = new OpenFileChooser(new File(AppPrefs.getProperty(string2, "")));
        openFileChooser.updateFileFilters(list, string);
        openFileChooser.setAcceptAllFileFilterUsed(false);
        openFileChooser.setMultiSelectionEnabled(false);
        int n = openFileChooser.showOpenDialog(Frame.getFrames()[0]);
        if (n != 0) {
            return new File[0];
        }
        AppPrefs.storeProperty(string, list.indexOf(openFileChooser.getFileFilter()));
        AppPrefs.storeProperty(string2, FRDUtils.getAbsRelPath(openFileChooser.getSelectedFile()).getPath());
        return new File[]{openFileChooser.getSelectedFile()};
    }

    private File getSaveFileDialog(List<EnhancedFileFilter> list, String string, String string2, String string3) {
        int n;
        Object object;
        SaveFileChooser saveFileChooser = new SaveFileChooser(new File(AppPrefs.getProperty(string2, "")));
        saveFileChooser.setMultiSelectionEnabled(false);
        saveFileChooser.setAcceptAllFileFilterUsed(false);
        saveFileChooser.setFileName(string3);
        saveFileChooser.updateFileFilters(list, string);
        int n2 = saveFileChooser.showSaveDialog(Frame.getFrames()[0]);
        if (n2 != 0) {
            return null;
        }
        File file = saveFileChooser.getSelectedFile();
        if (file == null) {
            return null;
        }
        FileFilter fileFilter = saveFileChooser.getFileFilter();
        if (fileFilter instanceof IFileType && Utils.getExtension(file) == null) {
            object = ((IFileType)((Object)fileFilter)).getExtension();
            file = new File(file.getPath().concat(".").concat((String)object));
        }
        if (file.isFile() && file.exists() && (n = Swinger.getChoiceYesNoCancel(((ResourceMap)(object = Swinger.getResourceMap(JAppFileChooser.class))).getString("message.confirm.overwrite", new Object[0]))) == 1) {
            return null;
        }
        AppPrefs.storeProperty(string, list.indexOf(fileFilter));
        AppPrefs.storeProperty(string2, file.getPath());
        return file;
    }

    public File[] getChooseProxyList() {
        ArrayList<EnhancedFileFilter> arrayList = new ArrayList<EnhancedFileFilter>(1);
        arrayList.add(EnhancedFileFilter.createFilter(new String[]{"txt", "list"}, "filterTxt"));
        return this.getOpenFileDialog(arrayList, "lastUsedImportFilter", "importLastUsedFolder");
    }
}

