/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.dialogs;

import com.jgoodies.binding.PresentationModel;
import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.value.Trigger;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import cz.vity.freerapid.core.application.SubmitErrorInfo;
import cz.vity.freerapid.core.tasks.SubmitErrorInfoTask;
import cz.vity.freerapid.gui.dialogs.AppDialog;
import cz.vity.freerapid.gui.dialogs.ConnectDialog;
import cz.vity.freerapid.swing.ComponentFactory;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.utilities.LogUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.net.UnknownHostException;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.jdesktop.application.Action;
import org.jdesktop.application.Task;
import org.jdesktop.application.TaskEvent;
import org.jdesktop.application.TaskListener;

public class SubmitErrorDialog
extends AppDialog {
    private static final Logger logger = Logger.getLogger(SubmitErrorDialog.class.getName());
    private final SubmitErrorInfo errorInfo;
    private PresentationModel<SubmitErrorInfo> model = null;
    private JTextField fieldName;
    private JTextField fieldEmail;
    private JTextArea commentTextArea;
    private JButton btnConnection;
    private JButton btnOk;
    private JButton btnCancel;

    public SubmitErrorDialog(JFrame jFrame, SubmitErrorInfo submitErrorInfo) {
        super((Frame)jFrame, true);
        this.errorInfo = submitErrorInfo;
        this.setName("SubmitErrorDialog");
        try {
            this.initComponents();
            this.build();
        }
        catch (Exception exception) {
            LogUtils.processException(logger, exception);
            this.doClose();
        }
    }

    @Override
    protected AbstractButton getBtnOK() {
        return this.btnOk;
    }

    @Override
    protected AbstractButton getBtnCancel() {
        return this.btnCancel;
    }

    @Action
    public void cancelBtnAction() {
        this.model.triggerFlush();
        this.doClose();
    }

    @Action
    public void btnConnectionAction() {
        ConnectDialog connectDialog = new ConnectDialog(this);
        this.getApp().prepareDialog(connectDialog, true);
    }

    @Action(block=Task.BlockingScope.APPLICATION)
    public Task<Void, Void> okBtnAction() {
        this.setResult(0);
        this.model.triggerCommit();
        this.setVisible(false);
        SubmitErrorInfoTask submitErrorInfoTask = new SubmitErrorInfoTask(this.errorInfo);
        submitErrorInfoTask.addTaskListener(new TaskListener.Adapter<Void, Void>(){

            @Override
            public void failed(TaskEvent<Throwable> taskEvent) {
                SubmitErrorDialog.this.showCheckYourConnection(taskEvent.getValue());
                SubmitErrorDialog.this.setVisible(true);
            }

            @Override
            public void succeeded(TaskEvent<Void> taskEvent) {
                Swinger.showInformationDialog(SubmitErrorDialog.this.getResourceMap().getString("infomessage_submit_succeed", new Object[0]));
                SubmitErrorDialog.this.doClose();
            }
        });
        return submitErrorInfoTask;
    }

    private void showCheckYourConnection(Throwable throwable) {
        if (throwable instanceof UnknownHostException) {
            Swinger.showErrorMessage(this.getResourceMap(), "errormessage_check_inet_settings", new Object[0]);
        } else {
            Swinger.showErrorMessage(this.getResourceMap(), "errormessage_submit_failed", throwable.getLocalizedMessage());
        }
    }

    @Override
    public void doClose() {
        if (this.model != null) {
            this.model.release();
        }
        super.doClose();
    }

    private void build() {
        this.inject();
        this.buildGUI();
        this.setAction(this.btnOk, "okBtnAction");
        this.setAction(this.btnCancel, "cancelBtnAction");
        this.setAction(this.btnConnection, "btnConnectionAction");
        this.pack();
        this.setResizable(true);
        SubmitErrorDialog.locateOnOpticalScreenCenter(this);
    }

    private void buildGUI() {
        this.model = new PresentationModel((Object)this.errorInfo, (ValueModel)new Trigger());
        Bindings.bind((JTextField)this.fieldName, (ValueModel)this.model.getBufferedModel("name"));
        Bindings.bind((JTextField)this.fieldEmail, (ValueModel)this.model.getBufferedModel("email"));
        Bindings.bind((JTextArea)this.commentTextArea, (ValueModel)this.model.getBufferedModel("comment"));
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JLabel jLabel = new JLabel();
        this.fieldName = ComponentFactory.getTextField();
        JLabel jLabel2 = new JLabel();
        this.fieldEmail = ComponentFactory.getTextField();
        JLabel jLabel3 = new JLabel();
        JScrollPane jScrollPane = new JScrollPane();
        this.commentTextArea = ComponentFactory.getTextArea();
        JLabel jLabel4 = new JLabel();
        JPanel jPanel3 = new JPanel();
        this.btnConnection = new JButton();
        this.btnOk = new JButton();
        this.btnCancel = new JButton();
        CellConstraints cellConstraints = new CellConstraints();
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        jPanel.setBorder(Borders.DIALOG_BORDER);
        jPanel.setName("dialogPane");
        jPanel.setLayout(new BorderLayout());
        jPanel2.setName("contentPanel");
        jLabel.setLabelFor(this.fieldName);
        jLabel.setName("labelName");
        this.fieldName.setColumns(15);
        this.fieldName.setName("fieldName");
        jLabel2.setLabelFor(this.fieldEmail);
        jLabel2.setName("labelEmail");
        this.fieldEmail.setColumns(15);
        this.fieldEmail.setName("fieldEmail");
        jLabel3.setLabelFor(this.commentTextArea);
        jLabel3.setName("labelComment");
        jScrollPane.setName("scrollPane1");
        this.commentTextArea.setRows(10);
        this.commentTextArea.setLineWrap(true);
        this.commentTextArea.setName("commentTextArea");
        jScrollPane.setViewportView(this.commentTextArea);
        jLabel4.setName("labelDescribeInfo");
        PanelBuilder panelBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}), jPanel2);
        panelBuilder.add((Component)jLabel, cellConstraints.xy(1, 1));
        panelBuilder.add((Component)this.fieldName, cellConstraints.xy(3, 1));
        panelBuilder.add((Component)jLabel2, cellConstraints.xy(5, 1));
        panelBuilder.add((Component)this.fieldEmail, cellConstraints.xy(7, 1));
        panelBuilder.add((Component)jLabel3, cellConstraints.xywh(1, 3, 1, 1, CellConstraints.DEFAULT, CellConstraints.TOP));
        panelBuilder.add((Component)jScrollPane, cellConstraints.xywh(3, 3, 5, 1));
        panelBuilder.add((Component)jLabel4, cellConstraints.xywh(3, 5, 5, 1));
        jPanel.add((Component)jPanel2, "Center");
        jPanel3.setBorder(Borders.BUTTON_BAR_GAP_BORDER);
        jPanel3.setName("buttonBar");
        this.btnConnection.setName("btnConnection");
        this.btnOk.setName("okButton");
        this.btnCancel.setName("cancelButton");
        panelBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec("max(min;10dlu):grow"), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.BUTTON_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ComponentFactory.BUTTON_COLSPEC}, RowSpec.decodeSpecs((String)"pref")), jPanel3);
        panelBuilder.add((Component)this.btnConnection, cellConstraints.xywh(2, 1, 1, 1, CellConstraints.LEFT, CellConstraints.DEFAULT));
        panelBuilder.add((Component)this.btnOk, cellConstraints.xy(6, 1));
        panelBuilder.add((Component)this.btnCancel, cellConstraints.xy(8, 1));
        jPanel.add((Component)jPanel3, "South");
        container.add((Component)jPanel, "Center");
    }
}

