/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.dialogs;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import com.l2fprod.common.swing.JDirectoryChooser;
import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.gui.FRDUtils;
import cz.vity.freerapid.gui.actions.URLTransferHandler;
import cz.vity.freerapid.gui.dialogs.AppDialog;
import cz.vity.freerapid.gui.dialogs.CompoundUndoManager;
import cz.vity.freerapid.gui.managers.DataManager;
import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.gui.managers.PluginsManager;
import cz.vity.freerapid.model.DownloadFile;
import cz.vity.freerapid.swing.ComponentFactory;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.swing.components.EditorPaneLinkDetector;
import cz.vity.freerapid.swing.models.RecentsFilesComboModel;
import cz.vity.freerapid.utilities.LogUtils;
import cz.vity.freerapid.utilities.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import org.jdesktop.application.Action;
import org.jdesktop.swinghelper.buttonpanel.JXButtonPanel;

public class NewLinksDialog
extends AppDialog
implements ClipboardOwner {
    private static final Logger logger = Logger.getLogger(NewLinksDialog.class.getName());
    private EditorPaneLinkDetector urlsArea;
    private boolean startPaused = false;
    private final DataManager dataManager;
    private final List<URL> removeList;
    private PluginsManager pluginsManager;
    private final ManagerDirector director;
    private JComboBox comboPath;
    private JButton btnSelectPath;
    private JButton btnPasteFromClipboard;
    private JButton okButton;
    private JButton btnStartPaused;
    private JButton cancelButton;
    private JTextArea descriptionArea;

    public NewLinksDialog(ManagerDirector managerDirector, Frame frame) throws HeadlessException {
        super(frame, true);
        this.director = managerDirector;
        this.dataManager = managerDirector.getDataManager();
        this.pluginsManager = managerDirector.getPluginsManager();
        this.setName("NewLinksDialog");
        try {
            this.initComponents();
            this.build();
        }
        catch (Exception exception) {
            LogUtils.processException(logger, exception);
        }
        this.removeList = new ArrayList<URL>();
    }

    @Override
    protected AbstractButton getBtnOK() {
        return this.okButton;
    }

    @Override
    protected AbstractButton getBtnCancel() {
        return this.cancelButton;
    }

    private void build() {
        this.inject();
        this.buildGUI();
        this.setAction(this.okButton, "okBtnAction");
        this.setAction(this.cancelButton, "cancelBtnAction");
        this.setAction(this.btnPasteFromClipboard, "btnPasteFromClipboardAction");
        this.setAction(this.btnSelectPath, "btnSelectPathAction");
        this.setAction(this.btnStartPaused, "btnStartPausedAction");
        String string = this.getResourceMap().getString("btnSelectPathAction.description", new Object[0]);
        this.btnSelectPath.getAccessibleContext().setAccessibleName(string);
        this.btnSelectPath.getAccessibleContext().setAccessibleDescription(string);
        this.btnSelectPath.setToolTipText(string);
        this.pack();
        NewLinksDialog.locateOnOpticalScreenCenter(this);
    }

    @Action
    public void btnPasteFromClipboardAction() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        if (clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor)) {
            try {
                String string = (String)clipboard.getData(DataFlavor.stringFlavor);
                List<URL> list = URLTransferHandler.textURIListToFileList(string, this.getApp().getManagerDirector().getPluginsManager());
                LinkedList<String> linkedList = new LinkedList<String>();
                for (URL uRL : list) {
                    linkedList.add(uRL.toExternalForm());
                }
                this.urlsArea.setURLs(linkedList);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Action
    public void cancelBtnAction() {
        this.doClose();
    }

    @Action
    public void btnSelectPathAction() {
        JDirectoryChooser jDirectoryChooser = new JDirectoryChooser((String)this.comboPath.getEditor().getItem());
        jDirectoryChooser.setDialogTitle(this.getResourceMap().getString("directoryChooserTitle", new Object[0]));
        jDirectoryChooser.setControlButtonsAreShown(true);
        if (jDirectoryChooser.showDialog((Component)this, this.getResourceMap().getString("SelectDirectory", new Object[0])) != 1) {
            this.comboPath.getEditor().setItem(jDirectoryChooser.getSelectedFile().getAbsolutePath());
            Swinger.inputFocus(this.comboPath);
        }
    }

    @Action
    public void btnStartPausedAction() {
        if (!this.validateStart()) {
            return;
        }
        this.setResult(0);
        this.saveLastSaveToPath();
        this.startPaused = true;
        this.doClose();
    }

    @Override
    public void doClose() {
        super.doClose();
        if (this.getModalResult() == 0) {
            this.comboPath.addItem(this.comboPath.getSelectedItem());
        }
    }

    private void buildGUI() {
        new CompoundUndoManager(this.urlsArea);
        new CompoundUndoManager(this.descriptionArea);
        this.urlsArea.setPreferredSize(new Dimension(230, 100));
        this.urlsArea.getParent().setPreferredSize(new Dimension(230, 100));
        this.comboPath.setModel(new RecentsFilesComboModel("lastUsedSavedPaths", true));
        this.comboPath.setSelectedItem(AppPrefs.getProperty("lastComboPath", ""));
        this.descriptionArea.setFont(this.descriptionArea.getFont().deriveFont(11.0f));
        this.descriptionArea.setComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 9) {
                    if (!keyEvent.isShiftDown()) {
                        KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
                    } else {
                        KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent();
                    }
                    keyEvent.consume();
                }
            }
        };
        this.urlsArea.addKeyListener(keyAdapter);
        this.descriptionArea.addKeyListener(keyAdapter);
        this.setTransferHandler(new URLTransferHandler(this.director){

            @Override
            protected void doDropAction(List<URL> list) {
                NewLinksDialog.this.urlsArea.setURLList(list);
            }
        });
    }

    @Action
    public void okBtnAction() {
        if (!this.validateStart()) {
            return;
        }
        this.saveLastSaveToPath();
        this.setResult(0);
        this.doClose();
    }

    private void saveLastSaveToPath() {
        AppPrefs.storeProperty("lastComboPath", this.comboPath.getSelectedItem().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateStart() {
        Object object3;
        List<URL> list = this.urlsArea.getURLs();
        if (list.isEmpty()) {
            Swinger.showErrorMessage(this.getResourceMap(), "noURLMessage", new Object[0]);
            Swinger.inputFocus(this.urlsArea);
            return false;
        }
        StringBuilder stringBuilder = new StringBuilder();
        List<String> list2 = this.urlsArea.getURLsAsStringList();
        ArrayList<URL> arrayList = new ArrayList<URL>();
        String string = (String)this.comboPath.getEditor().getItem();
        if (string == null || string.isEmpty()) {
            Swinger.showErrorMessage(this.getResourceMap(), "noDirectoryMessage", new Object[0]);
            this.btnSelectPathAction();
            return false;
        }
        File file = new File(Utils.isWindows() ? string.trim() : string);
        if (!file.isDirectory()) {
            int n = Swinger.getChoiceYesNo(this.getResourceMap().getString("directoryCreateMessage", new Object[0]));
            if (n == 0) {
                if (!file.mkdirs()) {
                    Swinger.showErrorMessage(this.getResourceMap(), "directoryCreatingFailed", file.getAbsolutePath());
                    this.btnSelectPathAction();
                    return false;
                }
                if (!file.isDirectory()) {
                    Swinger.showErrorMessage(this.getResourceMap(), "itsNotDirectory", file.getAbsolutePath());
                    this.btnSelectPathAction();
                    return false;
                }
            } else {
                this.btnSelectPathAction();
                return false;
            }
        }
        for (URL uRL : list) {
            object3 = uRL.toExternalForm();
            if (this.pluginsManager.isSupported(uRL)) continue;
            arrayList.add(uRL);
            stringBuilder.append('\n').append((String)object3);
        }
        if (!arrayList.isEmpty()) {
            int n = Swinger.getChoiceYesNo(this.getResourceMap().getString("notSupportedByPlugins", stringBuilder.toString()));
            if (n == 0) {
                list.removeAll(arrayList);
                this.urlsArea.setText("");
                this.urlsArea.setURLList(list);
            } else {
                return false;
            }
        }
        if (list.isEmpty()) {
            Swinger.showErrorMessage(this.getResourceMap(), "noURLMessage", new Object[0]);
            Swinger.inputFocus(this.urlsArea);
            return false;
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        this.removeList.clear();
        stringBuilder = new StringBuilder();
        Object object2 = this.dataManager.getLock();
        synchronized (object2) {
            object3 = this.dataManager.getDownloadFiles();
            for (DownloadFile downloadFile : object3) {
                URL uRL = downloadFile.getFileUrl();
                String string2 = uRL.toString();
                arrayList2.add(string2);
            }
        }
        try {
            for (Object object3 : list2) {
                if (!arrayList2.contains(object3)) continue;
                this.removeList.add(new URL((String)object3));
                stringBuilder.append('\n').append((String)object3);
            }
        }
        catch (MalformedURLException malformedURLException) {
            LogUtils.processException(logger, malformedURLException);
        }
        if (!this.removeList.isEmpty()) {
            int n = Swinger.getChoiceYesNoCancel(this.getResourceMap().getString("alreadyContainsMessage", stringBuilder.toString()));
            switch (n) {
                case 1: {
                    return true;
                }
                case 0: {
                    this.removeList.clear();
                    return true;
                }
            }
            this.removeList.clear();
            return false;
        }
        return true;
    }

    public List<DownloadFile> getDownloadFiles() {
        File file = this.getDirectory();
        List<URL> list = this.urlsArea.getURLs();
        list.removeAll(this.removeList);
        LinkedHashMap<URI, URL> linkedHashMap = new LinkedHashMap<URI, URL>();
        for (URL object2 : list) {
            try {
                linkedHashMap.put(object2.toURI(), object2);
            }
            catch (URISyntaxException file2) {}
        }
        ArrayList arrayList = new ArrayList();
        String string = this.descriptionArea.getText();
        File file2 = FRDUtils.getAbsRelPath(file);
        for (URL uRL : linkedHashMap.values()) {
            arrayList.add(new DownloadFile(uRL, file2, string));
        }
        return arrayList;
    }

    private File getDirectory() {
        String string = (String)this.comboPath.getEditor().getItem();
        return new File(Utils.isWindows() ? string.trim() : string);
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JLabel jLabel = new JLabel();
        JScrollPane jScrollPane = new JScrollPane();
        this.urlsArea = ComponentFactory.getURLsEditorPane();
        JLabel jLabel2 = new JLabel();
        this.comboPath = new JComboBox();
        this.btnSelectPath = new JButton();
        JLabel jLabel3 = new JLabel();
        JScrollPane jScrollPane2 = new JScrollPane();
        this.descriptionArea = ComponentFactory.getTextArea();
        JXButtonPanel jXButtonPanel = new JXButtonPanel();
        this.btnPasteFromClipboard = new JButton();
        this.okButton = new JButton();
        this.btnStartPaused = new JButton();
        this.cancelButton = new JButton();
        CellConstraints cellConstraints = new CellConstraints();
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        jPanel.setBorder(Borders.DIALOG_BORDER);
        jPanel.setLayout(new BorderLayout());
        jLabel.setName("labelLinks");
        jLabel.setLabelFor(this.urlsArea);
        jScrollPane.setViewportView(this.urlsArea);
        jLabel2.setName("labelSaveTo");
        jLabel2.setLabelFor(this.comboPath);
        this.comboPath.setEditable(true);
        this.btnSelectPath.setName("btnSelectPath");
        jLabel3.setName("labelDescription");
        jLabel3.setLabelFor(this.descriptionArea);
        jScrollPane2.setViewportView(this.descriptionArea);
        PanelBuilder panelBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.PREFERRED, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.MIN_COLSPEC}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, (Size)Sizes.PREFERRED, 1.0), FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, Sizes.bounded((Size)Sizes.PREFERRED, (Size)Sizes.dluY((int)40), (Size)Sizes.dluY((int)55)), 1.0)}), jPanel2);
        panelBuilder.add((Component)jLabel, cellConstraints.xy(1, 1));
        panelBuilder.add((Component)jScrollPane, cellConstraints.xywh(1, 3, 5, 1));
        panelBuilder.add((Component)jLabel2, cellConstraints.xy(1, 5));
        panelBuilder.add((Component)this.comboPath, cellConstraints.xy(3, 5));
        panelBuilder.add((Component)this.btnSelectPath, cellConstraints.xy(5, 5));
        panelBuilder.add((Component)jLabel3, cellConstraints.xy(1, 7));
        panelBuilder.add((Component)jScrollPane2, cellConstraints.xywh(3, 7, 3, 1));
        jPanel.add((Component)jPanel2, "Center");
        jXButtonPanel.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.btnPasteFromClipboard.setName("btnPasteFromClipboard");
        this.okButton.setName("okButton");
        this.btnStartPaused.setName("btnStartPaused");
        this.cancelButton.setName("cancelButton");
        panelBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{FormFactory.PREF_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.UNRELATED_GAP_COLSPEC, FormFactory.PREF_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec("max(pref;50dlu)"), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec("max(pref;50dlu)")}, RowSpec.decodeSpecs((String)"fill:pref")), (JPanel)jXButtonPanel);
        ((FormLayout)jXButtonPanel.getLayout()).setColumnGroups((int[][])new int[][]{{5, 9}});
        panelBuilder.add((Component)this.btnPasteFromClipboard, cellConstraints.xy(1, 1));
        panelBuilder.add((Component)this.okButton, cellConstraints.xy(5, 1));
        panelBuilder.add((Component)this.btnStartPaused, cellConstraints.xy(7, 1));
        panelBuilder.add((Component)this.cancelButton, cellConstraints.xy(9, 1));
        jPanel.add((Component)jXButtonPanel, "South");
        container.add((Component)jPanel, "Center");
    }

    public boolean isStartPaused() {
        return this.startPaused;
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    public void setURLs(List<URL> list) {
        this.urlsArea.setURLList(list);
    }
}

