/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.dialogs;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import com.l2fprod.common.swing.JDirectoryChooser;
import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.gui.FRDUtils;
import cz.vity.freerapid.gui.content.ContentPanel;
import cz.vity.freerapid.gui.dialogs.AppFrame;
import cz.vity.freerapid.gui.dialogs.CompoundUndoManager;
import cz.vity.freerapid.model.DownloadFile;
import cz.vity.freerapid.plugins.webclient.DownloadState;
import cz.vity.freerapid.swing.ComponentFactory;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.swing.models.RecentsFilesComboModel;
import cz.vity.freerapid.utilities.LogUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.NumberFormat;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.jdesktop.application.Action;
import org.jdesktop.swinghelper.buttonpanel.JXButtonPanel;

public class MultipleSettingsDialog
extends AppFrame
implements PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(MultipleSettingsDialog.class.getName());
    private final List<DownloadFile> files;
    private final DownloadFile file;
    private JLabel titleLabel;
    private JTextField fieldSize;
    private JTextArea descriptionArea;
    private JComboBox comboPath;
    private JButton btnSelectPath;
    private JButton okButton;
    private JButton cancelButton;

    public MultipleSettingsDialog(Frame frame, List<DownloadFile> list) throws Exception {
        super(frame);
        this.files = list;
        this.file = list.get(0);
        this.setName("MultipleSettingsDialog");
        try {
            this.initComponents();
            this.build();
        }
        catch (Exception exception) {
            LogUtils.processException(logger, exception);
            this.doClose();
            throw exception;
        }
    }

    @Override
    protected AbstractButton getBtnOK() {
        return this.okButton;
    }

    @Override
    protected AbstractButton getBtnCancel() {
        return this.cancelButton;
    }

    @Action
    public void cancelBtnAction() {
        this.setResult(1);
        this.doClose();
    }

    private void build() {
        this.inject();
        this.buildGUI();
        this.buildModels();
        this.setAction(this.okButton, "okBtnAction");
        this.setAction(this.cancelButton, "cancelBtnAction");
        this.setAction(this.btnSelectPath, "btnSelectPathAction");
        this.updateInit();
    }

    private void buildModels() {
        for (DownloadFile downloadFile : this.files) {
            downloadFile.addPropertyChangeListener(this);
        }
    }

    private void buildGUI() {
        new CompoundUndoManager(this.descriptionArea);
        this.comboPath.setModel(new RecentsFilesComboModel("lastUsedSavedPaths", true));
        this.comboPath.setSelectedItem(this.file.getSaveToDirectory().getAbsolutePath());
        Swinger.inputFocus(this.descriptionArea);
        this.descriptionArea.setText(this.file.getDescription());
        this.fieldSize.setOpaque(false);
        this.fieldSize.setBackground(this.getBackground());
        this.fieldSize.setEditable(false);
        this.descriptionArea.setFont(this.descriptionArea.getFont().deriveFont(11.0f));
        StringBuilder stringBuilder = new StringBuilder();
        for (DownloadFile downloadFile : this.files) {
            stringBuilder.append(downloadFile.getFileName()).append("<br>");
        }
        this.titleLabel.setToolTipText(this.getResourceMap().getString("html", stringBuilder.toString()));
    }

    @Action
    public void okBtnAction() {
        if (!this.validateChanges()) {
            return;
        }
        AppPrefs.storeProperty("lastComboPath", this.comboPath.getSelectedItem().toString());
        File file = new File(this.comboPath.getEditor().getItem().toString());
        File file2 = FRDUtils.getAbsRelPath(file);
        this.file.setSaveToDirectory(file2);
        String string = this.descriptionArea.getText();
        for (DownloadFile downloadFile : this.files) {
            downloadFile.setSaveToDirectory(file2);
            downloadFile.setDescription(string);
        }
        this.setResult(0);
        this.doClose();
    }

    @Override
    public void doClose() {
        for (DownloadFile downloadFile : this.files) {
            downloadFile.removePropertyChangeListener(this);
        }
        super.doClose();
        if (this.getModalResult() == 0) {
            this.comboPath.addItem(this.comboPath.getSelectedItem());
        }
    }

    private boolean validateChanges() {
        String string = (String)this.comboPath.getEditor().getItem();
        if (string == null || !new File(string).isDirectory()) {
            Swinger.showErrorMessage(this.getResourceMap(), "noDirectoryMessage", new Object[0]);
            this.btnSelectPathAction();
            return false;
        }
        return true;
    }

    @Action
    public void btnSelectPathAction() {
        JDirectoryChooser jDirectoryChooser = new JDirectoryChooser(this.comboPath.getEditor().getItem().toString());
        if (jDirectoryChooser.showDialog((Component)this, this.getResourceMap().getString("SelectDirectory", new Object[0])) != 1) {
            this.comboPath.getEditor().setItem(jDirectoryChooser.getSelectedFile().getAbsolutePath());
            Swinger.inputFocus(this.comboPath);
        }
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JLabel jLabel = new JLabel();
        this.titleLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        this.fieldSize = new JTextField();
        JLabel jLabel3 = new JLabel();
        JScrollPane jScrollPane = new JScrollPane();
        this.descriptionArea = ComponentFactory.getTextArea();
        JPanel jPanel3 = new JPanel();
        JLabel jLabel4 = new JLabel();
        this.comboPath = new JComboBox();
        this.btnSelectPath = new JButton();
        JXButtonPanel jXButtonPanel = new JXButtonPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        CellConstraints cellConstraints = new CellConstraints();
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        jPanel.setBorder(Borders.DIALOG_BORDER);
        jPanel.setLayout(new BorderLayout());
        jLabel.setName("iconLabel");
        this.titleLabel.setName("titleLabel");
        this.titleLabel.setFont(new Font("Tahoma", 1, 12));
        jLabel2.setName("labelSize");
        this.fieldSize.setBorder(null);
        this.fieldSize.setOpaque(false);
        this.fieldSize.setEditable(false);
        jLabel3.setName("labelDescription");
        jScrollPane.setViewportView(this.descriptionArea);
        jLabel4.setName("saveToLabel");
        jLabel4.setLabelFor(this.comboPath);
        this.comboPath.setEditable(true);
        this.btnSelectPath.setName("btnSelectPath");
        PanelBuilder panelBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, RowSpec.decodeSpecs((String)"default")), jPanel3);
        panelBuilder.add((Component)jLabel4, cellConstraints.xy(1, 1));
        panelBuilder.add((Component)this.comboPath, cellConstraints.xy(3, 1));
        panelBuilder.add((Component)this.btnSelectPath, cellConstraints.xy(5, 1));
        panelBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{new ColumnSpec((Size)Sizes.dluX((int)49)), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec("max(min;70dlu)")}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.TOP, (Size)Sizes.PREFERRED, 0.0), FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, Sizes.bounded((Size)Sizes.PREFERRED, (Size)Sizes.dluY((int)40), (Size)Sizes.dluY((int)50)), 1.0), FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}), jPanel2);
        panelBuilder.add((Component)jLabel, cellConstraints.xywh(1, 1, 1, 5, CellConstraints.DEFAULT, CellConstraints.FILL));
        panelBuilder.add((Component)this.titleLabel, cellConstraints.xywh(3, 1, 5, 1));
        panelBuilder.add((Component)jLabel2, cellConstraints.xy(3, 3));
        panelBuilder.add((Component)this.fieldSize, cellConstraints.xywh(5, 3, 3, 1));
        panelBuilder.add((Component)jLabel3, cellConstraints.xy(1, 7));
        panelBuilder.add((Component)jScrollPane, cellConstraints.xywh(1, 9, 7, 1));
        panelBuilder.add((Component)jPanel3, cellConstraints.xywh(1, 11, 7, 1));
        jPanel.add((Component)jPanel2, "Center");
        jXButtonPanel.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.okButton.setName("okButton");
        this.cancelButton.setName("cancelButton");
        panelBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.UNRELATED_GAP_COLSPEC, new ColumnSpec("max(pref;42dlu)"), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, RowSpec.decodeSpecs((String)"fill:pref")), (JPanel)jXButtonPanel);
        ((FormLayout)jXButtonPanel.getLayout()).setColumnGroups((int[][])new int[][]{{3, 5}});
        panelBuilder.add((Component)this.okButton, cellConstraints.xy(3, 1));
        panelBuilder.add((Component)this.cancelButton, cellConstraints.xy(5, 1));
        jPanel.add((Component)jXButtonPanel, "South");
        container.add((Component)jPanel, "Center");
    }

    private void updateInit() {
        this.updateSize();
        this.updateState();
    }

    private void updateState() {
        this.updateEnabled();
    }

    private void updateEnabled() {
        boolean bl = true;
        for (DownloadFile eventListener2 : this.files) {
            DownloadState downloadState = eventListener2.getState();
            if (downloadState != DownloadState.COMPLETED && downloadState != DownloadState.DELETED) continue;
            bl = false;
            break;
        }
        javax.swing.Action action = this.getActionMap().get("okBtnAction");
        javax.swing.Action action2 = this.getActionMap().get("btnSelectPathAction");
        action.setEnabled(bl);
        action2.setEnabled(bl);
        this.descriptionArea.setEditable(bl);
        this.comboPath.setEditable(bl);
        this.comboPath.setEnabled(bl);
    }

    private void updateSize() {
        Object object;
        long l = 0L;
        for (DownloadFile downloadFile : this.files) {
            long l2 = downloadFile.getFileSize();
            if (l2 < 0L) {
                l = -1L;
                break;
            }
            l += l2;
        }
        if (l >= 0L) {
            object = ContentPanel.bytesToAnother(l);
            if (l >= 1024L) {
                object = (String)object + "  (" + NumberFormat.getIntegerInstance().format(l) + " B)";
            }
        } else {
            object = this.getResourceMap().getString("unknown", new Object[0]);
        }
        this.fieldSize.setText((String)object);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("state".equals(propertyChangeEvent.getPropertyName())) {
            this.updateState();
        } else if ("fileSize".equals(propertyChangeEvent.getPropertyName())) {
            this.updateSize();
        }
    }
}

