/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.actions;

import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.gui.managers.PluginsManager;
import cz.vity.freerapid.utilities.LogUtils;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;

public abstract class URLTransferHandler
extends TransferHandler {
    private static final Pattern REGEXP_URL = Pattern.compile("((http|https)://)?([a-zA-Z0-9\\.\\-]+(:[a-zA-Z0-9\\.:&%\\$\\-]+)*@)?((25[0-5]|2[0-4][0-9]|[0-1][0-9]{2}|[1-9][0-9]|[1-9])\\.(25[0-5]|2[0-4][0-9]|[0-1][0-9]{2}|[1-9][0-9]|[1-9]|0)\\.(25[0-5]|2[0-4][0-9]|[0-1][0-9]{2}|[1-9][0-9]|[1-9]|0)\\.(25[0-5]|2[0-4][0-9]|[0-1][0-9]{2}|[1-9][0-9]|[0-9])|([a-zA-Z0-9\\-]+\\.)*[a-zA-Z0-9\\-]+\\.[a-zA-Z]{2,4})(:[0-9]+)?(/[^/][\\p{Lu}\\p{Ll}0-9\\[\\]\\.:,\\?'\\\\/\\+&%\\$#=~_\\-@]*)*", 8);
    private static final String URL_LIST_MIME_TYPE = "application/x-java-url; class=java.net.URL";
    private static final Logger logger = Logger.getLogger(URLTransferHandler.class.getName());
    private List<URL> urls;
    private PluginsManager pluginsManager;

    protected abstract void doDropAction(List<URL> var1);

    public URLTransferHandler(ManagerDirector managerDirector) {
        this.pluginsManager = managerDirector.getPluginsManager();
    }

    public static List<URL> textURIListToFileList(String string, PluginsManager pluginsManager) {
        HashSet<Object> hashSet = new HashSet<Object>();
        LinkedList<URL> linkedList = new LinkedList<URL>();
        string = string.replaceAll("(\\p{Punct}|[\\t\\n\\x0B\\f\\r])http", "  http");
        Matcher matcher = REGEXP_URL.matcher(string);
        int n = 0;
        Pattern pattern = Pattern.compile("(.+)\\.{3,}");
        while (matcher.find(n)) {
            block12: {
                try {
                    Object object;
                    URL uRL;
                    String string2 = matcher.group();
                    if (!string2.startsWith("http://")) {
                        string2 = "http://" + string2;
                    }
                    if (string2.endsWith("'") && string2.length() > 2) {
                        string2 = string2.substring(0, string2.length() - 1);
                    }
                    if (!pluginsManager.isSupported(uRL = new URL(string2))) break block12;
                    String string3 = uRL.toExternalForm();
                    int n2 = string3.indexOf("...");
                    Pattern pattern2 = null;
                    Matcher matcher2 = pattern.matcher(string3);
                    boolean bl = matcher2.matches();
                    if (n2 > 0 && !bl) {
                        String string4 = Pattern.quote(string3.substring(0, n2)) + ".+" + Pattern.quote(string3.substring(n2 + 4));
                        pattern2 = Pattern.compile(string4);
                    }
                    boolean bl2 = false;
                    for (URI uRISyntaxException : hashSet) {
                        String string4 = uRISyntaxException.toURL().toExternalForm();
                        if (string4.length() <= string3.length() || !string4.startsWith(string3) && (pattern2 == null || !pattern2.matcher(string4).matches()) && (!bl || !string4.startsWith(matcher2.group(1)))) continue;
                        bl2 = true;
                        break;
                    }
                    if (bl2) break block12;
                    try {
                        object = new URI(string3);
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        object = new URI(URIUtil.encodePathQuery((String)string3));
                    }
                    if (!hashSet.contains(object)) {
                        hashSet.add(object);
                        linkedList.add(((URI)object).toURL());
                    }
                }
                catch (MalformedURLException malformedURLException) {
                }
                catch (URISyntaxException uRISyntaxException) {
                }
                catch (URIException uRIException) {
                    // empty catch block
                }
            }
            n = matcher.end();
        }
        return linkedList;
    }

    @Override
    public boolean importData(JComponent jComponent, Transferable transferable) {
        return super.importData(jComponent, transferable);
    }

    @Override
    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        return super.canImport(jComponent, dataFlavorArray);
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport transferSupport) {
        if (!transferSupport.isDrop()) {
            return super.canImport(transferSupport);
        }
        for (DataFlavor dataFlavor : transferSupport.getDataFlavors()) {
            if (dataFlavor.isFlavorTextType()) {
                return true;
            }
            if (!dataFlavor.isMimeTypeEqual(URL_LIST_MIME_TYPE)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport transferSupport) {
        Transferable transferable = transferSupport.getTransferable();
        logger.info("Trying to import:" + transferable);
        DataFlavor dataFlavor = null;
        try {
            dataFlavor = new DataFlavor(URL_LIST_MIME_TYPE);
        }
        catch (ClassNotFoundException classNotFoundException) {
            LogUtils.processException(logger, classNotFoundException);
        }
        this.urls = new LinkedList<URL>();
        try {
            block29: {
                if (dataFlavor != null && transferable.isDataFlavorSupported(dataFlavor)) {
                    try {
                        Object object = transferable.getTransferData(dataFlavor);
                        if (!(object instanceof URL)) break block29;
                        URL uRL = (URL)object;
                        if (this.pluginsManager.isSupported(uRL)) {
                            this.urls.add(uRL);
                            break block29;
                        }
                        try {
                            String string = URLDecoder.decode(uRL.toExternalForm(), "UTF-8");
                            this.urls.addAll(URLTransferHandler.textURIListToFileList(string, this.pluginsManager));
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            LogUtils.processException(logger, illegalArgumentException);
                        }
                    }
                    catch (UnsupportedFlavorException unsupportedFlavorException) {
                    }
                    catch (IOException iOException) {
                    }
                    catch (NullPointerException nullPointerException) {
                        LogUtils.processException(logger, nullPointerException);
                    }
                } else {
                    DataFlavor dataFlavor2 = null;
                    try {
                        dataFlavor2 = new DataFlavor("application/xhtml+xml;class=java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        LogUtils.processException(logger, classNotFoundException);
                    }
                    if (dataFlavor2 != null && transferable.isDataFlavorSupported(dataFlavor2)) {
                        String string = (String)transferable.getTransferData(dataFlavor2);
                        this.urls = URLTransferHandler.textURIListToFileList(string, this.pluginsManager);
                    } else {
                        DataFlavor dataFlavor3 = null;
                        try {
                            dataFlavor3 = new DataFlavor("text/html;class=java.lang.String");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            LogUtils.processException(logger, classNotFoundException);
                        }
                        if (dataFlavor3 != null && transferable.isDataFlavorSupported(dataFlavor3)) {
                            String string = (String)transferable.getTransferData(dataFlavor3);
                            if (!Pattern.compile("<a\\s", 10).matcher(string).find()) {
                                if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                                    string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                                    this.urls = URLTransferHandler.textURIListToFileList(string, this.pluginsManager);
                                } else {
                                    this.urls = URLTransferHandler.textURIListToFileList(string, this.pluginsManager);
                                }
                            } else {
                                this.urls = URLTransferHandler.textURIListToFileList(string, this.pluginsManager);
                            }
                        } else if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                            String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                            this.urls = URLTransferHandler.textURIListToFileList(string, this.pluginsManager);
                        }
                    }
                }
            }
            if (this.urls.isEmpty()) {
                logger.info("Importing drag and drop failed or unsupported.");
                this.doDropAction(new LinkedList<URL>());
                return false;
            }
            logger.info("Imported files " + Arrays.toString(this.urls.toArray()));
            this.doDropAction(this.urls);
            return true;
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            LogUtils.processException(logger, unsupportedFlavorException);
        }
        catch (IOException iOException) {
            LogUtils.processException(logger, iOException);
        }
        return false;
    }

    public List<URL> getUrls() {
        return this.urls;
    }
}

