/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.core.tasks;

import cz.vity.freerapid.core.tasks.CoreTask;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.RootPaneContainer;
import javax.swing.Timer;
import javax.swing.event.MouseInputAdapter;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationAction;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.Task;
import org.jdesktop.swingx.JXFrame;

class ScreenInputBlocker
extends Task.InputBlocker {
    private static final Logger logger = Logger.getLogger(ScreenInputBlocker.class.getName());
    private JDialog modalDialog = null;
    private boolean showWaitCursor = false;

    ScreenInputBlocker(Task task, Task.BlockingScope blockingScope, Object object, ApplicationAction applicationAction) {
        super(task, blockingScope, object, applicationAction);
    }

    private void setActionTargetBlocked(boolean bl) {
        Action action = (Action)this.getTarget();
        action.setEnabled(!bl);
    }

    private void setComponentTargetBlocked(boolean bl) {
        Component component = (Component)this.getTarget();
        component.setEnabled(!bl);
    }

    private void setScreenBlocked(boolean bl) {
        JXFrame jXFrame = (JXFrame)((SingleFrameApplication)Application.getInstance()).getMainFrame();
        jXFrame.setWaiting(bl);
    }

    private void blockingDialogComponents(Component component, List<Component> list) {
        String string = component.getName();
        if (string != null && string.startsWith("BlockingDialog")) {
            list.add(component);
        }
        if (component instanceof Container) {
            for (Component component2 : ((Container)component).getComponents()) {
                this.blockingDialogComponents(component2, list);
            }
        }
    }

    private List<Component> blockingDialogComponents(Component component) {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        this.blockingDialogComponents(component, arrayList);
        return arrayList;
    }

    private void injectBlockingDialogComponents(Component component) {
        ApplicationAction applicationAction;
        ResourceMap resourceMap = ((CoreTask)this.getTask()).getTaskResourceMap();
        if (resourceMap != null) {
            resourceMap.injectComponents(component);
        }
        if ((applicationAction = this.getAction()) != null) {
            ResourceMap resourceMap2 = applicationAction.getResourceMap();
            String string = applicationAction.getName();
            for (Component component2 : this.blockingDialogComponents(component)) {
                component2.setName(string + "." + component2.getName());
            }
            resourceMap2.injectComponents(component);
        }
    }

    private JDialog createBlockingDialog() {
        Object object;
        Component component;
        JOptionPane jOptionPane = new JOptionPane();
        if (this.getTask().getUserCanCancel()) {
            component = new JButton();
            component.setName("BlockingDialog.cancelButton");
            object = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ScreenInputBlocker.this.getTask().cancel(true);
                }
            };
            ((AbstractButton)component).addActionListener((ActionListener)object);
            jOptionPane.setOptions(new Object[]{component});
        } else {
            jOptionPane.setOptions(new Object[0]);
        }
        if (this.showWaitCursor) {
            jOptionPane.setCursor(Cursor.getPredefinedCursor(3));
        }
        component = (Component)this.getTarget();
        object = this.getTask().getTitle();
        Object object2 = object == null ? "BlockingDialog" : object;
        final JDialog jDialog = jOptionPane.createDialog(component, (String)object2);
        jDialog.setModal(true);
        jDialog.setName("BlockingDialog");
        jDialog.setDefaultCloseOperation(0);
        WindowAdapter windowAdapter = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (ScreenInputBlocker.this.getTask().getUserCanCancel()) {
                    ScreenInputBlocker.this.getTask().cancel(true);
                    jDialog.setVisible(false);
                }
            }
        };
        jDialog.addWindowListener(windowAdapter);
        jOptionPane.setName("BlockingDialog.optionPane");
        this.injectBlockingDialogComponents(jDialog);
        this.recreateOptionPaneMessage(jOptionPane);
        jDialog.pack();
        jDialog.setMinimumSize(new Dimension(150, 130));
        return jDialog;
    }

    private void recreateOptionPaneMessage(JOptionPane jOptionPane) {
        Object object = jOptionPane.getMessage();
        if (object instanceof String) {
            final JLabel jLabel = new JLabel((String)object);
            jLabel.setText("                                                                                                  \n\n\n\n\n");
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)jLabel, "Center");
            final JProgressBar jProgressBar = new JProgressBar();
            jProgressBar.setName("BlockingDialog.progressBar");
            jProgressBar.setIndeterminate(true);
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("progress".equals(propertyChangeEvent.getPropertyName())) {
                        jProgressBar.setIndeterminate(false);
                        jProgressBar.setValue((Integer)propertyChangeEvent.getNewValue());
                        ScreenInputBlocker.this.updateStatusBarString(jProgressBar);
                    } else if ("message".equals(propertyChangeEvent.getPropertyName())) {
                        jLabel.setText((String)propertyChangeEvent.getNewValue());
                    }
                }
            };
            this.getTask().addPropertyChangeListener(propertyChangeListener);
            jPanel.add((Component)jProgressBar, "South");
            this.injectBlockingDialogComponents(jPanel);
            jOptionPane.setMessage(jPanel);
        }
    }

    private void updateStatusBarString(JProgressBar jProgressBar) {
        if (!jProgressBar.isStringPainted()) {
            return;
        }
        String string = "progressBarStringFormat";
        if (jProgressBar.getClientProperty(string) == null) {
            jProgressBar.putClientProperty(string, jProgressBar.getString());
        }
        String string2 = (String)jProgressBar.getClientProperty(string);
        if (jProgressBar.getValue() <= 0) {
            jProgressBar.setString("");
        } else if (string2 == null) {
            jProgressBar.setString(null);
        } else {
            double d = (double)jProgressBar.getValue() / 100.0;
            long l = this.getTask().getExecutionDuration(TimeUnit.SECONDS);
            long l2 = l / 60L;
            long l3 = (long)(0.5 + (double)l / d) - l;
            long l4 = l3 / 60L;
            String string3 = String.format(string2, l2, l - l2 * 60L, l4, l3 - l4 * 60L);
            jProgressBar.setString(string3);
        }
    }

    private void showBusyGlassPane(boolean bl) {
        RootPaneContainer rootPaneContainer = null;
        for (Component component = (Component)this.getTarget(); component != null; component = component.getParent()) {
            if (!(component instanceof RootPaneContainer)) continue;
            rootPaneContainer = (RootPaneContainer)((Object)component);
            break;
        }
        if (rootPaneContainer != null) {
            String string = "OldGlassPane";
            if (bl) {
                BusyGlassPane busyGlassPane = new BusyGlassPane();
                InputVerifier inputVerifier = new InputVerifier(){

                    @Override
                    public boolean verify(JComponent jComponent) {
                        return !jComponent.isVisible();
                    }
                };
                busyGlassPane.setInputVerifier(inputVerifier);
                Component component = rootPaneContainer.getGlassPane();
                rootPaneContainer.getRootPane().putClientProperty(string, component);
                rootPaneContainer.setGlassPane(busyGlassPane);
                busyGlassPane.setVisible(true);
                busyGlassPane.revalidate();
            } else {
                Component component = (Component)rootPaneContainer.getRootPane().getClientProperty(string);
                if (!component.isVisible()) {
                    rootPaneContainer.getGlassPane().setVisible(false);
                }
                rootPaneContainer.setGlassPane(component);
            }
        }
    }

    private int blockingDialogDelay() {
        ResourceMap resourceMap;
        Integer n = null;
        String string = "BlockingDialogTimer.delay";
        ApplicationAction applicationAction = this.getAction();
        if (applicationAction != null) {
            resourceMap = applicationAction.getResourceMap();
            String string2 = applicationAction.getName();
            n = resourceMap.getInteger(string2 + "." + string);
        }
        resourceMap = ((CoreTask)this.getTask()).getTaskResourceMap();
        if (n == null && resourceMap != null) {
            n = resourceMap.getInteger(string);
        }
        return n == null ? 0 : n;
    }

    private void showBlockingDialog(boolean bl) {
        if (bl) {
            Object object;
            if (this.modalDialog != null) {
                object = String.format("unexpected InputBlocker state [%s] %s", bl, this);
                logger.warning((String)object);
                this.modalDialog.dispose();
            }
            this.modalDialog = this.createBlockingDialog();
            object = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (ScreenInputBlocker.this.modalDialog != null) {
                        ScreenInputBlocker.this.modalDialog.setVisible(true);
                    }
                }
            };
            Timer timer = new Timer(this.blockingDialogDelay(), (ActionListener)object);
            timer.setRepeats(false);
            timer.start();
        } else if (this.modalDialog != null) {
            this.modalDialog.dispose();
            this.modalDialog = null;
        } else {
            String string = String.format("unexpected InputBlocker state [%s] %s", bl, this);
            logger.warning(string);
        }
    }

    @Override
    protected void block() {
        switch (this.getScope()) {
            case ACTION: {
                this.setActionTargetBlocked(true);
                break;
            }
            case COMPONENT: {
                this.setComponentTargetBlocked(true);
                break;
            }
            case WINDOW: 
            case APPLICATION: {
                this.showBusyGlassPane(true);
                this.showBlockingDialog(true);
            }
        }
    }

    @Override
    public void unblock() {
        switch (this.getScope()) {
            case ACTION: {
                this.setActionTargetBlocked(false);
                break;
            }
            case COMPONENT: {
                this.setComponentTargetBlocked(false);
                break;
            }
            case WINDOW: 
            case APPLICATION: {
                this.showBusyGlassPane(false);
                this.showBlockingDialog(false);
            }
        }
    }

    public void setShowWaitCursor(boolean bl) {
        this.showWaitCursor = bl;
    }

    private static class BusyGlassPane
    extends JPanel {
        BusyGlassPane() {
            super(null, false);
            this.setVisible(false);
            this.setOpaque(false);
            this.setCursor(Cursor.getPredefinedCursor(3));
            MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){};
            this.addMouseMotionListener(mouseInputAdapter);
            this.addMouseListener(mouseInputAdapter);
        }
    }
}

