/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.core.tasks;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.MainApp;
import cz.vity.freerapid.core.tasks.CloseInTimeTask;
import cz.vity.freerapid.core.tasks.CoreTask;
import cz.vity.freerapid.core.tasks.CountingOutputStream;
import cz.vity.freerapid.core.tasks.DownloadTaskError;
import cz.vity.freerapid.core.tasks.MoveFileTask;
import cz.vity.freerapid.core.tasks.SpeedRegulator;
import cz.vity.freerapid.gui.FRDUtils;
import cz.vity.freerapid.gui.managers.TaskServiceManager;
import cz.vity.freerapid.model.DownloadFile;
import cz.vity.freerapid.plugins.exceptions.CaptchaEntryInputMismatchException;
import cz.vity.freerapid.plugins.exceptions.ErrorDuringDownloadingException;
import cz.vity.freerapid.plugins.exceptions.InvalidURLOrServiceProblemException;
import cz.vity.freerapid.plugins.exceptions.NotEnoughSpaceException;
import cz.vity.freerapid.plugins.exceptions.NotRecoverableDownloadException;
import cz.vity.freerapid.plugins.exceptions.PluginImplementationException;
import cz.vity.freerapid.plugins.exceptions.URLNotAvailableAnymoreException;
import cz.vity.freerapid.plugins.exceptions.YouHaveToWaitException;
import cz.vity.freerapid.plugins.webclient.DownloadState;
import cz.vity.freerapid.plugins.webclient.FileState;
import cz.vity.freerapid.plugins.webclient.interfaces.HttpDownloadClient;
import cz.vity.freerapid.plugins.webclient.interfaces.HttpFileDownloadTask;
import cz.vity.freerapid.plugins.webclient.interfaces.ShareDownloadService;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.utilities.FileUtils;
import cz.vity.freerapid.utilities.LogUtils;
import cz.vity.freerapid.utilities.Sound;
import java.awt.EventQueue;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;
import java.util.Timer;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.jdesktop.application.Application;
import org.jdesktop.application.TaskEvent;
import org.jdesktop.application.TaskListener;

public class DownloadTask
extends CoreTask<Void, Long>
implements HttpFileDownloadTask {
    private static final Logger logger = Logger.getLogger(DownloadTask.class.getName());
    protected HttpDownloadClient client;
    protected DownloadFile downloadFile;
    protected ShareDownloadService service;
    private Integer sleep = 0;
    private static Timer timer = new Timer();
    private DownloadTaskError serviceError;
    private int youHaveToSleepSecondsTime = 0;
    private static final int INPUT_BUFFER_SIZE = 1024;
    private static final int OUTPUT_FILE_BUFFER_SIZE = 600000;
    private volatile boolean connectionTimeOut;
    private int fileAlreadyExists;
    private volatile byte[] buffer;
    private boolean useRelativeStoreFileIfPossible = true;

    public DownloadTask(Application application) {
        super(application);
        this.init();
    }

    public DownloadTask(Application application, HttpDownloadClient httpDownloadClient, DownloadFile downloadFile, ShareDownloadService shareDownloadService) {
        super(application);
        this.client = httpDownloadClient;
        this.downloadFile = downloadFile;
        this.service = shareDownloadService;
        this.init();
        downloadFile.setConnectionSettings(httpDownloadClient.getSettings());
    }

    protected void init() {
        this.serviceError = DownloadTaskError.NO_ERROR;
        this.setInputBlocker(null);
        this.setUserCanCancel(true);
        this.youHaveToSleepSecondsTime = 0;
        this.connectionTimeOut = false;
        this.fileAlreadyExists = -2;
    }

    @Override
    protected Void doInBackground() throws Exception {
        int n;
        this.initDownloadThread();
        if (AppPrefs.getProperty("blindMode", false)) {
            Sound.playSound(this.getContext().getResourceMap().getString("fileAdded", new Object[0]));
        }
        if (this.downloadFile.getDownloaded() < 0L) {
            this.downloadFile.setDownloaded(0L);
        }
        if ((n = AppPrefs.getProperty("firstSleepTime", 4)) > 0) {
            this.sleep(n);
        }
        this.downloadFile.setState(DownloadState.GETTING);
        try {
            this.service.run(this);
        }
        catch (IllegalStateException illegalStateException) {
            throw new Exception(illegalStateException);
        }
        this.service = null;
        return null;
    }

    protected void initDownloadThread() {
        this.client.getHTTPClient().setHttpConnectionManager((HttpConnectionManager)new SimpleHttpConnectionManager());
        int n = timer.purge();
        if (n > 0) {
            logger.info("Purged timers " + n);
        }
        this.client.getHTTPClient().getHttpConnectionManager().closeIdleConnections(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CountingOutputStream getFileOutputStream(File file, long l, long l2) throws NotEnoughSpaceException, IOException {
        OutputStream outputStream;
        long l3 = file.getUsableSpace();
        logger.info("Free space on disk: " + l3);
        int n = AppPrefs.getProperty("minDiskSpaceMB", 30);
        if (l3 < l + (long)(n * 1024) * 1024L) {
            throw new NotEnoughSpaceException();
        }
        if (AppPrefs.getProperty("preCreateFile", false)) {
            Class<DownloadTask> clazz = DownloadTask.class;
            synchronized (DownloadTask.class) {
                if (this.isTerminated()) {
                    // ** MonitorExit[var10_6] (shouldn't be in output)
                    return null;
                }
                outputStream = FileUtils.createEmptyFile(file, l, l2, this);
                if (this.isTerminated()) {
                    // ** MonitorExit[var10_6] (shouldn't be in output)
                    return null;
                }
                // ** MonitorExit[var10_6] (shouldn't be in output)
            }
        } else if (l2 == 0L) {
            outputStream = new FileOutputStream(file);
        } else {
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            randomAccessFile.seek(l2);
            outputStream = new FileOutputStream(randomAccessFile.getFD());
        }
        return new CountingOutputStream(outputStream);
    }

    protected void initBackground() {
    }

    @Override
    public boolean isTerminated() {
        return this.isCancelled() || Thread.currentThread().isInterrupted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void saveToFile(InputStream inputStream) throws Exception {
        OutputStream outputStream;
        block29: {
            long l;
            if (inputStream == null) {
                throw new NullPointerException("Input stream for saving cannot be null");
            }
            this.downloadFile.setFileState(FileState.CHECKED_AND_EXISTING);
            boolean bl = this.useTemporaryFiles();
            this.setBuffer(new byte[AppPrefs.getProperty("inputBufferSize", 1024)]);
            String string = this.downloadFile.getFileName();
            File file = this.downloadFile.getOutputFile();
            if (bl) {
                this.fileAlreadyExists = this.checkExists();
                if (this.fileAlreadyExists == 2) {
                    this.cancel(true);
                    return;
                }
            }
            SpeedRegulator speedRegulator = ((MainApp)this.getApplication()).getManagerDirector().getSpeedRegulator();
            File file2 = this.downloadFile.getSaveToDirectory();
            CountingOutputStream countingOutputStream = null;
            outputStream = null;
            try {
                if (!file2.exists()) {
                    file2.mkdirs();
                }
                File file3 = this.downloadFile.getStoreFile();
                if (this.downloadFile.getStoreFile() == null || !this.downloadFile.getStoreFile().exists()) {
                    File file4 = file3 = bl ? File.createTempFile(string + ".", ".part", file2) : file;
                    if (!System.getProperties().containsKey("exePath")) {
                        this.downloadFile.setStoreFile(this.useRelativeStoreFileIfPossible ? FRDUtils.getAbsRelPath(file3) : file3);
                    } else {
                        this.downloadFile.setStoreFile(file3);
                    }
                    this.downloadFile.setDownloaded(0L);
                }
                long l2 = this.downloadFile.getFileSize();
                Long l3 = (Long)this.downloadFile.getProperties().get("startPosition");
                if (l3 == null) {
                    l = 0L;
                } else {
                    l = l3;
                    this.downloadFile.getProperties().remove("startPosition");
                }
                if (AppPrefs.getProperty("blindMode", false)) {
                    Sound.playSound(this.getContext().getResourceMap().getString("startDownloadWav", new Object[0]));
                }
                try {
                    countingOutputStream = this.getFileOutputStream(file3, l2, l);
                    outputStream = this.getBufferedOutputStream(countingOutputStream);
                    if (this.isTerminated()) {
                        this.closeFileStream(outputStream);
                        this.checkDeleteTempFile();
                        this.closeFileStream(outputStream);
                        this.checkDeleteTempFile();
                        if (!this.wasInterrupted(this.downloadFile.getStoreFile()) && countingOutputStream != null) {
                            this.downloadFile.setRealDownload(l + countingOutputStream.count);
                            this.downloadFile.setDownloaded(this.downloadFile.getRealDownload());
                        }
                        this.closeFileStream(outputStream);
                        this.checkDeleteTempFile();
                        return;
                    }
                }
                catch (Exception exception) {
                    try {
                        throw exception;
                        catch (Throwable throwable) {
                            throw new IOException("ErrorDuringDownload", throwable);
                        }
                    }
                    catch (Throwable throwable) {
                        this.closeFileStream(outputStream);
                        this.checkDeleteTempFile();
                        if (this.wasInterrupted(this.downloadFile.getStoreFile())) throw throwable;
                        if (countingOutputStream == null) throw throwable;
                        this.downloadFile.setRealDownload(l + countingOutputStream.count);
                        this.downloadFile.setDownloaded(this.downloadFile.getRealDownload());
                        throw throwable;
                    }
                }
            }
            catch (Throwable throwable) {
                this.closeFileStream(outputStream);
                this.checkDeleteTempFile();
                throw throwable;
            }
            {
                int n;
                long l4 = 0L;
                this.downloadFile.setState(DownloadState.DOWNLOADING);
                Long l5 = (Long)this.downloadFile.getProperties().get("supposeToDownload");
                if (l5 == null) {
                    l5 = this.downloadFile.getFileSize();
                } else {
                    this.downloadFile.getProperties().remove("supposeToDownload");
                }
                logger.info("starting download from position " + l);
                this.downloadFile.setDownloaded(l);
                this.downloadFile.setRealDownload(this.downloadFile.getDownloaded());
                speedRegulator.addDownloading(this.downloadFile, this);
                byte[] byArray = this.getBuffer();
                while ((n = inputStream.read(byArray)) != -1) {
                    outputStream.write(byArray, 0, n);
                    l4 += (long)n;
                    this.downloadFile.setRealDownload(l + countingOutputStream.count);
                    if (this.isTerminated()) {
                        outputStream.flush();
                        break;
                    }
                    boolean bl2 = speedRegulator.takeTokens(this.downloadFile, n);
                    if (!bl2 && l4 != l5) {
                        Thread.sleep(1000L);
                    }
                    byArray = this.buffer;
                }
                if (!this.isTerminated()) {
                    if (l4 != l5) {
                        logger.info("File size does not match - expected " + l5 + " but " + l4 + " was downloaded");
                        throw new IOException("ErrorDuringDownload");
                    }
                } else {
                    logger.info("File downloading was terminated");
                }
                this.closeFileStream(outputStream);
                this.checkDeleteTempFile();
                if (this.wasInterrupted(this.downloadFile.getStoreFile()) || countingOutputStream == null) break block29;
                this.downloadFile.setRealDownload(l + countingOutputStream.count);
                this.downloadFile.setDownloaded(this.downloadFile.getRealDownload());
            }
        }
        this.closeFileStream(outputStream);
        this.checkDeleteTempFile();
    }

    private OutputStream getBufferedOutputStream(OutputStream outputStream) {
        return new BufferedOutputStream(outputStream, AppPrefs.getProperty("outputFileBufferSize", 600000));
    }

    protected boolean useTemporaryFiles() {
        return AppPrefs.getProperty("useTemporaryFiles", true);
    }

    private void closeFileStream(OutputStream outputStream) {
        try {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        catch (IOException iOException) {
            logger.log(Level.SEVERE, "Error closing file stream", iOException);
        }
    }

    private void checkDeleteTempFile() {
        File file = this.downloadFile.getStoreFile();
        if (this.wasInterrupted(file)) {
            logger.info("Deleting partial file " + file);
            boolean bl = file.delete();
            if (!bl) {
                logger.info("Deleting partial file failed (" + file + ")");
            } else {
                this.downloadFile.setStoreFile(null);
            }
        }
        if (this.downloadFile.getState() == DownloadState.CANCELLED) {
            this.downloadFile.setDownloaded(0L);
        }
    }

    private boolean wasInterrupted(File file) {
        return this.isTerminated() && file != null && file.exists() && (this.downloadFile.getState() == DownloadState.CANCELLED || this.downloadFile.getState() == DownloadState.DELETED);
    }

    @Override
    protected void cancelled() {
        if (this.downloadFile != null) {
            if (this.connectionTimeOut) {
                this.downloadFile.setState(DownloadState.ERROR);
                this.setServiceError(DownloadTaskError.CONNECTION_TIMEOUT);
            } else if (this.downloadFile.getState() != DownloadState.PAUSED) {
                this.downloadFile.setState(DownloadState.CANCELLED);
            }
        }
    }

    public void setConnectionTimeOut(boolean bl) {
        this.connectionTimeOut = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setSleep(int n) {
        Integer n2;
        Integer n3;
        DownloadTask downloadTask = this;
        synchronized (downloadTask) {
            n3 = this.sleep;
            n2 = this.sleep = Integer.valueOf(n);
        }
        this.firePropertyChange("sleep", n3, n2);
    }

    @Override
    protected void failed(Throwable throwable) {
        Application application;
        boolean bl;
        if (throwable instanceof IllegalArgumentException) {
            throwable = new PluginImplementationException(this.service.getName() + " " + this.downloadFile.getFileUrl().toExternalForm(), throwable);
        } else if (!(throwable instanceof ErrorDuringDownloadingException)) {
            super.failed(throwable);
            LogUtils.processException(logger, throwable);
        }
        this.error(throwable);
        if (throwable instanceof PluginImplementationException) {
            logger.warning("Content from the last request\n" + this.client.getContentAsString());
            LogUtils.processException(logger, throwable);
        }
        if (throwable instanceof NotEnoughSpaceException) {
            this.downloadFile.setErrorMessage(this.getResourceMap().getString("NotEnoughSpaceException", this.downloadFile.getStoreFile().getParentFile()));
            this.setServiceError(DownloadTaskError.NOT_RECOVERABLE_DOWNLOAD_ERROR);
        } else if (throwable instanceof UnknownHostException) {
            this.downloadFile.setErrorMessage(this.getResourceMap().getString("UnknownHostError", new Object[0]));
        } else if (throwable instanceof NotRecoverableDownloadException) {
            this.setServiceError(DownloadTaskError.NOT_RECOVERABLE_DOWNLOAD_ERROR);
        } else if (throwable instanceof YouHaveToWaitException) {
            YouHaveToWaitException youHaveToWaitException = (YouHaveToWaitException)throwable;
            this.youHaveToSleepSecondsTime = youHaveToWaitException.getHowManySecondsToWait();
            this.setServiceError(DownloadTaskError.YOU_HAVE_TO_WAIT_ERROR);
        }
        boolean bl2 = bl = throwable instanceof NoRouteToHostException || throwable instanceof ConnectException || throwable instanceof UnknownHostException;
        if (AppPrefs.getProperty("testFiles", true)) {
            this.updateFileState(throwable, bl);
        }
        if (AppPrefs.getProperty("disableConnectionOnException", false) && bl) {
            this.setServiceError(DownloadTaskError.NO_ROUTE_TO_HOST);
        }
        if (this.getServiceError() == DownloadTaskError.NOT_RECOVERABLE_DOWNLOAD_ERROR) {
            this.downloadFile.setErrorAttemptsCount(0);
            this.downloadFile.setTimeToQueued(-1);
            this.downloadFile.setTimeToQueuedMax(-1);
        }
        if (this.isAllComplete(application = this.getApplication())) {
            this.checkShutDown(application);
        }
    }

    protected void updateFileState(Throwable throwable, boolean bl) {
        if (throwable instanceof URLNotAvailableAnymoreException || throwable instanceof InvalidURLOrServiceProblemException) {
            this.downloadFile.setFileState(FileState.FILE_NOT_FOUND);
        } else if (!bl && !(throwable instanceof CaptchaEntryInputMismatchException) && this.serviceError == DownloadTaskError.NOT_RECOVERABLE_DOWNLOAD_ERROR) {
            this.downloadFile.setFileState(FileState.ERROR_GETTING_INFO);
        }
    }

    protected void error(Throwable throwable) {
        this.setFileErrorMessage(throwable);
        this.setServiceError(DownloadTaskError.GENERAL_ERROR);
        if (!(throwable instanceof YouHaveToWaitException)) {
            if (AppPrefs.getProperty("playSoundsFailed", true)) {
                Sound.playSound(this.getContext().getResourceMap().getString("errorWav", new Object[0]));
            }
            this.downloadFile.setState(DownloadState.ERROR);
        } else {
            this.downloadFile.setState(DownloadState.SLEEPING);
        }
    }

    protected void setFileErrorMessage(Throwable throwable) {
        this.downloadFile.setErrorMessage(Swinger.getMessageFromException(this.getResourceMap(), throwable));
    }

    @Override
    protected void interrupted(InterruptedException interruptedException) {
        this.cancelled();
    }

    @Override
    protected void succeeded(Void void_) {
        super.succeeded(void_);
        boolean bl = false;
        boolean bl2 = false;
        File file = this.downloadFile.getStoreFile();
        File file2 = this.downloadFile.getOutputFile();
        if (file != null && file.exists()) {
            if (file.equals(file2)) {
                this.setCompleted();
                return;
            }
            if (file2.exists()) {
                int n = 0;
                try {
                    n = this.fileAlreadyExistsProperty();
                }
                catch (InvocationTargetException invocationTargetException) {
                    LogUtils.processException(logger, invocationTargetException);
                }
                catch (InterruptedException interruptedException) {
                    LogUtils.processException(logger, interruptedException);
                }
                switch (n) {
                    case 1: {
                        bl = true;
                        bl2 = true;
                        break;
                    }
                    case 0: {
                        bl = true;
                    }
                }
            } else {
                bl = true;
            }
        }
        if (bl) {
            this.runMoveFileTask(bl2);
        } else {
            this.setCompleted();
            if (file != null && file.exists() && file.delete()) {
                this.downloadFile.setStoreFile(null);
            }
        }
    }

    protected int checkExists() throws InvocationTargetException, InterruptedException {
        if (!this.downloadFile.getOutputFile().exists()) {
            return -2;
        }
        return this.fileAlreadyExistsProperty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int fileAlreadyExistsProperty() throws InvocationTargetException, InterruptedException {
        if (this.fileAlreadyExists != -2) {
            return this.fileAlreadyExists;
        }
        final int[] nArray = new int[]{AppPrefs.getProperty("whatToDoIfFileAlreadyExists", 3)};
        if (nArray[0] != 3) return nArray[0];
        Class<DownloadTask> clazz = DownloadTask.class;
        synchronized (DownloadTask.class) {
            if (EventQueue.isDispatchThread()) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return this.showFileAlreadyExistsDialog();
            }
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    nArray[0] = DownloadTask.this.showFileAlreadyExistsDialog();
                }
            });
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return nArray[0];
        }
    }

    private int showFileAlreadyExistsDialog() {
        return Swinger.showOptionDialog(this.getResourceMap(), 3, "errorMessage", "fileAlreadyExists", new String[]{"renameFile", "overWriteFile", "skipFile"}, this.downloadFile.getOutputFile());
    }

    private void setCompleted() {
        this.downloadFile.setCompleteTaskDuration(this.getExecutionDuration(TimeUnit.SECONDS));
        if (this.downloadFile.getState() != DownloadState.QUEUED) {
            this.downloadFile.setState(DownloadState.COMPLETED);
            if (AppPrefs.getProperty("blindMode", false)) {
                Sound.playSound(this.getContext().getResourceMap().getString("doneWav", new Object[0]));
            }
        }
    }

    private void runMoveFileTask(boolean bl) {
        MoveFileTask moveFileTask = new MoveFileTask(this.getApplication(), this.downloadFile.getStoreFile(), this.downloadFile.getOutputFile(), true, bl, this.downloadFile);
        moveFileTask.addTaskListener(new TaskListener.Adapter<Void, Void>(){
            public boolean succeeded = false;

            @Override
            public void finished(TaskEvent<Void> taskEvent) {
                super.succeeded(taskEvent);
                if (this.succeeded) {
                    DownloadTask.this.doAllSucceededActions();
                }
            }

            @Override
            public void succeeded(TaskEvent<Void> taskEvent) {
                this.succeeded = true;
                DownloadTask.this.setCompleted();
            }

            @Override
            public void failed(TaskEvent<Throwable> taskEvent) {
                DownloadTask.this.downloadFile.setState(DownloadState.ERROR);
                DownloadTask.this.downloadFile.setErrorMessage(DownloadTask.this.getResourceMap().getString("transferFailed", taskEvent.getValue().getMessage()));
                Sound.playSound(DownloadTask.this.getContext().getResourceMap().getString("errorWav", new Object[0]));
            }

            @Override
            public void cancelled(TaskEvent<Void> taskEvent) {
                DownloadTask.this.downloadFile.setState(DownloadState.CANCELLED);
            }

            @Override
            public void interrupted(TaskEvent<InterruptedException> taskEvent) {
                DownloadTask.this.downloadFile.setState(DownloadState.CANCELLED);
            }
        });
        MainApp mainApp = (MainApp)this.getApplication();
        TaskServiceManager taskServiceManager = mainApp.getManagerDirector().getTaskServiceManager();
        taskServiceManager.getTaskService("moveFile").execute(moveFileTask);
    }

    private void doAllSucceededActions() {
        Application application = this.getApplication();
        boolean bl = this.isAllComplete(application);
        if (bl) {
            boolean bl2 = AppPrefs.getProperty("playSoundOK", true);
            if (bl2) {
                Sound.playSound(this.getContext().getResourceMap().getString("doneWav", new Object[0]));
            }
            this.checkShutDown(application);
        }
    }

    private void checkShutDown(Application application) {
        if (AppPrefs.getProperty("autoshutdown", 0) != 0) {
            application.getContext().getTaskService().execute(new CloseInTimeTask(application));
        }
    }

    private boolean isAllComplete(Application application) {
        return ((MainApp)application).getManagerDirector().getDataManager().checkComplete();
    }

    @Override
    public void sleep(int n) throws InterruptedException {
        this.setSleep(0);
        this.downloadFile.setState(DownloadState.WAITING);
        this.downloadFile.setTimeToQueuedMax(n);
        logger.info("Going to sleep on " + n + " seconds");
        for (int i = n; i > 0 && !this.isTerminated(); --i) {
            this.setSleep(i);
            Thread.sleep(1000L);
        }
        if (this.isTerminated()) {
            throw new InterruptedException();
        }
    }

    @Override
    public DownloadFile getDownloadFile() {
        return this.downloadFile;
    }

    @Override
    public HttpDownloadClient getClient() {
        return this.client;
    }

    public DownloadTaskError getServiceError() {
        return this.serviceError;
    }

    private void setServiceError(DownloadTaskError downloadTaskError) {
        this.serviceError = downloadTaskError;
    }

    public int getYouHaveToSleepSecondsTime() {
        return this.youHaveToSleepSecondsTime;
    }

    protected void setDownloadFile(DownloadFile downloadFile) {
        this.downloadFile = downloadFile;
    }

    void setBuffer(byte[] byArray) {
        assert (byArray.length != 0);
        this.buffer = byArray;
    }

    byte[] getBuffer() {
        return this.buffer;
    }

    protected void setUseRelativeStoreFileIfPossible(boolean bl) {
        this.useRelativeStoreFileIfPossible = bl;
    }
}

