/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.core.tasks;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.MainApp;
import cz.vity.freerapid.core.tasks.CoreTask;
import cz.vity.freerapid.core.tasks.ScreenInputBlocker;
import cz.vity.freerapid.gui.managers.DataManager;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.utilities.LogUtils;
import cz.vity.freerapid.utilities.os.OSCommand;
import cz.vity.freerapid.utilities.os.SystemCommander;
import cz.vity.freerapid.utilities.os.SystemCommanderFactory;
import java.util.logging.Logger;
import org.jdesktop.application.Application;
import org.jdesktop.application.Task;

public final class CloseInTimeTask
extends CoreTask<Void, Void> {
    private static final Logger logger = Logger.getLogger(CloseInTimeTask.class.getName());
    private DataManager dataManager;

    public CloseInTimeTask(Application application) {
        super(application);
        MainApp mainApp = (MainApp)application;
        this.setUserCanCancel(true);
        this.setInputBlocker(new ScreenInputBlocker(this, Task.BlockingScope.APPLICATION, mainApp.getMainFrame(), null));
        Swinger.bringToFront(mainApp.getMainFrame(), true);
        this.dataManager = mainApp.getManagerDirector().getDataManager();
    }

    @Override
    protected Void doInBackground() throws Exception {
        int n;
        for (int i = n = AppPrefs.getProperty("closeApplicationConfirmTime", 30); i > 0 && !this.isCancelled(); --i) {
            this.message(i > 1 ? "closeAppMessageN" : "closeAppMessage1", i);
            Thread.sleep(1000L);
            if (this.dataManager.checkComplete()) continue;
            throw new InterruptedException();
        }
        return null;
    }

    @Override
    protected void succeeded(Void void_) {
        int n = AppPrefs.getProperty("autoshutdown", 0);
        if (n == 1) {
            this.getApplication().exit();
            return;
        }
        if (n == 0) {
            return;
        }
        SystemCommander systemCommander = SystemCommanderFactory.getInstance().getSystemCommanderInstance(this.getContext());
        boolean bl = AppPrefs.getProperty("autoshutdownForce", true);
        boolean bl2 = AppPrefs.getProperty("autoshutdownDisabledWhenExecuted", true);
        if (bl2) {
            AppPrefs.storeProperty("autoshutdown", 0);
        }
        boolean bl3 = true;
        switch (n) {
            case 5: {
                bl3 = systemCommander.shutDown(OSCommand.HIBERNATE, bl);
                break;
            }
            case 3: {
                bl3 = systemCommander.shutDown(OSCommand.REBOOT, bl);
                break;
            }
            case 4: {
                bl3 = systemCommander.shutDown(OSCommand.SHUTDOWN, bl);
                break;
            }
            case 2: {
                bl3 = systemCommander.shutDown(OSCommand.STANDBY, bl);
                break;
            }
        }
        if (!bl3) {
            Swinger.showErrorMessage(this.getResourceMap(), "shutdownActionFailed", new Object[0]);
        } else if (n == 4) {
            this.getApplication().exit();
        }
    }

    @Override
    protected void failed(Throwable throwable) {
        if (!(throwable instanceof InterruptedException)) {
            super.failed(throwable);
            LogUtils.processException(logger, throwable);
        }
    }

    @Override
    protected void cancelled() {
        super.cancelled();
        AppPrefs.storeProperty("autoshutdown", 0);
    }

    public void sleep(int n) throws InterruptedException {
        logger.info("Going to sleep on " + n + " seconds");
    }
}

