/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.core;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.OneInstanceServer;
import cz.vity.freerapid.utilities.LogUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Collection;
import java.util.EventObject;
import java.util.logging.Logger;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationContext;

final class OneInstanceClient {
    private static final Logger logger = Logger.getLogger(OneInstanceClient.class.getName());

    private OneInstanceClient() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkInstance(Collection<String> collection, AppPrefs appPrefs, ApplicationContext applicationContext) {
        if (!AppPrefs.getProperty("oneinstance", true)) {
            return false;
        }
        Socket socket = null;
        try {
            logger.info("Testing existing instance");
            String string = AppPrefs.getProperty("oneInstanceServerPort", null);
            if (string != null) {
                block24: {
                    socket = new Socket("localhost", Integer.parseInt(string));
                    if (collection != null && !collection.isEmpty()) {
                        OutputStream outputStream = null;
                        try {
                            outputStream = socket.getOutputStream();
                            if (outputStream != null) {
                                for (String string2 : collection) {
                                    outputStream.write(string2.getBytes());
                                    outputStream.write(10);
                                }
                                outputStream.close();
                            }
                        }
                        catch (IOException iOException) {
                            LogUtils.processException(logger, iOException);
                            if (outputStream == null) break block24;
                            try {
                                outputStream.close();
                            }
                            catch (Exception exception) {
                                LogUtils.processException(logger, exception);
                            }
                        }
                    }
                }
                logger.info("Application is already running. Exiting");
                boolean bl = true;
                return bl;
            }
            logger.info("No other instance is running - first start");
            OneInstanceClient.oneInstanceServerStart(appPrefs, applicationContext);
        }
        catch (IOException iOException) {
            logger.info("No other instance is running.");
            OneInstanceClient.oneInstanceServerStart(appPrefs, applicationContext);
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    LogUtils.processException(logger, iOException);
                }
            }
        }
        return false;
    }

    private static void oneInstanceServerStart(AppPrefs appPrefs, ApplicationContext applicationContext) {
        final OneInstanceServer oneInstanceServer = new OneInstanceServer(appPrefs);
        oneInstanceServer.start();
        applicationContext.getApplication().addExitListener(new Application.ExitListener(){

            @Override
            public boolean canExit(EventObject eventObject) {
                return true;
            }

            @Override
            public void willExit(EventObject eventObject) {
                ServerSocket serverSocket = oneInstanceServer.getServerSocket();
                if (serverSocket != null) {
                    try {
                        serverSocket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        });
    }
}

