/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli2.validation;

import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.cli2.resource.ResourceHelper;
import org.apache.commons.cli2.validation.InvalidArgumentException;
import org.apache.commons.cli2.validation.Validator;

public class NumberValidator
implements Validator {
    private NumberFormat format;
    private Number minimum = null;
    private Number maximum = null;

    public NumberValidator(NumberFormat format) {
        this.setFormat(format);
    }

    public static NumberValidator getCurrencyInstance() {
        return new NumberValidator(NumberFormat.getCurrencyInstance());
    }

    public static NumberValidator getIntegerInstance() {
        NumberFormat format = NumberFormat.getNumberInstance();
        format.setParseIntegerOnly(true);
        return new NumberValidator(format);
    }

    public static NumberValidator getPercentInstance() {
        return new NumberValidator(NumberFormat.getPercentInstance());
    }

    public static NumberValidator getNumberInstance() {
        return new NumberValidator(NumberFormat.getNumberInstance());
    }

    @Override
    public void validate(List values) throws InvalidArgumentException {
        ListIterator<Number> i = values.listIterator();
        while (i.hasNext()) {
            String value = (String)i.next();
            ParsePosition pp = new ParsePosition(0);
            Number number = this.format.parse(value, pp);
            if (pp.getIndex() < value.length()) {
                throw new InvalidArgumentException(value);
            }
            if (this.minimum != null && number.doubleValue() < this.minimum.doubleValue() || this.maximum != null && number.doubleValue() > this.maximum.doubleValue()) {
                throw new InvalidArgumentException(ResourceHelper.getResourceHelper().getMessage("NumberValidator.number.OutOfRange", new Object[]{value}));
            }
            i.set(number);
        }
    }

    public NumberFormat getFormat() {
        return this.format;
    }

    protected void setFormat(NumberFormat format) {
        this.format = format;
    }

    public Number getMaximum() {
        return this.maximum;
    }

    public void setMaximum(Number maximum) {
        this.maximum = maximum;
    }

    public Number getMinimum() {
        return this.minimum;
    }

    public void setMinimum(Number minimum) {
        this.minimum = minimum;
    }
}

