/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.acryl;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseInternalFrameTitlePane;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.acryl.AcrylLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.LayoutManager;
import javax.swing.Icon;
import javax.swing.JInternalFrame;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;

public class AcrylInternalFrameTitlePane
extends BaseInternalFrameTitlePane {
    public AcrylInternalFrameTitlePane(JInternalFrame jInternalFrame) {
        super(jInternalFrame);
    }

    protected LayoutManager createLayout() {
        return new BaseTitlePaneLayout();
    }

    protected int getHorSpacing() {
        return 1;
    }

    protected int getVerSpacing() {
        return 3;
    }

    public void paintBorder(Graphics graphics) {
        if (this.isActive()) {
            graphics.setColor(AcrylLookAndFeel.getWindowBorderColor());
        } else {
            graphics.setColor(AcrylLookAndFeel.getWindowInactiveBorderColor());
        }
        graphics.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
    }

    public void paintText(Graphics graphics, int n, int n2, String string) {
        if (this.isActive()) {
            Color color = ColorHelper.darker(AcrylLookAndFeel.getWindowTitleColorDark(), 30.0);
            graphics.setColor(color);
            JTattooUtilities.drawString(this.frame, graphics, string, n - 1, n2 - 1);
            JTattooUtilities.drawString(this.frame, graphics, string, n - 1, n2 + 1);
            JTattooUtilities.drawString(this.frame, graphics, string, n + 1, n2 - 1);
            JTattooUtilities.drawString(this.frame, graphics, string, n + 1, n2 + 1);
            graphics.setColor(AbstractLookAndFeel.getWindowTitleForegroundColor());
        } else {
            graphics.setColor(AbstractLookAndFeel.getWindowInactiveTitleForegroundColor());
        }
        JTattooUtilities.drawString(this.frame, graphics, string, n, n2);
    }

    class BaseTitlePaneLayout
    extends BasicInternalFrameTitlePane.TitlePaneLayout {
        BaseTitlePaneLayout() {
            super(AcrylInternalFrameTitlePane.this);
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            return this.minimumLayoutSize(container);
        }

        public Dimension minimumLayoutSize(Container container) {
            int n;
            int n2;
            int n3 = 30;
            if (AcrylInternalFrameTitlePane.this.frame.isClosable()) {
                n3 += 21;
            }
            if (AcrylInternalFrameTitlePane.this.frame.isMaximizable()) {
                n3 += 16 + (AcrylInternalFrameTitlePane.this.frame.isClosable() ? 10 : 4);
            }
            if (AcrylInternalFrameTitlePane.this.frame.isIconifiable()) {
                n3 += 16 + (AcrylInternalFrameTitlePane.this.frame.isMaximizable() ? 2 : (AcrylInternalFrameTitlePane.this.frame.isClosable() ? 10 : 4));
            }
            FontMetrics fontMetrics = AcrylInternalFrameTitlePane.this.getFontMetrics(AcrylInternalFrameTitlePane.this.getFont());
            String string = AcrylInternalFrameTitlePane.this.frame.getTitle();
            int n4 = string != null ? fontMetrics.stringWidth(string) : 0;
            int n5 = n2 = string != null ? string.length() : 0;
            n3 = n2 > 2 ? (n3 += n4 < (n = fontMetrics.stringWidth(AcrylInternalFrameTitlePane.this.frame.getTitle().substring(0, 2) + "...")) ? n4 : n) : (n3 += n4);
            n = AcrylInternalFrameTitlePane.this.paletteTitleHeight;
            if (!AcrylInternalFrameTitlePane.this.isPalette) {
                int n6 = fontMetrics.getHeight() + 7;
                Icon icon = AcrylInternalFrameTitlePane.this.frame.getFrameIcon();
                int n7 = 0;
                if (icon != null) {
                    n7 = Math.min(icon.getIconHeight(), 18);
                }
                n = Math.max(n6, n7 += 5);
            }
            return new Dimension(n3, n);
        }

        public void layoutContainer(Container container) {
            boolean bl = JTattooUtilities.isLeftToRight(AcrylInternalFrameTitlePane.this.frame);
            int n = AcrylInternalFrameTitlePane.this.getHorSpacing();
            int n2 = AcrylInternalFrameTitlePane.this.getWidth();
            int n3 = AcrylInternalFrameTitlePane.this.getHeight();
            int n4 = n3 - AcrylInternalFrameTitlePane.this.getVerSpacing();
            int n5 = n4 + 10;
            int n6 = bl ? n2 - n : 0;
            int n7 = Math.max(0, (n3 - n4) / 2 - 1);
            if (AcrylInternalFrameTitlePane.this.frame.isClosable()) {
                AcrylInternalFrameTitlePane.this.closeButton.setBounds(n6 += bl ? -n5 : n, n7, n5, n4);
                if (!bl) {
                    n6 += n5;
                }
            }
            if (AcrylInternalFrameTitlePane.this.frame.isMaximizable() && !AcrylInternalFrameTitlePane.this.isPalette) {
                AcrylInternalFrameTitlePane.this.maxButton.setBounds(n6 += bl ? -n - n5 : n, n7, n5, n4);
                if (!bl) {
                    n6 += n5;
                }
            }
            if (AcrylInternalFrameTitlePane.this.frame.isIconifiable() && !AcrylInternalFrameTitlePane.this.isPalette) {
                AcrylInternalFrameTitlePane.this.iconButton.setBounds(n6 += bl ? -n - n5 : n, n7, n5, n4);
                if (!bl) {
                    n6 += n5;
                }
            }
            AcrylInternalFrameTitlePane.this.buttonsWidth = bl ? n2 - n6 : n6;
        }
    }
}

