/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.colorscheme;

import java.awt.Color;
import org.jvnet.substance.api.SchemeDerivedColors;
import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.utils.SubstanceColorUtilities;

class DerivedColorsResolverDark
implements SchemeDerivedColors {
    SubstanceColorScheme scheme;

    public DerivedColorsResolverDark(SubstanceColorScheme scheme) {
        if (!scheme.isDark()) {
            throw new IllegalArgumentException("The scheme must be dark: " + scheme.getDisplayName());
        }
        this.scheme = scheme;
    }

    @Override
    public Color getWatermarkStampColor() {
        return SubstanceColorUtilities.getAlphaColor(this.scheme.getUltraLightColor(), 30);
    }

    @Override
    public Color getWatermarkDarkColor() {
        return this.scheme.getLightColor();
    }

    @Override
    public Color getWatermarkLightColor() {
        return this.scheme.getUltraLightColor();
    }

    @Override
    public Color getLineColor() {
        return this.scheme.getMidColor();
    }

    @Override
    public Color getSelectionForegroundColor() {
        return this.scheme.getUltraDarkColor().darker();
    }

    @Override
    public Color getSelectionBackgroundColor() {
        return this.scheme.getUltraLightColor().brighter();
    }

    @Override
    public Color getBackgroundFillColor() {
        return this.scheme.getDarkColor().brighter();
    }

    @Override
    public Color getFocusRingColor() {
        return this.scheme.getUltraDarkColor();
    }

    @Override
    public Color getTextBackgroundFillColor() {
        return SubstanceColorUtilities.getInterpolatedColor(this.scheme.getMidColor(), this.scheme.getLightColor(), 0.4);
    }
}

